/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Name;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public final class Fond
extends Table {
    static final int fVersion = 0;
    static final int fCount_fond = 2;
    static final int fCount_nfnt = 4;
    static final int fUnused = 6;
    static final int fResourceID = 8;
    static final int fFamilyID = 10;
    static final int fFlags = 12;
    static final int fStyle = 14;
    static final int fScript = 16;
    static final int fLanguage = 18;
    static final int fOffset = 20;
    static final int fLength = 24;
    static final int fNameLength = 28;
    static final int fName = 29;
    static final int STYLE_BOLD = 1;
    static final int STYLE_ITALIC = 2;
    static final String[] SCRIPTID_TO_ULOCALE = new String[]{"en", "ja", "zh-Hant", "ko", "ar", "he", "el", "ru", "MacSymbol", "hi", "pa", "gu", null, null, null, null, null, null, null, null, null, "th", null, null, null, "zh-Hans", null, null, null, "MacCentralEuropean", null, null, null};

    protected Fond(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
    }

    public void subsetAndStream(Subset subset, Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(this.data);
        map.put(1718578788, oTByteArrayBuilder);
    }

    public void stream(Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.getDataAsByteArray();
        map.put(1718578788, oTByteArrayBuilder);
    }

    public OTByteArray getData() {
        return this.data;
    }

    public String getName() throws InvalidFontException {
        int n = this.data.getint16(16);
        int n2 = this.data.getint8(28);
        byte[] byArray = this.data.getBytes(29, n2);
        String string = Name.getCharsetName(1, n);
        if (string == null) {
            string = Name.getCharsetName(1, 0);
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public boolean isBold() throws InvalidFontException {
        int n = this.data.getint16(14);
        return (n & 1) != 0;
    }

    public boolean isItalic() throws InvalidFontException {
        int n = this.data.getint16(14);
        return (n & 2) != 0;
    }

    public ULocale getLocale() throws InvalidFontException {
        int n = this.data.getint16(16);
        String string = SCRIPTID_TO_ULOCALE[n = Math.min(n, SCRIPTID_TO_ULOCALE.length - 1)];
        if (string == null) {
            string = SCRIPTID_TO_ULOCALE[0];
        }
        return new ULocale(string);
    }
}

