/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LayoutTableSubsetter;
import com.adobe.fontengine.font.opentype.LookupTable;
import com.adobe.fontengine.font.opentype.OTByteArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

abstract class LookupTableSubsetter
extends LayoutTableSubsetter {
    protected final int origNumGlyphs;
    private int dummyLookupId = -1;

    LookupTableSubsetter(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n) {
        super(layoutTable, oTByteArrayBuilder);
        this.origNumGlyphs = n;
    }

    abstract void gatherCoveragesForSubtable(int var1, int var2, int var3, Integer var4, Map var5, Map var6, Subset var7) throws InvalidFontException, UnsupportedFontException;

    abstract int getExtensionSubtableSize();

    abstract int writeSubtable(int var1, int var2, Map var3, int var4, Subset var5, LookupSubset var6) throws InvalidFontException, UnsupportedFontException;

    abstract void patchSubtableCoverage(int var1, int var2, Map var3, int var4) throws InvalidFontException;

    abstract int getExtensionLookupType();

    abstract int writeExtensionSubtable(int var1, int var2);

    abstract void patchExtensionOffset(int var1, int var2);

    abstract int getReferencedLookupType(int var1) throws InvalidFontException;

    abstract int getReferencedSubtableOffset(int var1) throws InvalidFontException, UnsupportedFontException;

    abstract boolean mustKeepFeature(int var1) throws InvalidFontException;

    protected void gatherCoverages(int n, Map map, Map map2, Subset subset, List list) throws InvalidFontException, UnsupportedFontException {
        int n2 = ((LookupTable)this.origTable).getLookupListOffset();
        int n3 = this.origTable.data.getOffset(n2, 2 + 2 * n);
        for (int i = 0; i < list.size(); ++i) {
            int n4 = this.origTable.data.getuint16(n3);
            Integer n5 = (Integer)list.get(i);
            int n6 = this.origTable.data.getOffset(n3, 6 + 2 * n5);
            this.gatherCoveragesForSubtable(n6, n4, n, n5, map, map2, subset);
        }
    }

    private void moveCoveragesForLookup(int n, Map map, Map map2) {
        for (Integer n2 : map.keySet()) {
            NewCoverage newCoverage;
            NewCoverage newCoverage2 = (NewCoverage)map.get(n2);
            Integer n3 = new Integer(n);
            if (!newCoverage2.referringOrigLookups.containsKey(n3)) continue;
            if (map2.containsKey(n2)) {
                newCoverage = (NewCoverage)map2.get(n2);
                newCoverage.referringOrigLookups.put(n3, newCoverage2.referringOrigLookups.get(n3));
            } else {
                newCoverage = new NewCoverage();
                newCoverage.glyphCount = newCoverage2.glyphCount;
                newCoverage.newCoverage = newCoverage2.newCoverage;
                newCoverage.referringOrigLookups.put(n3, newCoverage2.referringOrigLookups.get(n3));
                map2.put(n2, newCoverage);
            }
            newCoverage2.referringOrigLookups.remove(n3);
        }
    }

    protected static void addToCoveragesMap(LayoutTable layoutTable, int n, Map map, int n2, Integer n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
        Integer n4 = new Integer(n);
        if (!map.containsKey(n4)) {
            NewCoverage newCoverage = new NewCoverage();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(n3);
            newCoverage.referringOrigLookups.put(new Integer(n2), hashSet);
            LayoutTableSubsetter.CoverageGenerator coverageGenerator = LayoutTableSubsetter.CoverageGenerator.newInstance(layoutTable, n, subset);
            newCoverage.newCoverage = coverageGenerator.generateCoverage().toOTByteArray();
            newCoverage.glyphCount = coverageGenerator.numGlyphsFound;
            map.put(n4, newCoverage);
        } else {
            NewCoverage newCoverage = (NewCoverage)map.get(n4);
            Integer n5 = new Integer(n2);
            if (newCoverage.referringOrigLookups.containsKey(n5)) {
                Set set = (Set)newCoverage.referringOrigLookups.get(n5);
                set.add(n3);
            } else {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                hashSet.add(n3);
                newCoverage.referringOrigLookups.put(new Integer(n2), hashSet);
            }
        }
    }

    private int getLookupOffset(int n, int n2) throws InvalidFontException {
        return this.origTable.data.getOffset(n, 2 + 2 * n2);
    }

    private void patchCoverages(int n, int n2, List list, List list2, Map map) throws InvalidFontException {
        int n3 = this.getLookupOffset(n, n2);
        int n4 = this.origTable.data.getuint16(n3);
        for (int i = 0; i < list.size(); ++i) {
            int n5 = (Integer)list.get(i);
            this.patchSubtableCoverage(this.origTable.data.getOffset(n3, 6 + 2 * n5), (Integer)list2.get(i), map, n4);
        }
    }

    private void patchExtensionCoverages(int n, List list, List list2, Map map) throws InvalidFontException, UnsupportedFontException {
        for (int i = 0; i < list.size(); ++i) {
            int n2 = (Integer)list.get(i);
            int n3 = this.origTable.data.getOffset(n, 6 + 2 * n2);
            int n4 = this.origTable.data.getuint16(n);
            if (n4 == this.getExtensionLookupType()) {
                n4 = this.getReferencedLookupType(n3);
                n3 = this.getReferencedSubtableOffset(n3);
            }
            this.patchSubtableCoverage(n3, (Integer)list2.get(i), map, n4);
        }
    }

    private int writeLookup(int n, Map map, int n2, List list, Subset subset, List list2, LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
        int n3 = list.size();
        int n4 = 6 + 2 * n3;
        this.builder.ensureCapacity(n + n4);
        int n5 = this.origTable.data.getuint16(n2);
        this.builder.setuint16(n, n5);
        this.builder.setuint16(n + 2, this.origTable.data.getuint16(n2 + 2));
        this.builder.setuint16(n + 4, n3);
        for (int i = 0; i < n3; ++i) {
            int n6 = (Integer)list.get(i);
            this.builder.setuint16(n + 6 + 2 * i, n4);
            list2.add(i, new Integer(n + n4));
            n4 += this.writeSubtable(this.origTable.data.getOffset(n2, 6 + 2 * n6), n + n4, map, n5, subset, lookupSubset);
        }
        return n4;
    }

    private int writeLookupAsExtension(int n, int n2, List list, List list2) throws InvalidFontException, UnsupportedFontException {
        int n3 = list.size();
        int n4 = 6 + 2 * n3;
        int n5 = this.origTable.data.getuint16(n2);
        boolean bl = n5 == this.getExtensionLookupType();
        this.builder.setuint16(n, this.getExtensionLookupType());
        this.builder.setuint16(n + 2, this.origTable.data.getuint16(n2 + 2));
        this.builder.setuint16(n + 4, n3);
        for (int i = 0; i < n3; ++i) {
            int n6 = (Integer)list.get(i);
            this.builder.setuint16(n + 6 + 2 * i, n4);
            list2.add(i, new Integer(n + n4));
            if (bl) {
                n4 += this.writeSubtable(this.origTable.data.getOffset(n2, 6 + 2 * n6), n + n4, null, n5, null, null);
                continue;
            }
            n4 += this.writeExtensionSubtable(n + n4, n5);
        }
        return n4;
    }

    private int writeExtensionSubtables(int n, List list, Map map, int n2, List list2, Subset subset, LookupSubset lookupSubset, int n3, int n4) throws InvalidFontException, UnsupportedFontException {
        int n5 = 0;
        for (int i = 0; i < list2.size(); ++i) {
            int n6 = (Integer)list.get(i);
            int n7 = this.origTable.data.getOffset(n2, 6 + 2 * (Integer)list2.get(i));
            this.patchExtensionOffset(n6, n + n5);
            list.set(i, new Integer(n + n5));
            int n8 = n3;
            if (n3 == this.getExtensionLookupType()) {
                n8 = this.getReferencedLookupType(n7);
                n7 = this.getReferencedSubtableOffset(n7);
            }
            n5 += this.writeSubtable(n7, n + n5, map, n8, subset, lookupSubset);
            for (Integer n9 : map.keySet()) {
                NewCoverage newCoverage = (NewCoverage)map.get(n9);
                if (newCoverage.getMaxReferringOrigLookup() != n4 || newCoverage.getMaxSubtable(n4) != ((Integer)list2.get(i)).intValue()) continue;
                newCoverage.newOffset = n + n5;
                n5 += this.writeByteArrayAtOffset(n + n5, newCoverage.newCoverage);
            }
        }
        return n5;
    }

    private int writeDummyLookup(int n) {
        this.builder.ensureCapacity(n + 6);
        this.builder.setuint16(n, 0);
        this.builder.setuint16(n + 2, 0);
        this.builder.setuint16(n + 2, 0);
        return 6;
    }

    protected int buildLookupList(int n, int n2, LookupSubset lookupSubset, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 2 + 2 * lookupSubset.getNumGlyphs() + (this.dummyLookupId == -1 ? 0 : 2);
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.builder.ensureCapacity(n2 + n9);
        this.builder.setuint16(n2, lookupSubset.getNumGlyphs() + (this.dummyLookupId == -1 ? 0 : 1));
        int n10 = 0;
        for (n8 = 0; n8 < lookupSubset.getNumGlyphs(); ++n8) {
            List list = lookupSubset.getSubtables(lookupSubset.getFullGid(n8));
            n10 += list.size();
            this.gatherCoverages(lookupSubset.getFullGid(n8), hashMap, hashMap2, subset, list);
        }
        n8 = 0;
        for (Object e : hashMap.keySet()) {
            NewCoverage newCoverage = (NewCoverage)hashMap.get(e);
            n8 += newCoverage.newCoverage.getSize();
        }
        int n11 = 0;
        int n12 = 0;
        List[] listArray = new List[lookupSubset.getNumGlyphs()];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n7 = 0; n7 < lookupSubset.getNumGlyphs(); ++n7) {
            listArray[n7] = new ArrayList();
            List list = lookupSubset.getSubtables(lookupSubset.getFullGid(n7));
            n6 = this.getLookupOffset(n, lookupSubset.getFullGid(n7));
            this.builder.setuint16(n2 + 2 + 2 * n7, n9);
            if (this.origTable.data.getuint16(n6) == this.getExtensionLookupType()) {
                arrayList.add(new Integer(n7));
            }
            n5 = this.writeLookup(n2 + n9, hashMap, n6, list, subset, listArray[n7], lookupSubset);
            n4 = list.size();
            n3 = n12 + n5 + (lookupSubset.getNumGlyphs() - (n7 + 1)) * 6 + (this.dummyLookupId == -1 ? 0 : 6) + (n10 - (n11 + n4)) * (this.getExtensionSubtableSize() + 2) + n8;
            if (n3 > maxOffset) break;
            n11 += n4;
            n12 += n5;
            n9 += n5;
        }
        if (n7 < lookupSubset.getNumGlyphs()) {
            while (n7 < lookupSubset.getNumGlyphs()) {
                listArray[n7] = new ArrayList();
                int n13 = this.getLookupOffset(n, lookupSubset.getFullGid(n7));
                List list = lookupSubset.getSubtables(lookupSubset.getFullGid(n7));
                this.builder.setuint16(n2 + 2 + 2 * n7, n9);
                n9 += this.writeLookupAsExtension(n2 + n9, n13, list, listArray[n7]);
                arrayList.add(new Integer(n7));
                this.moveCoveragesForLookup(lookupSubset.getFullGid(n7), hashMap, hashMap2);
                ++n7;
            }
        }
        for (Integer n14 : hashMap.keySet()) {
            NewCoverage newCoverage = (NewCoverage)hashMap.get(n14);
            if (newCoverage.referringOrigLookups.isEmpty()) continue;
            newCoverage.newOffset = n2 + n9;
            n9 += this.writeByteArrayAtOffset(n2 + n9, newCoverage.newCoverage);
        }
        for (n7 = 0; n7 < listArray.length; ++n7) {
            if (arrayList.contains(new Integer(n7))) continue;
            this.patchCoverages(n, lookupSubset.getFullGid(n7), lookupSubset.getSubtables(lookupSubset.getFullGid(n7)), listArray[n7], hashMap);
        }
        if (this.dummyLookupId != -1) {
            this.builder.setuint16(n2 + 2 + 2 * this.dummyLookupId, n9);
            n9 += this.writeDummyLookup(n2 + n9);
        }
        for (n7 = 0; n7 < arrayList.size(); ++n7) {
            n6 = (Integer)arrayList.get(n7);
            List list = lookupSubset.getSubtables(lookupSubset.getFullGid(n6));
            n4 = this.getLookupOffset(n, lookupSubset.getFullGid(n6));
            n3 = this.origTable.data.getuint16(n4);
            n9 += this.writeExtensionSubtables(n2 + n9, listArray[n6], hashMap2, n4, list, subset, lookupSubset, n3, lookupSubset.getFullGid(n6));
        }
        for (n7 = 0; n7 < arrayList.size(); ++n7) {
            n6 = (Integer)arrayList.get(n7);
            n5 = this.getLookupOffset(n, lookupSubset.getFullGid(n6));
            List list = lookupSubset.getSubtables(lookupSubset.getFullGid(n6));
            this.patchExtensionCoverages(n5, list, listArray[n6], hashMap2);
        }
        return n9;
    }

    OTByteArray.OTByteArrayBuilder subsetAndStream(TreeMap treeMap, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int n = this.origTable.data.getOffset(0, 6);
        LookupSubset lookupSubset = new LookupSubset(treeMap, this.origTable.data.getuint16(((LookupTable)this.origTable).getLookupListOffset()));
        FeatureSubset featureSubset = new FeatureSubset(this, this.origTable.data, n, treeMap);
        this.builder.setuint32(0, 65536);
        int n2 = this.origTable.data.getOffset(0, 4);
        int n3 = 10;
        this.builder.setuint16(4, n3);
        n3 += this.buildScriptList(n2, n3, featureSubset, lookupSubset);
        this.builder.setuint16(6, n3);
        n3 += this.buildFeatureList(n, n3, featureSubset, lookupSubset);
        n2 = this.origTable.data.getOffset(0, 8);
        this.builder.setuint16(8, n3);
        this.buildLookupList(n2, n3, lookupSubset, subset);
        return this.builder;
    }

    private int buildScriptList(int n, int n2, FeatureSubset featureSubset, LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
        int n3 = this.origTable.data.getuint16(n);
        int n4 = 2;
        this.builder.ensureCapacity(n2 + (n4 += n3 * 6));
        this.builder.setuint16(n2, n3);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.builder.setuint8(n2 + 2 + 6 * i + j, this.origTable.data.getint8(n + 2 + 6 * i + j));
            }
            this.builder.setuint16(n2 + 2 + 6 * i + 4, n4);
            n4 += this.writeScript(this.origTable.data.getOffset(n, 2 + 6 * i + 4), featureSubset, n2 + n4, lookupSubset);
        }
        return n4;
    }

    private int writeScript(int n, FeatureSubset featureSubset, int n2, LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
        int n3 = 0;
        int n4 = this.origTable.data.getuint16(n + 2);
        this.builder.ensureCapacity(n2 + (n3 += 4 + n4 * 6));
        this.builder.setuint16(n2 + 2, n4);
        int n5 = this.origTable.data.getOffset(n, 0);
        if (n5 != 0) {
            this.builder.setuint16(n2, n3);
            n3 += this.writeLangSys(n5, featureSubset, n2 + n3, lookupSubset);
        } else {
            this.builder.setuint16(n2, 0);
        }
        for (int i = 0; i < n4; ++i) {
            this.builder.setuint16(n2 + 4 + 6 * i + 4, n3);
            for (int j = 0; j < 4; ++j) {
                this.builder.setuint8(n2 + 4 + 6 * i + j, this.origTable.data.getint8(n + 4 + 6 * i + j));
            }
            n3 += this.writeLangSys(this.origTable.data.getOffset(n, 4 + 6 * i + 4), featureSubset, n2 + n3, lookupSubset);
        }
        return n3;
    }

    private int writeLangSys(int n, FeatureSubset featureSubset, int n2, LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
        int n3;
        int n4;
        int n5 = this.origTable.data.getuint16(n + 4);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n6 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = this.origTable.data.getuint16(n + 6 + 2 * n4);
            if (featureSubset.getExistingSubsetGid(n3) == -1) continue;
            arrayList.add(new Integer(n4));
        }
        this.builder.ensureCapacity(n2 + (n6 += 6 + 2 * arrayList.size()));
        this.builder.setuint16(n2, 0);
        n4 = this.origTable.data.getuint16(n + 2);
        if (n4 != 65535 && featureSubset.getExistingSubsetGid(n4) != -1) {
            this.builder.setuint16(n2 + 2, featureSubset.getExistingSubsetGid(n4));
        } else {
            this.builder.setuint16(n2 + 2, 65535);
        }
        this.builder.setuint16(n2 + 4, arrayList.size());
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            int n7 = (Integer)arrayList.get(n3);
            int n8 = this.origTable.data.getuint16(n + 6 + 2 * n7);
            int n9 = featureSubset.getExistingSubsetGid(n8);
            this.builder.setuint16(n2 + 6 + 2 * n3, n9);
        }
        return n6;
    }

    private int buildFeatureList(int n, int n2, FeatureSubset featureSubset, LookupSubset lookupSubset) throws InvalidFontException {
        int n3 = 2 + 6 * featureSubset.getNumGlyphs();
        this.builder.ensureCapacity(n2 + n3);
        this.builder.setuint16(n2, featureSubset.getNumGlyphs());
        for (int i = 0; i < featureSubset.getNumGlyphs(); ++i) {
            int n4 = featureSubset.getFullGid(i);
            for (int j = 0; j < 4; ++j) {
                this.builder.setuint8(n2 + 2 + 6 * i + j, this.origTable.data.getint8(n + 2 + 6 * n4 + j));
            }
            this.builder.setuint16(n2 + 2 + 6 * i + 4, n3);
            n3 += this.writeFeature(this.origTable.data.getOffset(n, 2 + 6 * n4 + 4), n2 + n3, lookupSubset);
        }
        return n3;
    }

    private int writeFeature(int n, int n2, LookupSubset lookupSubset) throws InvalidFontException {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = this.origTable.data.getuint16(n + 2);
        int n7 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = this.origTable.data.getuint16(n + 4 + 2 * n4);
            if (lookupSubset.getExistingSubsetGid(n3) == -1) continue;
            ++n7;
        }
        if (n6 > 0 && n7 == 0) {
            ++n7;
            if (this.dummyLookupId == -1) {
                this.dummyLookupId = lookupSubset.getNumGlyphs();
            }
        }
        this.builder.ensureCapacity(n2 + (n5 += 4 + 2 * n7));
        this.builder.setuint16(n2, 0);
        this.builder.setuint16(n2 + 2, n7);
        n4 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            int n8 = this.origTable.data.getuint16(n + 4 + 2 * n3);
            int n9 = lookupSubset.getExistingSubsetGid(n8);
            if (n9 == -1) continue;
            this.builder.setuint16(n2 + 4 + 2 * n4, n9);
            ++n4;
        }
        if (n6 > 0 && n7 == 0) {
            this.builder.setuint16(n2 + 4, this.dummyLookupId);
        }
        return n5;
    }

    protected static void patchCoverageAtOffset(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, int n3, Map map) throws InvalidFontException {
        Integer n4 = new Integer(layoutTable.data.getOffset(n, n3));
        NewCoverage newCoverage = (NewCoverage)map.get(n4);
        if (newCoverage.newOffset - n2 > 65535) {
            throw new RuntimeException("New coverage offset is out of range!");
        }
        if (newCoverage.newOffset < n2) {
            throw new RuntimeException("New coverage written out before subtable!");
        }
        oTByteArrayBuilder.setuint16(n2 + n3, newCoverage.newOffset - n2);
    }

    static class LookupSubset
    extends SubsetDefaultImpl {
        final TreeMap lookupsToKeep;

        LookupSubset(TreeMap treeMap, int n) throws InvalidFontException, UnsupportedFontException {
            super(n, true);
            this.lookupsToKeep = treeMap;
            for (Integer n2 : treeMap.keySet()) {
                this.getSubsetGid(n2);
            }
        }

        List getSubtables(int n) {
            return (List)this.lookupsToKeep.get(new Integer(n));
        }
    }

    static class FeatureSubset
    extends SubsetDefaultImpl {
        FeatureSubset(LookupTableSubsetter lookupTableSubsetter, OTByteArray oTByteArray, int n, Map map) throws InvalidFontException, UnsupportedFontException {
            super(oTByteArray.getuint16(n), true);
            int n2 = oTByteArray.getuint16(n);
            for (int i = 0; i < n2; ++i) {
                int n3 = oTByteArray.getOffset(n, 2 + 6 * i + 4);
                if (!this.featureContainsLookups(oTByteArray, n3, map) && !lookupTableSubsetter.mustKeepFeature(n + 2 + 6 * i)) continue;
                this.getSubsetGid(i);
            }
        }

        private boolean featureContainsLookups(OTByteArray oTByteArray, int n, Map map) throws InvalidFontException {
            int n2 = oTByteArray.getuint16(n + 2);
            for (int i = 0; i < n2; ++i) {
                int n3 = oTByteArray.getuint16(n + 4 + 2 * i);
                if (!map.containsKey(new Integer(n3))) continue;
                return true;
            }
            return false;
        }
    }

    protected static class NewCoverage {
        int newOffset = -1;
        OTByteArray newCoverage = null;
        int glyphCount = 0;
        Map referringOrigLookups = new HashMap();

        protected NewCoverage() {
        }

        int getMaxReferringOrigLookup() {
            Iterator iterator = this.referringOrigLookups.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (n >= n2) continue;
                n = n2;
            }
            return n;
        }

        int getMaxSubtable(int n) {
            Set set = (Set)this.referringOrigLookups.get(new Integer(n));
            int n2 = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                if (n2 >= n3) continue;
                n2 = n3;
            }
            return n2;
        }
    }

    static interface LookupSubtableGenerator {
        public int writeSubtable() throws InvalidFontException, UnsupportedFontException;
    }
}

