/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.VmtxRaw;
import java.util.Map;

public final class Vmtx
extends Table {
    protected final int numberOfVMetrics;
    protected final VmtxRaw vmtx;

    protected Vmtx(VmtxRaw vmtxRaw, int n) {
        this.vmtx = vmtxRaw;
        this.numberOfVMetrics = n;
    }

    public int getTopSideBearing(int n) throws InvalidFontException {
        return this.vmtx.getTopSideBearing(n, this.numberOfVMetrics);
    }

    public int getHorizontalAdvance(int n) throws InvalidFontException {
        return this.vmtx.getVerticalAdvance(n, this.numberOfVMetrics);
    }

    public void subsetAndStream(Subset subset, Map map) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(subset.getNumGlyphs() * 4);
        int n = 0;
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            int n2 = subset.getFullGid(i);
            oTByteArrayBuilder.setuint16(n, this.getHorizontalAdvance(n2));
            oTByteArrayBuilder.setint16(n + 2, this.getTopSideBearing(n2));
            n += 4;
        }
        map.put(new Integer(1986884728), oTByteArrayBuilder);
    }

    public void stream(Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.vmtx.getDataAsByteArray();
        map.put(new Integer(1986884728), oTByteArrayBuilder);
    }
}

