/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.postscript.Reader;
import java.io.IOException;

final class BinaryEexecReader
implements Reader {
    private int lastRead;
    private int lastCipher;
    private int cipherR = 55665;

    BinaryEexecReader() {
    }

    public int read(FontInputStream fontInputStream) throws IOException, InvalidFontException {
        this.lastRead = fontInputStream.read();
        if (this.lastRead == -1) {
            throw new InvalidFontException("unexpected end of file");
        }
        this.lastCipher = this.cipherR;
        int n = this.decryptByte((byte)this.lastRead);
        return n;
    }

    public void unreadLast(FontInputStream fontInputStream) throws IOException {
        this.cipherR = this.lastCipher;
        fontInputStream.unread(this.lastRead);
    }

    public int decryptByte(byte by) {
        byte by2 = (byte)(by ^ this.cipherR >> 8);
        this.cipherR = ((by & 0xFF) + this.cipherR) * 52845 + 22719 & 0xFFFF;
        return by2 & 0xFF;
    }

    int decryptBuffer(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byArray[n2++] = (byte)this.decryptByte(byArray[i]);
        }
        return n2;
    }
}

