/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.fxg;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontDescription;
import com.adobe.fontengine.fontmanagement.Platform;

public final class FXGFontDescription
extends FontDescription {
    static final long serialVersionUID = 1L;
    private final Platform platform;
    private final ULocale locale;
    private final String familyName;
    private final boolean isBold;
    private final boolean isItalic;

    public FXGFontDescription(Platform platform, ULocale uLocale, String string, boolean bl, boolean bl2) {
        if (platform == null || uLocale == null || string == null) {
            throw new NullPointerException("Platform, Locale, and Platform Name must not be null");
        }
        this.platform = platform;
        this.locale = uLocale;
        this.familyName = string;
        this.isBold = bl;
        this.isItalic = bl2;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.isBold ? 1231 : 1237);
        n = 31 * n + (this.isItalic ? 1231 : 1237);
        n = 31 * n + this.locale.hashCode();
        n = 31 * n + this.platform.hashCode();
        n = 31 * n + this.familyName.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FXGFontDescription)) {
            return false;
        }
        FXGFontDescription fXGFontDescription = (FXGFontDescription)object;
        if (this.isBold != fXGFontDescription.isBold) {
            return false;
        }
        if (this.isItalic != fXGFontDescription.isItalic) {
            return false;
        }
        if (this.locale == null ? fXGFontDescription.locale != null : !this.locale.equals((Object)fXGFontDescription.locale)) {
            return false;
        }
        if (this.platform == null ? fXGFontDescription.platform != null : !this.platform.equals(fXGFontDescription.platform)) {
            return false;
        }
        return !(this.familyName == null ? fXGFontDescription.familyName != null : !this.familyName.equals(fXGFontDescription.familyName));
    }

    public String toString() {
        return new String("[" + this.platform + ", " + this.locale + "] - " + this.familyName + (this.isBold ? ", bold" : "") + (this.isItalic ? ", italic" : ""));
    }
}

