/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGAltGlyphHandler;
import org.apache.batik.bridge.SVGFontFamily;
import org.apache.batik.bridge.SVGFontUtilities;
import org.apache.batik.bridge.SVGTextPathElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGTextContent;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SVGTextElementBridge
extends AbstractGraphicsNodeBridge
implements SVGTextContent {
    protected static final Integer ZERO = new Integer(0);
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    public static final AttributedCharacterIterator.Attribute ALT_GLYPH_HANDLER = GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER;
    protected AttributedString laidoutText;
    protected WeakHashMap elemTPI = new WeakHashMap();
    protected boolean usingComplexSVGFont = false;
    protected DOMChildNodeRemovedEventListener childNodeRemovedEventListener = new DOMChildNodeRemovedEventListener();
    protected DOMSubtreeModifiedEventListener subtreeModifiedEventListener = new DOMSubtreeModifiedEventListener();
    private boolean hasNewACI;
    private Element cssProceedElement;
    protected int endLimit;

    public String getLocalName() {
        return "text";
    }

    public Bridge getInstance() {
        return new SVGTextElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        TextNode node = (TextNode)super.createGraphicsNode(ctx, e);
        if (node == null) {
            return null;
        }
        if (ctx.getTextPainter() != null) {
            node.setTextPainter(ctx.getTextPainter());
        }
        RenderingHints hints = null;
        hints = CSSUtilities.convertColorRendering(e, hints);
        if ((hints = CSSUtilities.convertTextRendering(e, hints)) != null) {
            node.setRenderingHints(hints);
        }
        node.setLocation(this.getLocation(ctx, e));
        return node;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new TextNode();
    }

    protected Point2D getLocation(BridgeContext ctx, Element e) {
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
        String s = e.getAttributeNS(null, "x");
        float x = 0.0f;
        if (s.length() != 0) {
            StringTokenizer st = new StringTokenizer(s, ", ", false);
            x = UnitProcessor.svgHorizontalCoordinateToUserSpace(st.nextToken(), "x", uctx);
        }
        s = e.getAttributeNS(null, "y");
        float y = 0.0f;
        if (s.length() != 0) {
            StringTokenizer st = new StringTokenizer(s, ", ", false);
            y = UnitProcessor.svgVerticalCoordinateToUserSpace(st.nextToken(), "y", uctx);
        }
        return new Point2D.Float(x, y);
    }

    protected boolean isTextElement(Element e) {
        if (!"http://www.w3.org/2000/svg".equals(e.getNamespaceURI())) {
            return false;
        }
        String nodeName = e.getLocalName();
        return nodeName.equals("text") || nodeName.equals("tspan") || nodeName.equals("altGlyph") || nodeName.equals("a") || nodeName.equals("textPath") || nodeName.equals("tref");
    }

    protected boolean isTextChild(Element e) {
        if (!"http://www.w3.org/2000/svg".equals(e.getNamespaceURI())) {
            return false;
        }
        String nodeName = e.getLocalName();
        return nodeName.equals("tspan") || nodeName.equals("altGlyph") || nodeName.equals("a") || nodeName.equals("textPath") || nodeName.equals("tref");
    }

    public void buildGraphicsNode(BridgeContext ctx, Element e, GraphicsNode node) {
        e.normalize();
        this.computeLaidoutText(ctx, e, node);
        node.setComposite(CSSUtilities.convertOpacity(e));
        node.setFilter(CSSUtilities.convertFilter(e, node, ctx));
        node.setMask(CSSUtilities.convertMask(e, node, ctx));
        node.setClip(CSSUtilities.convertClipPath(e, node, ctx));
        node.setPointerEventType(CSSUtilities.convertPointerEvents(e));
        this.initializeDynamicSupport(ctx, e, node);
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext ctx, Element e, GraphicsNode node) {
        super.initializeDynamicSupport(ctx, e, node);
        if (!ctx.isDynamic()) {
            return;
        }
        EventTarget evtTarget = (EventTarget)((Object)e);
        evtTarget.addEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        ctx.storeEventListener(evtTarget, "DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        evtTarget.addEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        ctx.storeEventListener(evtTarget, "DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        for (Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            this.addContextToChild(ctx, (Element)child);
        }
    }

    protected void addContextToChild(BridgeContext ctx, Element e) {
        if ("http://www.w3.org/2000/svg".equals(e.getNamespaceURI())) {
            if (e.getLocalName().equals("tspan")) {
                ((SVGOMElement)e).setSVGContext(new TspanBridge(ctx, this, e));
            } else if (e.getLocalName().equals("textPath")) {
                ((SVGOMElement)e).setSVGContext(new TextPathBridge(ctx, this, e));
            } else if (e.getLocalName().equals("tref")) {
                ((SVGOMElement)e).setSVGContext(new TRefBridge(ctx, this, e));
            }
        }
        for (Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            this.addContextToChild(ctx, (Element)child);
        }
    }

    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
        Node childNode = (Node)((Object)evt.getTarget());
        switch (childNode.getNodeType()) {
            case 3: 
            case 4: {
                this.laidoutText = null;
                break;
            }
            case 1: {
                Element childElement = (Element)childNode;
                if (!this.isTextChild(childElement)) break;
                this.addContextToChild(this.ctx, childElement);
                this.laidoutText = null;
                break;
            }
        }
        if (this.laidoutText == null) {
            this.computeLaidoutText(this.ctx, this.e, this.node);
        }
    }

    public void handleDOMNodeRemovedEvent(MutationEvent evt) {
        EventTarget evtTarget = evt.getTarget();
        evtTarget.removeEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        evtTarget.removeEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        super.handleDOMNodeRemovedEvent(evt);
    }

    public void handleDOMChildNodeRemovedEvent(MutationEvent evt) {
        Node childNode = (Node)((Object)evt.getTarget());
        switch (childNode.getNodeType()) {
            case 3: 
            case 4: {
                if (!this.isParentDisplayed(childNode)) break;
                this.laidoutText = null;
                break;
            }
            case 1: {
                if (!this.isTextChild((Element)childNode)) break;
                this.laidoutText = null;
                break;
            }
        }
    }

    public void handleDOMSubtreeModifiedEvent(MutationEvent evt) {
        if (this.laidoutText == null) {
            this.computeLaidoutText(this.ctx, this.e, this.node);
        }
    }

    public void handleDOMCharacterDataModified(MutationEvent evt) {
        Node childNode = (Node)((Object)evt.getTarget());
        if (this.isParentDisplayed(childNode)) {
            this.laidoutText = null;
        }
    }

    protected boolean isParentDisplayed(Node childNode) {
        Node parentNode = childNode.getParentNode();
        return this.isTextElement((Element)parentNode);
    }

    protected void computeLaidoutText(BridgeContext ctx, Element e, GraphicsNode node) {
        AttributedString as = this.buildAttributedString(ctx, e);
        this.addGlyphPositionAttributes(as, e, ctx);
        if (ctx.isDynamic()) {
            this.laidoutText = new AttributedString(as.getIterator());
        }
        TextNode tn = (TextNode)node;
        this.elemTPI.clear();
        this.addNullPaintAttributes(as, e, ctx);
        tn.setAttributedCharacterIterator(as.getIterator());
        TextPaintInfo pi = new TextPaintInfo();
        this.setBaseTextPaintInfo(pi, e, node, ctx);
        this.setDecorationTextPaintInfo(pi, e);
        this.addPaintAttributes(as, e, tn, pi, ctx);
        if (this.usingComplexSVGFont) {
            tn.setAttributedCharacterIterator(as.getIterator());
        }
    }

    protected void addNullPaintAttributes(AttributedString as, Element element, BridgeContext ctx) {
        if (!SVGUtilities.matchUserAgent(element, ctx.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        AttributedCharacterIterator aci = as.getIterator();
        int firstChar = this.getElementStartIndex(aci, element);
        if (firstChar == -1) {
            return;
        }
        int lastChar = this.getElementEndIndex(aci, element);
        TextPaintInfo pi = new TextPaintInfo();
        pi.visible = true;
        pi.fillPaint = Color.black;
        as.addAttribute(PAINT_INFO, pi, firstChar, lastChar + 1);
        this.elemTPI.put(element, pi);
        this.addChildNullPaintAttributes(as, element, ctx);
    }

    protected void addChildNullPaintAttributes(AttributedString as, Element element, BridgeContext ctx) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            if (child.getNodeType() != 1 || !this.isTextChild(childElement = (Element)child)) continue;
            this.addNullPaintAttributes(as, childElement, ctx);
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("x") || attrName.equals("y") || attrName.equals("dx") || attrName.equals("dy") || attrName.equals("rotate")) {
            if (attrName.equals("x") || attrName.equals("y")) {
                ((TextNode)this.node).setLocation(this.getLocation(this.ctx, this.e));
            }
            this.computeLaidoutText(this.ctx, this.e, this.node);
        } else {
            super.handleDOMAttrModifiedEvent(evt);
        }
    }

    public void handleCSSEngineEvent(CSSEngineEvent evt) {
        this.hasNewACI = false;
        int[] properties = evt.getProperties();
        block3: for (int i = 0; i < properties.length; ++i) {
            switch (properties[i]) {
                case 1: 
                case 11: 
                case 12: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 32: 
                case 53: 
                case 56: 
                case 58: 
                case 59: {
                    if (this.hasNewACI) continue block3;
                    this.hasNewACI = true;
                    this.computeLaidoutText(this.ctx, this.e, this.node);
                }
            }
        }
        this.cssProceedElement = evt.getElement();
        super.handleCSSEngineEvent(evt);
        this.cssProceedElement = null;
    }

    protected void handleCSSPropertyChanged(int property) {
        switch (property) {
            case 15: 
            case 16: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                this.rebuildACI();
                break;
            }
            case 57: {
                this.rebuildACI();
                super.handleCSSPropertyChanged(property);
                break;
            }
            case 55: {
                RenderingHints hints = this.node.getRenderingHints();
                hints = CSSUtilities.convertTextRendering(this.e, hints);
                if (hints == null) break;
                this.node.setRenderingHints(hints);
                break;
            }
            case 9: {
                RenderingHints hints = this.node.getRenderingHints();
                hints = CSSUtilities.convertColorRendering(this.e, hints);
                if (hints == null) break;
                this.node.setRenderingHints(hints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(property);
            }
        }
    }

    protected void rebuildACI() {
        TextPaintInfo oldPI;
        TextPaintInfo pi;
        if (this.hasNewACI) {
            return;
        }
        TextNode tn = (TextNode)this.node;
        if (this.cssProceedElement == this.e) {
            pi = new TextPaintInfo();
            this.setBaseTextPaintInfo(pi, this.e, this.node, this.ctx);
            this.setDecorationTextPaintInfo(pi, this.e);
            oldPI = (TextPaintInfo)this.elemTPI.get(this.e);
        } else {
            TextPaintInfo parentPI = this.getParentTextPaintInfo(tn.getAttributedCharacterIterator(), this.cssProceedElement);
            pi = this.getTextPaintInfo(this.cssProceedElement, tn, parentPI, this.ctx);
            oldPI = (TextPaintInfo)this.elemTPI.get(this.cssProceedElement);
        }
        if (oldPI == null) {
            return;
        }
        tn.swapTextPaintInfo(pi, oldPI);
        if (this.usingComplexSVGFont) {
            tn.setAttributedCharacterIterator(tn.getAttributedCharacterIterator());
        }
    }

    int getElementStartIndex(AttributedCharacterIterator aci, Element element) {
        int i = 0;
        while (i < aci.getEndIndex()) {
            aci.setIndex(i);
            Element delimeter = (Element)aci.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (delimeter == element || this.nodeAncestorOf(element, delimeter)) {
                return i;
            }
            i = aci.getRunLimit(TEXT_COMPOUND_DELIMITER);
        }
        return -1;
    }

    int getElementEndIndex(AttributedCharacterIterator aci, Element element) {
        int i = aci.getEndIndex() - 1;
        while (i >= 0) {
            aci.setIndex(i);
            Element delimeter = (Element)aci.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (delimeter == element || this.nodeAncestorOf(element, delimeter)) {
                return i;
            }
            i = aci.getRunStart(TEXT_COMPOUND_DELIMITER) - 1;
        }
        return -1;
    }

    protected AttributedString buildAttributedString(BridgeContext ctx, Element element) {
        AttributedStringBuffer asb = new AttributedStringBuffer();
        this.fillAttributedStringBuffer(ctx, element, true, null, null, asb);
        return asb.toAttributedString();
    }

    protected void fillAttributedStringBuffer(BridgeContext ctx, Element element, boolean top, TextPath textPath, Integer bidiLevel, AttributedStringBuffer asb) {
        if (!SVGUtilities.matchUserAgent(element, ctx.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        String s = XMLSupport.getXMLSpace(element);
        boolean preserve = s.equals("preserve");
        Element nodeElement = element;
        if (top) {
            this.endLimit = 0;
        }
        if (preserve) {
            this.endLimit = asb.length();
        }
        Map map = this.getAttributeMap(ctx, element, textPath, bidiLevel);
        Object o = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer subBidiLevel = bidiLevel;
        if (o != null) {
            subBidiLevel = (Integer)o;
        }
        block4: for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            boolean prevEndsWithSpace = preserve ? false : (asb.length() == 0 ? true : asb.getLastChar() == 32);
            switch (n.getNodeType()) {
                case 1: {
                    if (!"http://www.w3.org/2000/svg".equals(n.getNamespaceURI())) continue block4;
                    nodeElement = (Element)n;
                    String ln = n.getLocalName();
                    if (ln.equals("tspan") || ln.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, textPath, subBidiLevel, asb);
                        continue block4;
                    }
                    if (ln.equals("textPath")) {
                        SVGTextPathElementBridge textPathBridge = (SVGTextPathElementBridge)ctx.getBridge(nodeElement);
                        TextPath newTextPath = textPathBridge.createTextPath(ctx, nodeElement);
                        if (newTextPath == null) continue block4;
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, newTextPath, subBidiLevel, asb);
                        continue block4;
                    }
                    if (ln.equals("tref")) {
                        String uriStr = XLinkSupport.getXLinkHref((Element)n);
                        Element ref = ctx.getReferencedElement((Element)n, uriStr);
                        s = TextUtilities.getElementContent(ref);
                        if ((s = this.normalizeString(s, preserve, prevEndsWithSpace)) == null) continue block4;
                        Map m = this.getAttributeMap(ctx, nodeElement, textPath, bidiLevel);
                        asb.append(s, m);
                        continue block4;
                    }
                    if (!ln.equals("a")) continue block4;
                    EventTarget target = (EventTarget)((Object)nodeElement);
                    UserAgent ua = ctx.getUserAgent();
                    SVGAElementBridge.AnchorListener l = new SVGAElementBridge.AnchorListener(ua);
                    target.addEventListener("click", l, false);
                    ctx.storeEventListener(target, "click", l, false);
                    this.fillAttributedStringBuffer(ctx, nodeElement, false, textPath, subBidiLevel, asb);
                    continue block4;
                }
                case 3: 
                case 4: {
                    s = n.getNodeValue();
                    s = this.normalizeString(s, preserve, prevEndsWithSpace);
                    asb.append(s, map);
                    if (!preserve) continue block4;
                    this.endLimit = asb.length();
                }
            }
        }
        if (top) {
            while (this.endLimit < asb.length() && asb.getLastChar() == 32) {
                asb.stripLast();
            }
        }
    }

    protected String normalizeString(String s, boolean preserve, boolean stripfirst) {
        StringBuffer sb = new StringBuffer(s.length());
        if (preserve) {
            block10: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        sb.append(' ');
                        continue block10;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
        if (stripfirst) {
            block11: for (int idx = 0; idx < s.length(); ++idx) {
                switch (s.charAt(idx)) {
                    default: {
                        break block11;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block11;
                    }
                }
            }
        }
        boolean space = false;
        block12: for (int i = idx; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    continue block12;
                }
                case '\t': 
                case ' ': {
                    if (space) continue block12;
                    sb.append(' ');
                    space = true;
                    continue block12;
                }
                default: {
                    sb.append(c);
                    space = false;
                }
            }
        }
        return sb.toString();
    }

    protected boolean nodeAncestorOf(Node node1, Node node2) {
        Node parent;
        if (node2 == null || node1 == null) {
            return false;
        }
        for (parent = node2.getParentNode(); parent != null && parent != node1; parent = parent.getParentNode()) {
        }
        return parent == node1;
    }

    protected void addGlyphPositionAttributes(AttributedString as, Element element, BridgeContext ctx) {
        int i;
        int len;
        ArrayList al;
        if (!SVGUtilities.matchUserAgent(element, ctx.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        if (element.getLocalName().equals("textPath")) {
            this.addChildGlyphPositionAttributes(as, element, ctx);
            return;
        }
        AttributedCharacterIterator aci = as.getIterator();
        int firstChar = this.getElementStartIndex(aci, element);
        if (firstChar == -1) {
            return;
        }
        int lastChar = this.getElementEndIndex(aci, element);
        String xAtt = element.getAttributeNS(null, "x");
        String yAtt = element.getAttributeNS(null, "y");
        String dxAtt = element.getAttributeNS(null, "dx");
        String dyAtt = element.getAttributeNS(null, "dy");
        String rotateAtt = element.getAttributeNS(null, "rotate");
        if (xAtt.length() != 0) {
            al = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "x", xAtt, ctx);
            len = al.size();
            for (i = 0; i < len; ++i) {
                if (firstChar + i > lastChar) continue;
                as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, al.get(i), firstChar + i, firstChar + i + 1);
            }
        }
        if (yAtt.length() != 0) {
            al = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "y", yAtt, ctx);
            len = al.size();
            for (i = 0; i < len; ++i) {
                if (firstChar + i > lastChar) continue;
                as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, al.get(i), firstChar + i, firstChar + i + 1);
            }
        }
        if (dxAtt.length() != 0) {
            al = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "dx", dxAtt, ctx);
            len = al.size();
            for (i = 0; i < len; ++i) {
                if (firstChar + i > lastChar) continue;
                as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DX, al.get(i), firstChar + i, firstChar + i + 1);
            }
        }
        if (dyAtt.length() != 0) {
            al = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "dy", dyAtt, ctx);
            len = al.size();
            for (i = 0; i < len; ++i) {
                if (firstChar + i > lastChar) continue;
                as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DY, al.get(i), firstChar + i, firstChar + i + 1);
            }
        }
        if (rotateAtt.length() != 0) {
            al = TextUtilities.svgRotateArrayToFloats(element, "rotate", rotateAtt, ctx);
            len = al.size();
            if (len == 1) {
                as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, al.get(0), firstChar, lastChar + 1);
            } else {
                for (i = 0; i < len; ++i) {
                    if (firstChar + i > lastChar) continue;
                    as.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, al.get(i), firstChar + i, firstChar + i + 1);
                }
            }
        }
        this.addChildGlyphPositionAttributes(as, element, ctx);
    }

    protected void addChildGlyphPositionAttributes(AttributedString as, Element element, BridgeContext ctx) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            if (child.getNodeType() != 1 || !this.isTextChild(childElement = (Element)child)) continue;
            this.addGlyphPositionAttributes(as, childElement, ctx);
        }
    }

    protected void addPaintAttributes(AttributedString as, Element element, TextNode node, TextPaintInfo pi, BridgeContext ctx) {
        if (!SVGUtilities.matchUserAgent(element, ctx.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        Object o = this.elemTPI.get(element);
        if (o == null) {
            return;
        }
        node.swapTextPaintInfo(pi, (TextPaintInfo)o);
        this.addChildPaintAttributes(as, element, node, pi, ctx);
    }

    protected void addChildPaintAttributes(AttributedString as, Element element, TextNode node, TextPaintInfo parentPI, BridgeContext ctx) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            if (child.getNodeType() != 1 || !this.isTextChild(childElement = (Element)child)) continue;
            TextPaintInfo pi = this.getTextPaintInfo(childElement, node, parentPI, ctx);
            this.addPaintAttributes(as, childElement, node, pi, ctx);
        }
    }

    protected Map getFontProperties(BridgeContext ctx, Element element, Map map) {
        if (map == null) {
            map = new HashMap<AttributedCharacterIterator.Attribute, Element>(4);
        }
        map.put(TEXT_COMPOUND_DELIMITER, element);
        map.put(TextAttribute.SIZE, (Element)((Object)TextUtilities.convertFontSize(element)));
        map.put(TextAttribute.WIDTH, (Element)((Object)TextUtilities.convertFontStretch(element)));
        map.put(TextAttribute.WEIGHT, (Element)((Object)TextUtilities.convertFontWeight(element)));
        map.put(TextAttribute.POSTURE, (Element)((Object)TextUtilities.convertFontStyle(element)));
        return map;
    }

    protected Map getAttributeMap(BridgeContext ctx, Element element, TextPath textPath, Integer bidiLevel) {
        Value val;
        String s;
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, element);
        HashMap<AttributedCharacterIterator.Attribute, Object> result = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI()) && element.getLocalName().equals("altGlyph")) {
            result.put(ALT_GLYPH_HANDLER, new SVGAltGlyphHandler(ctx, element));
        }
        if (textPath != null) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH, textPath);
        }
        TextNode.Anchor a = TextUtilities.convertTextAnchor(element);
        result.put(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE, a);
        this.getFontProperties(ctx, element, result);
        List fontFamilyList = this.getFontFamilyList(element, ctx);
        result.put(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES, fontFamilyList);
        Object bs = TextUtilities.convertBaselineShift(element);
        if (bs != null) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, bs);
        }
        if ((s = (val = CSSUtilities.getComputedStyle(element, 56)).getStringValue()).charAt(0) == 'n') {
            if (bidiLevel != null) {
                result.put(TextAttribute.BIDI_EMBEDDING, bidiLevel);
            }
        } else {
            val = CSSUtilities.getComputedStyle(element, 11);
            String rs = val.getStringValue();
            int cbidi = 0;
            if (bidiLevel != null) {
                cbidi = bidiLevel;
            }
            if (cbidi < 0) {
                cbidi = -cbidi;
            }
            switch (rs.charAt(0)) {
                case 'l': {
                    result.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    if ((cbidi & 1) == 1) {
                        ++cbidi;
                        break;
                    }
                    cbidi += 2;
                    break;
                }
                case 'r': {
                    result.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    if ((cbidi & 1) == 1) {
                        cbidi += 2;
                        break;
                    }
                    ++cbidi;
                }
            }
            switch (s.charAt(0)) {
                case 'b': {
                    cbidi = -cbidi;
                }
            }
            result.put(TextAttribute.BIDI_EMBEDDING, new Integer(cbidi));
        }
        val = CSSUtilities.getComputedStyle(element, 59);
        s = val.getStringValue();
        switch (s.charAt(0)) {
            case 'l': {
                result.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR);
                break;
            }
            case 'r': {
                result.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL);
                break;
            }
            case 't': {
                result.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB);
            }
        }
        val = CSSUtilities.getComputedStyle(element, 29);
        switch (val.getPrimitiveType()) {
            case 21: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO);
                break;
            }
            case 11: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(val.getFloatValue()));
                break;
            }
            case 12: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float((double)(val.getFloatValue() * 180.0f) / Math.PI));
                break;
            }
            case 13: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                result.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(val.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        val = CSSUtilities.getComputedStyle(element, 28);
        switch (val.getPrimitiveType()) {
            case 11: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float(val.getFloatValue()));
                break;
            }
            case 12: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float((double)(val.getFloatValue() * 180.0f) / Math.PI));
                break;
            }
            case 13: {
                result.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float(val.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        Float sp = TextUtilities.convertLetterSpacing(element);
        if (sp != null) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING, sp);
            result.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((sp = TextUtilities.convertWordSpacing(element)) != null) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING, sp);
            result.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((sp = TextUtilities.convertKerning(element)) != null) {
            result.put(GVTAttributedCharacterIterator.TextAttribute.KERNING, sp);
            result.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((s = element.getAttributeNS(null, "textLength")).length() != 0) {
            float f = UnitProcessor.svgOtherLengthToUserSpace(s, "textLength", uctx);
            result.put(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH, new Float(f));
            s = element.getAttributeNS(null, "lengthAdjust");
            if (s.length() < 10) {
                result.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING);
                result.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
            } else {
                result.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL);
            }
        }
        return result;
    }

    protected List getFontFamilyList(Element element, BridgeContext ctx) {
        Value v = CSSUtilities.getComputedStyle(element, 27);
        String fontWeightString = v.getCssText();
        String fontStyleString = CSSUtilities.getComputedStyle(element, 25).getStringValue();
        Value val = CSSUtilities.getComputedStyle(element, 21);
        ArrayList<GVTFontFamily> fontFamilyList = new ArrayList<GVTFontFamily>();
        int len = val.getLength();
        for (int i = 0; i < len; ++i) {
            SVGFontFamily svgFF;
            Value it = val.item(i);
            String fontFamilyName = it.getStringValue();
            GVTFontFamily fontFamily = SVGFontUtilities.getFontFamily(element, ctx, fontFamilyName, fontWeightString, fontStyleString);
            if (fontFamily instanceof SVGFontFamily && (svgFF = (SVGFontFamily)fontFamily).isComplex()) {
                this.usingComplexSVGFont = true;
            }
            fontFamilyList.add(fontFamily);
        }
        return fontFamilyList;
    }

    protected TextPaintInfo getParentTextPaintInfo(AttributedCharacterIterator aci, Element child) {
        Element parent = null;
        int firstChar = -1;
        int i = 0;
        while (i < aci.getEndIndex()) {
            aci.setIndex(i);
            Element delimeter = (Element)aci.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (this.nodeAncestorOf(delimeter, child) && (parent == null || this.nodeAncestorOf(parent, delimeter))) {
                parent = delimeter;
                firstChar = i;
            }
            if (delimeter == child || this.nodeAncestorOf(child, delimeter)) break;
            i = aci.getRunLimit(TEXT_COMPOUND_DELIMITER);
        }
        if (parent == null) {
            return new TextPaintInfo();
        }
        aci.setIndex(firstChar);
        return (TextPaintInfo)aci.getAttribute(PAINT_INFO);
    }

    protected TextPaintInfo getTextPaintInfo(Element element, GraphicsNode node, TextPaintInfo parent, BridgeContext ctx) {
        Value val = CSSUtilities.getComputedStyle(element, 54);
        TextPaintInfo pi = new TextPaintInfo(parent);
        StyleMap sm = ((CSSStylableElement)element).getComputedStyleMap(null);
        if (sm.isNullCascaded(54) && sm.isNullCascaded(15) && sm.isNullCascaded(45) && sm.isNullCascaded(52) && sm.isNullCascaded(38)) {
            return pi;
        }
        this.setBaseTextPaintInfo(pi, element, node, ctx);
        if (!sm.isNullCascaded(54)) {
            this.setDecorationTextPaintInfo(pi, element);
        }
        return pi;
    }

    public void setBaseTextPaintInfo(TextPaintInfo pi, Element element, GraphicsNode node, BridgeContext ctx) {
        pi.composite = !element.getLocalName().equals("text") ? CSSUtilities.convertOpacity(element) : AlphaComposite.SrcOver;
        pi.visible = CSSUtilities.convertVisibility(element);
        pi.fillPaint = PaintServer.convertFillPaint(element, node, ctx);
        pi.strokePaint = PaintServer.convertStrokePaint(element, node, ctx);
        pi.strokeStroke = PaintServer.convertStroke(element);
    }

    public void setDecorationTextPaintInfo(TextPaintInfo pi, Element element) {
        Value val = CSSUtilities.getComputedStyle(element, 54);
        switch (val.getCssValueType()) {
            case 2: {
                ListValue lst = (ListValue)val;
                int len = lst.getLength();
                block8: for (int i = 0; i < len; ++i) {
                    Value v = lst.item(i);
                    String s = v.getStringValue();
                    switch (s.charAt(0)) {
                        case 'u': {
                            if (pi.fillPaint != null) {
                                pi.underlinePaint = pi.fillPaint;
                            }
                            if (pi.strokePaint != null) {
                                pi.underlineStrokePaint = pi.strokePaint;
                            }
                            if (pi.strokeStroke == null) continue block8;
                            pi.underlineStroke = pi.strokeStroke;
                            continue block8;
                        }
                        case 'o': {
                            if (pi.fillPaint != null) {
                                pi.overlinePaint = pi.fillPaint;
                            }
                            if (pi.strokePaint != null) {
                                pi.overlineStrokePaint = pi.strokePaint;
                            }
                            if (pi.strokeStroke == null) continue block8;
                            pi.overlineStroke = pi.strokeStroke;
                            continue block8;
                        }
                        case 'l': {
                            if (pi.fillPaint != null) {
                                pi.strikethroughPaint = pi.fillPaint;
                            }
                            if (pi.strokePaint != null) {
                                pi.strikethroughStrokePaint = pi.strokePaint;
                            }
                            if (pi.strokeStroke == null) continue block8;
                            pi.strikethroughStroke = pi.strokeStroke;
                        }
                    }
                }
                break;
            }
            default: {
                pi.underlinePaint = null;
                pi.underlineStrokePaint = null;
                pi.underlineStroke = null;
                pi.overlinePaint = null;
                pi.overlineStrokePaint = null;
                pi.overlineStroke = null;
                pi.strikethroughPaint = null;
                pi.strikethroughStrokePaint = null;
                pi.strikethroughStroke = null;
            }
        }
    }

    public int getNumberOfChars() {
        return this.getNumberOfChars(this.e);
    }

    public Rectangle2D getExtentOfChar(int charnum) {
        return this.getExtentOfChar(this.e, charnum);
    }

    public Point2D getStartPositionOfChar(int charnum) {
        return this.getStartPositionOfChar(this.e, charnum);
    }

    public Point2D getEndPositionOfChar(int charnum) {
        return this.getEndPositionOfChar(this.e, charnum);
    }

    public void selectSubString(int charnum, int nchars) {
        this.selectSubString(this.e, charnum, nchars);
    }

    public float getRotationOfChar(int charnum) {
        return this.getRotationOfChar(this.e, charnum);
    }

    public float getComputedTextLength() {
        return this.getComputedTextLength(this.e);
    }

    public float getSubStringLength(int charnum, int nchars) {
        return this.getSubStringLength(this.e, charnum, nchars);
    }

    public int getCharNumAtPosition(float x, float y) {
        return this.getCharNumAtPosition(this.e, x, y);
    }

    protected int getNumberOfChars(Element element) {
        AttributedCharacterIterator aci = ((TextNode)this.node).getAttributedCharacterIterator();
        int firstChar = this.getElementStartIndex(aci, element);
        if (firstChar == -1) {
            return 0;
        }
        int lastChar = this.getElementEndIndex(aci, element);
        return lastChar - firstChar + 1;
    }

    protected Rectangle2D getExtentOfChar(Element element, int charnum) {
        AttributedCharacterIterator aci = ((TextNode)this.node).getAttributedCharacterIterator();
        int firstChar = this.getElementStartIndex(aci, element);
        if (firstChar == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation info = this.getCharacterInformation(list, firstChar, charnum, aci);
        if (info == null) {
            return null;
        }
        GVTGlyphVector it = info.layout.getGlyphVector();
        Shape b = null;
        if (info.glyphIndexStart == info.glyphIndexEnd) {
            if (it.isGlyphVisible(info.glyphIndexStart)) {
                b = it.getGlyphOutline(info.glyphIndexStart);
            }
        } else {
            Path2D path = null;
            for (int k = info.glyphIndexStart; k <= info.glyphIndexEnd; ++k) {
                if (!it.isGlyphVisible(k)) continue;
                if (path == null) {
                    path = new GeneralPath(it.getGlyphOutline(k));
                    continue;
                }
                path.append(it.getGlyphOutline(k), false);
            }
            b = path;
        }
        if (b == null) {
            return null;
        }
        return b.getBounds2D();
    }

    protected Point2D getStartPositionOfChar(Element element, int charnum) {
        AttributedCharacterIterator aci = ((TextNode)this.node).getAttributedCharacterIterator();
        int firstChar = this.getElementStartIndex(aci, element);
        if (firstChar == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation info = this.getCharacterInformation(list, firstChar, charnum, aci);
        if (info == null) {
            return null;
        }
        return this.getStartPoint(info);
    }

    protected Point2D getStartPoint(CharacterInformation info) {
        GVTGlyphVector it = info.layout.getGlyphVector();
        if (!it.isGlyphVisible(info.glyphIndexStart)) {
            return null;
        }
        Point2D b = it.getGlyphPosition(info.glyphIndexStart);
        AffineTransform glyphTransform = it.getGlyphTransform(info.glyphIndexStart);
        Point2D.Float result = new Point2D.Float(0.0f, 0.0f);
        if (glyphTransform != null) {
            glyphTransform.transform(result, result);
        }
        result.x = (float)((double)result.x + b.getX());
        result.y = (float)((double)result.y + b.getY());
        return result;
    }

    protected Point2D getEndPositionOfChar(Element element, int charnum) {
        AttributedCharacterIterator aci = ((TextNode)this.node).getAttributedCharacterIterator();
        int firstChar = this.getElementStartIndex(aci, element);
        if (firstChar == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation info = this.getCharacterInformation(list, firstChar, charnum, aci);
        if (info == null) {
            return null;
        }
        return this.getEndPoint(info);
    }

    protected Point2D getEndPoint(CharacterInformation info) {
        GVTGlyphVector it = info.layout.getGlyphVector();
        if (!it.isGlyphVisible(info.glyphIndexEnd)) {
            return null;
        }
        Point2D b = it.getGlyphPosition(info.glyphIndexEnd);
        AffineTransform glyphTransform = it.getGlyphTransform(info.glyphIndexEnd);
        GVTGlyphMetrics metrics = it.getGlyphMetrics(info.glyphIndexEnd);
        Point2D.Float result = new Point2D.Float(metrics.getHorizontalAdvance(), 0.0f);
        if (glyphTransform != null) {
            glyphTransform.transform(result, result);
        }
        result.x = (float)((double)result.x + b.getX());
        result.y = (float)((double)result.y + b.getY());
        return result;
    }

    protected float getRotationOfChar(Element element, int charnum) {
        AttributedCharacterIterator aci = ((TextNode)this.node).getAttributedCharacterIterator();
        int firstChar = this.getElementStartIndex(aci, element);
        if (firstChar == -1) {
            return 0.0f;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation info = this.getCharacterInformation(list, firstChar, charnum, aci);
        double angle = 0.0;
        int nbGlyphs = 0;
        if (info != null) {
            GVTGlyphVector it = info.layout.getGlyphVector();
            for (int k = info.glyphIndexStart; k <= info.glyphIndexEnd; ++k) {
                if (!it.isGlyphVisible(k)) continue;
                ++nbGlyphs;
                AffineTransform glyphTransform = it.getGlyphTransform(k);
                if (glyphTransform == null) continue;
                double glyphAngle = 0.0;
                double cosTheta = glyphTransform.getScaleX();
                double sinTheta = glyphTransform.getShearX();
                if (cosTheta == 0.0) {
                    glyphAngle = sinTheta > 0.0 ? Math.PI : -Math.PI;
                } else {
                    glyphAngle = Math.atan(sinTheta / cosTheta);
                    if (cosTheta < 0.0) {
                        glyphAngle += Math.PI;
                    }
                }
                glyphAngle = Math.toDegrees(-glyphAngle) % 360.0;
                angle += glyphAngle - info.getComputedOrientationAngle();
            }
        }
        if (nbGlyphs == 0) {
            return 0.0f;
        }
        return (float)(angle / (double)nbGlyphs);
    }

    protected float getComputedTextLength(Element e) {
        return this.getSubStringLength(e, 0, this.getNumberOfChars(e));
    }

    protected float getSubStringLength(Element element, int charnum, int nchars) {
        if (nchars == 0) {
            return 0.0f;
        }
        float length = 0.0f;
        AttributedCharacterIterator aci = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int firstChar = this.getElementStartIndex(aci, element);
        if (firstChar == -1) {
            return -1.0f;
        }
        List list = this.getTextRuns(textNode);
        CharacterInformation currentInfo = this.getCharacterInformation(list, firstChar, charnum, aci);
        CharacterInformation lastCharacterInRunInfo = null;
        int chIndex = currentInfo.characterIndex + 1;
        GVTGlyphVector vector = currentInfo.layout.getGlyphVector();
        float[] advs = currentInfo.layout.getGlyphAdvances();
        boolean[] glyphTrack = new boolean[advs.length];
        for (int k = charnum + 1; k < charnum + nchars; ++k) {
            if (currentInfo.layout.isOnATextPath()) {
                for (int gi = currentInfo.glyphIndexStart; gi <= currentInfo.glyphIndexEnd; ++gi) {
                    if (vector.isGlyphVisible(gi) && !glyphTrack[gi]) {
                        length += advs[gi + 1] - advs[gi];
                    }
                    glyphTrack[gi] = true;
                }
                CharacterInformation newInfo = this.getCharacterInformation(list, firstChar, k, aci);
                if (newInfo.layout != currentInfo.layout) {
                    vector = newInfo.layout.getGlyphVector();
                    advs = newInfo.layout.getGlyphAdvances();
                    glyphTrack = new boolean[advs.length];
                    chIndex = currentInfo.characterIndex + 1;
                }
                currentInfo = newInfo;
                continue;
            }
            if (currentInfo.layout.hasCharacterIndex(chIndex)) {
                ++chIndex;
                continue;
            }
            lastCharacterInRunInfo = this.getCharacterInformation(list, firstChar, k - 1, aci);
            length += this.distanceFirstLastCharacterInRun(currentInfo, lastCharacterInRunInfo);
            currentInfo = this.getCharacterInformation(list, firstChar, k, aci);
            chIndex = currentInfo.characterIndex + 1;
            vector = currentInfo.layout.getGlyphVector();
            advs = currentInfo.layout.getGlyphAdvances();
            glyphTrack = new boolean[advs.length];
            lastCharacterInRunInfo = null;
        }
        if (currentInfo.layout.isOnATextPath()) {
            for (int gi = currentInfo.glyphIndexStart; gi <= currentInfo.glyphIndexEnd; ++gi) {
                if (vector.isGlyphVisible(gi) && !glyphTrack[gi]) {
                    length += advs[gi + 1] - advs[gi];
                }
                glyphTrack[gi] = true;
            }
        } else {
            if (lastCharacterInRunInfo == null) {
                lastCharacterInRunInfo = this.getCharacterInformation(list, firstChar, charnum + nchars - 1, aci);
            }
            length += this.distanceFirstLastCharacterInRun(currentInfo, lastCharacterInRunInfo);
        }
        return length;
    }

    protected float distanceFirstLastCharacterInRun(CharacterInformation first, CharacterInformation last) {
        float[] advs = first.layout.getGlyphAdvances();
        int firstStart = first.glyphIndexStart;
        int firstEnd = first.glyphIndexEnd;
        int lastStart = last.glyphIndexStart;
        int lastEnd = last.glyphIndexEnd;
        int start = firstStart < lastStart ? firstStart : lastStart;
        int end = firstEnd < lastEnd ? lastEnd : firstEnd;
        return advs[end + 1] - advs[start];
    }

    protected float distanceBetweenRun(CharacterInformation last, CharacterInformation first) {
        CharacterInformation info = new CharacterInformation();
        info.layout = last.layout;
        info.glyphIndexEnd = last.layout.getGlyphCount() - 1;
        Point2D startPoint = this.getEndPoint(info);
        info.layout = first.layout;
        info.glyphIndexStart = 0;
        Point2D endPoint = this.getStartPoint(info);
        float distance = first.isVertical() ? (float)(endPoint.getY() - startPoint.getY()) : (float)(endPoint.getX() - startPoint.getX());
        return distance;
    }

    protected void selectSubString(Element element, int charnum, int nchars) {
        AttributedCharacterIterator aci = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int firstChar = this.getElementStartIndex(aci, element);
        if (firstChar == -1) {
            return;
        }
        List list = this.getTextRuns(textNode);
        int lastChar = this.getElementEndIndex(aci, element);
        CharacterInformation firstInfo = this.getCharacterInformation(list, firstChar, charnum, aci);
        CharacterInformation lastInfo = this.getCharacterInformation(list, firstChar, charnum + nchars - 1, aci);
        Mark firstMark = textNode.getMarkerForChar(firstInfo.characterIndex, true);
        Mark lastMark = lastInfo != null && lastInfo.characterIndex <= lastChar ? textNode.getMarkerForChar(lastInfo.characterIndex, false) : textNode.getMarkerForChar(lastChar, false);
        this.ctx.getUserAgent().setTextSelection(firstMark, lastMark);
    }

    protected int getCharNumAtPosition(Element e, float x, float y) {
        TextNode textNode = (TextNode)this.node;
        List list = this.getTextRuns(textNode);
        TextHit hit = null;
        for (int i = list.size() - 1; i >= 0 && hit == null; --i) {
            hit = ((StrokingTextPainter.TextRun)list.get(i)).getLayout().hitTestChar(x, y);
        }
        if (hit == null) {
            return -1;
        }
        AttributedCharacterIterator aci = ((TextNode)this.node).getAttributedCharacterIterator();
        int first = this.getElementStartIndex(aci, e);
        int last = this.getElementEndIndex(aci, e);
        int hitIndex = hit.getCharIndex();
        if (hitIndex >= first && hitIndex <= last) {
            return hitIndex - first;
        }
        return -1;
    }

    protected List getTextRuns(TextNode node) {
        if (node.getTextRuns() == null) {
            node.getPrimitiveBounds();
        }
        return node.getTextRuns();
    }

    protected CharacterInformation getCharacterInformation(List list, int startIndex, int charnum, AttributedCharacterIterator aci) {
        CharacterInformation info = new CharacterInformation();
        info.characterIndex = startIndex + charnum;
        for (int i = 0; i < list.size(); ++i) {
            StrokingTextPainter.TextRun run = (StrokingTextPainter.TextRun)list.get(i);
            if (!run.getLayout().hasCharacterIndex(info.characterIndex)) continue;
            info.layout = run.getLayout();
            aci.setIndex(info.characterIndex);
            if (aci.getAttribute(ALT_GLYPH_HANDLER) != null) {
                info.glyphIndexStart = 0;
                info.glyphIndexEnd = info.layout.getGlyphCount() - 1;
            } else {
                info.glyphIndexStart = info.layout.getGlyphIndex(info.characterIndex);
                if (info.glyphIndexStart == -1) {
                    info.glyphIndexStart = 0;
                    info.glyphIndexEnd = info.layout.getGlyphCount() - 1;
                } else {
                    info.glyphIndexEnd = info.glyphIndexStart;
                }
            }
            return info;
        }
        return null;
    }

    public Set getTextIntersectionSet(AffineTransform at, Rectangle2D rect) {
        TextNode tn = (TextNode)this.node;
        List list = tn.getTextRuns();
        HashSet<Element> elems = new HashSet<Element>();
        block0: for (int i = 0; i < list.size(); ++i) {
            StrokingTextPainter.TextRun run = (StrokingTextPainter.TextRun)list.get(i);
            TextSpanLayout layout = run.getLayout();
            AttributedCharacterIterator aci = run.getACI();
            aci.first();
            Element elem = (Element)aci.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (elem == null || elems.contains(elem) || !SVGTextElementBridge.isTextSensitive(elem)) continue;
            Rectangle2D glBounds = layout.getBounds2D();
            if (glBounds != null) {
                glBounds = at.createTransformedShape(glBounds).getBounds2D();
            }
            if (!rect.intersects(glBounds)) continue;
            GVTGlyphVector gv = layout.getGlyphVector();
            for (int g = 0; g < gv.getNumGlyphs(); ++g) {
                Shape gBounds = gv.getGlyphLogicalBounds(g);
                if (gBounds != null) {
                    gBounds = at.createTransformedShape(gBounds).getBounds2D();
                }
                if (!gBounds.intersects(rect)) continue;
                elems.add(elem);
                continue block0;
            }
        }
        return elems;
    }

    public Set getTextEnclosureSet(AffineTransform at, Rectangle2D rect) {
        TextNode tn = (TextNode)this.node;
        HashSet<Element> elems = new HashSet<Element>();
        HashSet<Element> reject = new HashSet<Element>();
        List list = tn.getTextRuns();
        for (int i = 0; i < list.size(); ++i) {
            StrokingTextPainter.TextRun run = (StrokingTextPainter.TextRun)list.get(i);
            TextSpanLayout layout = run.getLayout();
            AttributedCharacterIterator aci = run.getACI();
            aci.first();
            Element elem = (Element)aci.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (elem == null || reject.contains(elem)) continue;
            if (!SVGTextElementBridge.isTextSensitive(elem)) {
                reject.add(elem);
                continue;
            }
            Rectangle2D glBounds = layout.getBounds2D();
            if (glBounds != null) {
                glBounds = at.createTransformedShape(glBounds).getBounds2D();
            }
            if (rect.contains(glBounds)) {
                elems.add(elem);
                continue;
            }
            reject.add(elem);
            elems.remove(elem);
        }
        return elems;
    }

    public static boolean getTextIntersection(BridgeContext ctx, Element elem, AffineTransform ati, Rectangle2D rect, boolean checkSensitivity) {
        SVGContext svgCtx = null;
        if (elem instanceof SVGOMElement) {
            svgCtx = ((SVGOMElement)elem).getSVGContext();
        }
        if (svgCtx == null) {
            return false;
        }
        SVGTextElementBridge txtBridge = null;
        if (svgCtx instanceof SVGTextElementBridge) {
            txtBridge = (SVGTextElementBridge)svgCtx;
        } else if (svgCtx instanceof AbstractTextChildSVGContext) {
            AbstractTextChildSVGContext childCtx = (AbstractTextChildSVGContext)svgCtx;
            txtBridge = childCtx.getTextBridge();
        }
        if (txtBridge == null) {
            return false;
        }
        TextNode tn = (TextNode)txtBridge.node;
        Element txtElem = txtBridge.e;
        AffineTransform at = tn.getGlobalTransform();
        at.preConcatenate(ati);
        Rectangle2D tnRect = tn.getBounds();
        tnRect = at.createTransformedShape(tnRect).getBounds2D();
        if (!rect.intersects(tnRect)) {
            return false;
        }
        List list = tn.getTextRuns();
        for (int i = 0; i < list.size(); ++i) {
            Rectangle2D glBounds;
            Element p;
            StrokingTextPainter.TextRun run = (StrokingTextPainter.TextRun)list.get(i);
            TextSpanLayout layout = run.getLayout();
            AttributedCharacterIterator aci = run.getACI();
            aci.first();
            Element runElem = (Element)aci.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (runElem == null || checkSensitivity && !SVGTextElementBridge.isTextSensitive(runElem)) continue;
            for (p = runElem; p != null && p != txtElem && p != elem; p = (Element)p.getParentNode()) {
            }
            if (p != elem || (glBounds = layout.getBounds2D()) == null || !rect.intersects(glBounds = at.createTransformedShape(glBounds).getBounds2D())) continue;
            GVTGlyphVector gv = layout.getGlyphVector();
            for (int g = 0; g < gv.getNumGlyphs(); ++g) {
                Shape gBounds = gv.getGlyphLogicalBounds(g);
                if (gBounds != null) {
                    gBounds = at.createTransformedShape(gBounds).getBounds2D();
                }
                if (!gBounds.intersects(rect)) continue;
                return true;
            }
        }
        return false;
    }

    public static Rectangle2D getTextBounds(BridgeContext ctx, Element elem, boolean checkSensitivity) {
        SVGContext svgCtx = null;
        if (elem instanceof SVGOMElement) {
            svgCtx = ((SVGOMElement)elem).getSVGContext();
        }
        if (svgCtx == null) {
            return null;
        }
        SVGTextElementBridge txtBridge = null;
        if (svgCtx instanceof SVGTextElementBridge) {
            txtBridge = (SVGTextElementBridge)svgCtx;
        } else if (svgCtx instanceof AbstractTextChildSVGContext) {
            AbstractTextChildSVGContext childCtx = (AbstractTextChildSVGContext)svgCtx;
            txtBridge = childCtx.getTextBridge();
        }
        if (txtBridge == null) {
            return null;
        }
        TextNode tn = (TextNode)txtBridge.node;
        Element txtElem = txtBridge.e;
        Rectangle2D ret = null;
        List list = tn.getTextRuns();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            Rectangle2D glBounds;
            Element p;
            StrokingTextPainter.TextRun run = (StrokingTextPainter.TextRun)list.get(i);
            TextSpanLayout layout = run.getLayout();
            AttributedCharacterIterator aci = run.getACI();
            aci.first();
            Element runElem = (Element)aci.getAttribute(TEXT_COMPOUND_DELIMITER);
            if (runElem == null || checkSensitivity && !SVGTextElementBridge.isTextSensitive(runElem)) continue;
            for (p = runElem; p != null && p != txtElem && p != elem; p = (Element)p.getParentNode()) {
            }
            if (p != elem || (glBounds = layout.getBounds2D()) == null) continue;
            if (ret == null) {
                ret = (Rectangle2D)glBounds.clone();
                continue;
            }
            ret.add(glBounds);
        }
        return ret;
    }

    public static boolean isTextSensitive(Element e) {
        int ptrEvts = CSSUtilities.convertPointerEvents(e);
        switch (ptrEvts) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return CSSUtilities.convertVisibility(e);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    protected static class CharacterInformation {
        TextSpanLayout layout;
        int glyphIndexStart;
        int glyphIndexEnd;
        int characterIndex;

        protected CharacterInformation() {
        }

        public boolean isVertical() {
            return this.layout.isVertical();
        }

        public double getComputedOrientationAngle() {
            return this.layout.getComputedOrientationAngle(this.characterIndex);
        }
    }

    protected class TspanBridge
    extends AbstractTextChildTextContent {
        public TspanBridge(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            super(ctx, parent, e);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent evt) {
            String attrName = evt.getAttrName();
            if (attrName.equals("x") || attrName.equals("y") || attrName.equals("dx") || attrName.equals("dy") || attrName.equals("rotate")) {
                this.textBridge.computeLaidoutText(this.ctx, this.textBridge.e, this.textBridge.node);
            }
        }
    }

    protected class TextPathBridge
    extends AbstractTextChildTextContent {
        public TextPathBridge(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            super(ctx, parent, e);
        }
    }

    protected class TRefBridge
    extends AbstractTextChildTextContent {
        public TRefBridge(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            super(ctx, parent, e);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent evt) {
            String attrName = evt.getAttrName();
            if (attrName.equals("x") || attrName.equals("y") || attrName.equals("dx") || attrName.equals("dy") || attrName.equals("rotate")) {
                this.textBridge.computeLaidoutText(this.ctx, this.textBridge.e, this.textBridge.node);
            }
        }
    }

    protected class AbstractTextChildTextContent
    extends AbstractTextChildBridgeUpdateHandler
    implements SVGTextContent {
        public AbstractTextChildTextContent(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            super(ctx, parent, e);
        }

        public int getNumberOfChars() {
            return this.textBridge.getNumberOfChars(this.e);
        }

        public Rectangle2D getExtentOfChar(int charnum) {
            return this.textBridge.getExtentOfChar(this.e, charnum);
        }

        public Point2D getStartPositionOfChar(int charnum) {
            return this.textBridge.getStartPositionOfChar(this.e, charnum);
        }

        public Point2D getEndPositionOfChar(int charnum) {
            return this.textBridge.getEndPositionOfChar(this.e, charnum);
        }

        public void selectSubString(int charnum, int nchars) {
            this.textBridge.selectSubString(this.e, charnum, nchars);
        }

        public float getRotationOfChar(int charnum) {
            return this.textBridge.getRotationOfChar(this.e, charnum);
        }

        public float getComputedTextLength() {
            return this.textBridge.getComputedTextLength(this.e);
        }

        public float getSubStringLength(int charnum, int nchars) {
            return this.textBridge.getSubStringLength(this.e, charnum, nchars);
        }

        public int getCharNumAtPosition(float x, float y) {
            return this.textBridge.getCharNumAtPosition(this.e, x, y);
        }
    }

    protected abstract class AbstractTextChildBridgeUpdateHandler
    extends AbstractTextChildSVGContext
    implements BridgeUpdateHandler {
        public AbstractTextChildBridgeUpdateHandler(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            super(ctx, parent, e);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        }

        public void handleDOMNodeInsertedEvent(MutationEvent evt) {
            this.textBridge.handleDOMNodeInsertedEvent(evt);
        }

        public void handleDOMNodeRemovedEvent(MutationEvent evt) {
            this.dispose();
        }

        public void handleDOMCharacterDataModified(MutationEvent evt) {
            this.textBridge.handleDOMCharacterDataModified(evt);
        }

        public void handleCSSEngineEvent(CSSEngineEvent evt) {
            this.textBridge.handleCSSEngineEvent(evt);
        }

        public void dispose() {
            ((SVGOMElement)this.e).setSVGContext(null);
            SVGTextElementBridge.this.elemTPI.remove(this.e);
        }
    }

    public abstract class AbstractTextChildSVGContext
    implements SVGContext {
        protected BridgeContext ctx;
        protected SVGTextElementBridge textBridge;
        protected Element e;

        public AbstractTextChildSVGContext(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            this.ctx = ctx;
            this.textBridge = parent;
            this.e = e;
        }

        public SVGTextElementBridge getTextBridge() {
            return this.textBridge;
        }

        public float getPixelUnitToMillimeter() {
            return this.ctx.getUserAgent().getPixelUnitToMillimeter();
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public Rectangle2D getBBox() {
            return null;
        }

        public AffineTransform getCTM() {
            return null;
        }

        public AffineTransform getGlobalTransform() {
            return null;
        }

        public AffineTransform getScreenTransform() {
            return null;
        }

        public void setScreenTransform(AffineTransform at) {
        }

        public float getViewportWidth() {
            return this.ctx.getBlockWidth(this.e);
        }

        public float getViewportHeight() {
            return this.ctx.getBlockHeight(this.e);
        }

        public float getFontSize() {
            return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
        }
    }

    protected static class AttributedStringBuffer {
        protected List strings = new ArrayList();
        protected List attributes = new ArrayList();
        protected int count = 0;
        protected int length = 0;

        public boolean isEmpty() {
            return this.count == 0;
        }

        public int length() {
            return this.length;
        }

        public void append(String s, Map m) {
            if (s.length() == 0) {
                return;
            }
            this.strings.add(s);
            this.attributes.add(m);
            ++this.count;
            this.length += s.length();
        }

        public int getLastChar() {
            if (this.count == 0) {
                return -1;
            }
            String s = (String)this.strings.get(this.count - 1);
            return s.charAt(s.length() - 1);
        }

        public void stripFirst() {
            String s = (String)this.strings.get(0);
            if (s.charAt(s.length() - 1) != ' ') {
                return;
            }
            --this.length;
            if (s.length() == 1) {
                this.attributes.remove(0);
                this.strings.remove(0);
                --this.count;
                return;
            }
            this.strings.set(0, s.substring(1));
        }

        public void stripLast() {
            String s = (String)this.strings.get(this.count - 1);
            if (s.charAt(s.length() - 1) != ' ') {
                return;
            }
            --this.length;
            if (s.length() == 1) {
                this.attributes.remove(--this.count);
                this.strings.remove(this.count);
                return;
            }
            this.strings.set(this.count - 1, s.substring(0, s.length() - 1));
        }

        public AttributedString toAttributedString() {
            switch (this.count) {
                case 0: {
                    return new AttributedString(" ");
                }
                case 1: {
                    return new AttributedString((String)this.strings.get(0), (Map)this.attributes.get(0));
                }
            }
            StringBuffer sb = new StringBuffer();
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
            }
            AttributedString result = new AttributedString(sb.toString());
            Iterator sit = this.strings.iterator();
            Iterator ait = this.attributes.iterator();
            int idx = 0;
            while (sit.hasNext()) {
                String s = (String)sit.next();
                int nidx = idx + s.length();
                Map m = (Map)ait.next();
                Iterator kit = m.keySet().iterator();
                Iterator vit = m.values().iterator();
                while (kit.hasNext()) {
                    AttributedCharacterIterator.Attribute attr = (AttributedCharacterIterator.Attribute)kit.next();
                    Object val = vit.next();
                    result.addAttribute(attr, val, idx, nidx);
                }
                idx = nidx;
            }
            return result;
        }

        public String toString() {
            switch (this.count) {
                case 0: {
                    return "";
                }
                case 1: {
                    return (String)this.strings.get(0);
                }
            }
            StringBuffer sb = new StringBuffer();
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
            }
            return sb.toString();
        }
    }

    protected class DOMSubtreeModifiedEventListener
    implements EventListener {
        protected DOMSubtreeModifiedEventListener() {
        }

        public void handleEvent(Event evt) {
            SVGTextElementBridge.this.handleDOMSubtreeModifiedEvent((MutationEvent)evt);
        }
    }

    protected class DOMChildNodeRemovedEventListener
    implements EventListener {
        protected DOMChildNodeRemovedEventListener() {
        }

        public void handleEvent(Event evt) {
            SVGTextElementBridge.this.handleDOMChildNodeRemovedEvent((MutationEvent)evt);
        }
    }
}

