/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.util.Vector;
import org.apache.batik.svggen.SVGStylingAttributes;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGCSSStyler
implements SVGSyntax {
    private static String CSS_PROPERTY_VALUE_SEPARATOR = ":";
    private static String CSS_RULE_SEPARATOR = ";";
    private static String SPACE = " ";

    public static void style(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            Element element = (Element)node;
            StringBuffer styleAttrBuffer = new StringBuffer();
            int nAttr = attributes.getLength();
            Vector<String> toBeRemoved = new Vector<String>();
            for (int i = 0; i < nAttr; ++i) {
                Attr attr = (Attr)attributes.item(i);
                if (!SVGStylingAttributes.set.contains(attr.getName())) continue;
                styleAttrBuffer.append(attr.getName());
                styleAttrBuffer.append(CSS_PROPERTY_VALUE_SEPARATOR);
                styleAttrBuffer.append(attr.getValue());
                styleAttrBuffer.append(CSS_RULE_SEPARATOR);
                styleAttrBuffer.append(SPACE);
                toBeRemoved.addElement(attr.getName());
            }
            if (styleAttrBuffer.length() > 0) {
                element.setAttributeNS(null, "style", styleAttrBuffer.toString().trim());
                int n = toBeRemoved.size();
                for (int i = 0; i < n; ++i) {
                    element.removeAttribute((String)toBeRemoved.elementAt(i));
                }
            }
        }
        NodeList children = node.getChildNodes();
        int nChildren = children.getLength();
        for (int i = 0; i < nChildren; ++i) {
            Node child = children.item(i);
            SVGCSSStyler.style(child);
        }
    }
}

