/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.VersionException;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.tools.debugger.concrete.ScriptText;
import flash.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DModule
implements SourceFile {
    private ScriptText m_script;
    private boolean m_gotRealScript;
    private final String m_rawName;
    private final String m_shortName;
    private final String m_path;
    private final String m_basePath;
    private final int m_id;
    private final int m_bitmap;
    private final ArrayList<Integer> m_line2Offset;
    private final ArrayList<Object> m_line2Func;
    private final HashMap<String, Integer> m_func2FirstLine;
    private final HashMap<String, Integer> m_func2LastLine;
    private String m_packageName;
    private boolean m_gotAllFncNames;
    private int m_anonymousFunctionCounter = 0;
    private SourceLocator m_sourceLocator;
    private int m_sourceLocatorChangeCount;
    private static final String m_newline = System.getProperty("line.separator");
    private static final Pattern sXMLDeclarationPattern = Pattern.compile("^<\\?xml[^>]*encoding\\s*=\\s*(\"([^\"]*)\"|'([^']*)')");

    public DModule(SourceLocator sourceLocator, int id, int bitmap, String name, String script) {
        if (script != null && script.length() > 0) {
            this.m_script = new ScriptText(script);
            this.m_gotRealScript = true;
        }
        NameParser nameParser = new NameParser(name);
        this.m_sourceLocator = sourceLocator;
        this.m_rawName = name;
        this.m_basePath = nameParser.getBasePath();
        this.m_bitmap = bitmap;
        this.m_id = id;
        this.m_shortName = DModule.generateShortName(nameParser);
        this.m_path = DModule.generatePath(nameParser);
        this.m_line2Offset = new ArrayList();
        this.m_line2Func = new ArrayList();
        this.m_func2FirstLine = new HashMap();
        this.m_func2LastLine = new HashMap();
        this.m_packageName = nameParser.getPackage();
        this.m_gotAllFncNames = false;
    }

    public synchronized ScriptText getScript() {
        if (!this.m_gotRealScript && this.m_sourceLocator != null && this.m_sourceLocator.getChangeCount() != this.m_sourceLocatorChangeCount) {
            this.m_script = null;
        }
        if (this.m_script == null) {
            String script = this.scriptFromDisk(this.getRawName());
            if (script == null) {
                script = "";
            } else {
                this.m_gotRealScript = true;
            }
            this.m_script = new ScriptText(script);
        }
        return this.m_script;
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public String getName() {
        return this.m_shortName;
    }

    public String getFullPath() {
        return this.m_path;
    }

    public String getPackageName() {
        return this.m_packageName == null ? "" : this.m_packageName;
    }

    public String getRawName() {
        return this.m_rawName;
    }

    public int getId() {
        return this.m_id;
    }

    public int getBitmap() {
        return this.m_bitmap;
    }

    public int getLineCount() {
        return this.getScript().getLineCount();
    }

    public String getLine(int i) {
        return i > this.getLineCount() ? "// code goes here" : this.getScript().getLine(i);
    }

    void setPackageName(String name) {
        this.m_packageName = name;
    }

    public int getOffsetForLine(int line) {
        Integer i;
        int offset = 0;
        if (line < this.m_line2Offset.size() && (i = this.m_line2Offset.get(line)) != null) {
            offset = i;
        }
        return offset;
    }

    public int getLineForFunctionName(Session s, String name) {
        int value = -1;
        this.primeAllFncNames(s);
        Integer i = this.m_func2FirstLine.get(name);
        if (i != null) {
            value = i;
        }
        return value;
    }

    public String getFunctionNameForLine(Session s, int line) {
        this.primeFncName(s, line);
        String[] funcNames = this.getFunctionNamesForLine(s, line);
        if (funcNames != null && funcNames.length == 1) {
            return funcNames[0];
        }
        return null;
    }

    private String[] getFunctionNamesForLine(Session s, int line) {
        this.primeFncName(s, line);
        if (line < this.m_line2Func.size()) {
            Object obj = this.m_line2Func.get(line);
            if (obj instanceof String) {
                return new String[]{(String)obj};
            }
            if (obj instanceof String[]) {
                return (String[])obj;
            }
        }
        return new String[0];
    }

    public String[] getFunctionNames(Session s) {
        this.primeAllFncNames(s);
        int count = this.m_func2FirstLine.size();
        return this.m_func2FirstLine.keySet().toArray(new String[count]);
    }

    private static String generateShortName(NameParser nameParser) {
        String name;
        String s = name = nameParser.getOriginalName();
        if (nameParser.isPathPackageAndFilename()) {
            s = nameParser.getFilename();
        } else {
            int dotAt = name.lastIndexOf(46);
            if (dotAt > 1) {
                int lastSlashAt = name.lastIndexOf(92, dotAt);
                lastSlashAt = Math.max(lastSlashAt, name.lastIndexOf(47, dotAt));
                s = name.substring(lastSlashAt + 1);
            } else {
                s = name;
            }
        }
        return s.trim();
    }

    private static String generatePath(NameParser nameParser) {
        String name;
        String s = name = nameParser.getOriginalName();
        int colonAt = name.indexOf(58);
        if (colonAt > 1 && !name.startsWith("Actions for")) {
            if (name.charAt(colonAt + 1) == ' ') {
                s = name.substring(colonAt + 2);
            }
        } else {
            s = name.indexOf(46) > -1 && name.charAt(0) != '<' ? nameParser.recombine() : "";
        }
        return s.trim();
    }

    public void lineMapping(StringBuilder sb) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("fileName", this.getName());
        args.put("fileNumber", Integer.toString(this.getId()));
        sb.append(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("functionsInFile", args));
        sb.append(m_newline);
        String[] funcNames = this.m_func2FirstLine.keySet().toArray(new String[this.m_func2FirstLine.size()]);
        Arrays.sort(funcNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int line1 = (Integer)DModule.this.m_func2FirstLine.get(o1);
                int line2 = (Integer)DModule.this.m_func2FirstLine.get(o2);
                return line1 - line2;
            }
        });
        for (int i = 0; i < funcNames.length; ++i) {
            String name = funcNames[i];
            int firstLine = this.m_func2FirstLine.get(name);
            int lastLine = this.m_func2LastLine.get(name);
            sb.append(" ");
            sb.append(name);
            sb.append(" ");
            sb.append(firstLine);
            sb.append(" ");
            sb.append(lastLine);
            sb.append(m_newline);
        }
    }

    int compareTo(DModule other) {
        return this.getName().compareTo(other.getName());
    }

    void primeFncName(Session s, int line) {
        this.primeAllFncNames(s);
    }

    void primeAllFncNames(Session s) {
        PlayerSession ps = (PlayerSession)s;
        if (!this.m_gotAllFncNames && ps.playerVersion() >= 9) {
            try {
                ps.requestFunctionNames(this.m_id, -1);
            }
            catch (VersionException e) {
            }
            catch (NoResponseException noResponseException) {
                // empty catch block
            }
        }
        this.m_gotAllFncNames = true;
    }

    void addLineFunctionInfo(int offset, int line, String funcName) {
        this.addLineFunctionInfo(offset, line, line, funcName);
    }

    void addLineFunctionInfo(int offset, int firstLine, int lastLine, String funcName) {
        if (funcName == null || funcName.length() == 0) {
            funcName = "<anonymous$" + ++this.m_anonymousFunctionCounter + ">";
        } else {
            int colon = funcName.lastIndexOf(58);
            int slash = funcName.lastIndexOf(47);
            if (colon > -1 || slash > -1) {
                int greater = Math.max(colon, slash);
                funcName = funcName.substring(greater + 1);
            } else {
                int dot = funcName.lastIndexOf(46);
                if (dot > -1) {
                    String pkg = funcName.substring(0, dot);
                    funcName = funcName.substring(dot + 1);
                    this.setPackageName(pkg);
                }
            }
        }
        this.m_line2Offset.ensureCapacity(firstLine + 1);
        while (firstLine >= this.m_line2Offset.size()) {
            this.m_line2Offset.add(null);
        }
        this.m_line2Offset.set(firstLine, new Integer(offset));
        this.m_line2Func.ensureCapacity(lastLine + 1);
        while (lastLine >= this.m_line2Func.size()) {
            this.m_line2Func.add(null);
        }
        for (int line = firstLine; line <= lastLine; ++line) {
            Object funcs = this.m_line2Func.get(line);
            if (funcs == null) {
                this.m_line2Func.set(line, funcName);
                continue;
            }
            if (funcs instanceof String) {
                String oldFunc = (String)funcs;
                this.m_line2Func.set(line, new String[]{oldFunc, funcName});
                continue;
            }
            if (!(funcs instanceof String[])) continue;
            String[] oldFuncs = (String[])funcs;
            String[] newFuncs = new String[oldFuncs.length + 1];
            System.arraycopy(oldFuncs, 0, newFuncs, 0, oldFuncs.length);
            newFuncs[newFuncs.length - 1] = funcName;
            this.m_line2Func.set(line, newFuncs);
        }
        if (this.m_func2FirstLine.get(funcName) == null) {
            this.m_func2FirstLine.put(funcName, new Integer(firstLine));
            this.m_func2LastLine.put(funcName, new Integer(lastLine));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String scriptFromDisk(String name) {
        String script;
        block26: {
            name = name.replace('\\', '/');
            int SEP = 59;
            String pkgPart = "";
            String pathPart = "";
            String namePart = "";
            int at = name.indexOf(59);
            if (at > -1) {
                int nextAt = name.indexOf(59, at + 1);
                if (nextAt > -1) {
                    pathPart = name.substring(0, at);
                    pkgPart = name.substring(at + 1, nextAt);
                    namePart = name.substring(nextAt + 1);
                } else {
                    pathPart = name.substring(0, at);
                    namePart = name.substring(at + 1);
                }
            } else {
                at = name.lastIndexOf(47);
                if (at > -1) {
                    int mx = name.lastIndexOf("/mx/");
                    if (mx > -1) {
                        pathPart = name.substring(0, mx);
                        pkgPart = name.substring(mx + 1, at);
                    } else {
                        pathPart = name.substring(0, at);
                    }
                    namePart = name.substring(at + 1);
                } else {
                    pathPart = ".";
                    namePart = name;
                }
            }
            script = null;
            try {
                BufferedInputStream bis;
                Charset realEncoding = null;
                Charset bomEncoding = null;
                InputStream in = this.locateScriptFile(pathPart, pkgPart, namePart);
                if (in != null) {
                    try {
                        bis = new BufferedInputStream(in);
                        bomEncoding = this.getEncodingFromBOM(bis);
                        script = this.pullInSource(bis, bomEncoding);
                        realEncoding = this.getEncodingFromXMLDirective(script);
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (realEncoding == null || realEncoding.equals(bomEncoding) || (in = this.locateScriptFile(pathPart, pkgPart, namePart)) == null) break block26;
                try {
                    bis = new BufferedInputStream(in);
                    this.getEncodingFromBOM(bis);
                    script = this.pullInSource(bis, realEncoding);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (FileNotFoundException fnf) {
                fnf.printStackTrace();
            }
        }
        return script;
    }

    InputStream locateScriptFile(String path, String pkg, String name) throws FileNotFoundException {
        File f;
        if (this.m_sourceLocator != null) {
            this.m_sourceLocatorChangeCount = this.m_sourceLocator.getChangeCount();
            InputStream is = this.m_sourceLocator.locateSource(path, pkg, name);
            if (is != null) {
                return is;
            }
        }
        path = path.replace('/', File.separatorChar);
        pkg = pkg.replace('/', File.separatorChar);
        if (path.length() > 0) {
            try {
                String pkgAndName = "";
                if (pkg.length() > 0) {
                    pkgAndName = pkgAndName + pkg + File.separatorChar;
                }
                if ((f = new File(path, pkgAndName = pkgAndName + name)).exists()) {
                    return new FileInputStream(f);
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        if (pkg.length() > 0 && (f = new File(pkg, name)).exists()) {
            return new FileInputStream(f);
        }
        f = new File(name);
        if (f.exists()) {
            return new FileInputStream(f);
        }
        return null;
    }

    private Charset getEncodingFromBOM(BufferedInputStream bis) {
        String bomEncodingString;
        Charset bomEncoding = null;
        bis.mark(3);
        try {
            bomEncodingString = FileUtils.consumeBOM((InputStream)bis, null);
        }
        catch (IOException e) {
            bomEncodingString = System.getProperty("file.encoding");
        }
        bomEncoding = Charset.forName(bomEncodingString);
        return bomEncoding;
    }

    private Charset getEncodingFromXMLDirective(String entireSource) {
        String encoding = null;
        Matcher xmlDeclarationMatcher = sXMLDeclarationPattern.matcher(entireSource);
        if (xmlDeclarationMatcher.find()) {
            encoding = xmlDeclarationMatcher.group(2);
            if (encoding == null) {
                encoding = xmlDeclarationMatcher.group(3);
            }
            try {
                return Charset.forName(encoding);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return null;
    }

    String pullInSource(InputStream in, Charset encoding) {
        String script = "";
        BufferedReader f = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            InputStreamReader reader = null;
            reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
            f = new BufferedReader(reader);
            while ((line = f.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            script = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return script;
    }

    public String toString() {
        return this.getFullPath();
    }

    private static class NameParser {
        private String fOriginalName;
        private String fBasePath;
        private String fPackage;
        private String fFilename;
        private String fRecombinedName;

        public NameParser(String name) {
            this.fOriginalName = name;
            int semicolonCount = 0;
            int i = 0;
            int firstSemi = -1;
            int lastSemi = -1;
            while ((i = name.indexOf(59, i)) >= 0) {
                ++semicolonCount;
                if (firstSemi == -1) {
                    firstSemi = i;
                }
                lastSemi = i++;
            }
            if (semicolonCount == 2) {
                this.fBasePath = name.substring(0, firstSemi);
                this.fPackage = name.substring(firstSemi + 1, lastSemi);
                this.fFilename = name.substring(lastSemi + 1);
            }
        }

        public boolean isPathPackageAndFilename() {
            return this.fBasePath != null;
        }

        public String getOriginalName() {
            return this.fOriginalName;
        }

        public String getBasePath() {
            return this.fBasePath;
        }

        public String getFilename() {
            return this.fFilename;
        }

        public String getPackage() {
            return this.fPackage;
        }

        public String recombine() {
            if (this.fRecombinedName == null) {
                if (this.isPathPackageAndFilename()) {
                    char slashChar = this.fOriginalName.indexOf(92) != -1 ? (char)'\\' : '/';
                    this.fRecombinedName = this.fOriginalName.replaceAll(";;", ";").replace(';', slashChar);
                } else {
                    this.fRecombinedName = this.fOriginalName;
                }
            }
            return this.fRecombinedName;
        }
    }
}

