/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.common.ConfigurationException;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.util.NameFormatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FramesConfiguration {
    private List frameList = new LinkedList();

    public List getFrameList() {
        return this.frameList;
    }

    public void cfgFrame(ConfigurationValue cv, List args) throws ConfigurationException {
        FrameInfo info = new FrameInfo();
        if (args.size() < 2) {
            throw new ConfigurationException.BadFrameParameters(cv.getVar(), cv.getSource(), cv.getLine());
        }
        Iterator it = args.iterator();
        while (it.hasNext()) {
            if (info.label == null) {
                info.label = (String)it.next();
                continue;
            }
            String clsName = (String)it.next();
            info.frameClasses.add(NameFormatter.toColon(clsName));
        }
        this.frameList.add(info);
    }

    public static ConfigurationInfo getFrameInfo() {
        return new ConfigurationInfo(-1, new String[]{"label", "classname"}){

            public boolean isAdvanced() {
                return true;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public static class FrameInfo {
        public String label = null;
        public List frameClasses = new LinkedList();
    }
}

