/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flash.util.StringUtils;
import flex2.compiler.Source;
import flex2.compiler.as3.MetaDataParser;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.common.PathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.rep.LineNumberMapped;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import macromedia.asc.util.ContextStatics;

public class AtEmbed
implements LineNumberMapped {
    private String propName;
    private int lineNumber;
    private Map attributes;
    private boolean strType;

    public AtEmbed(String propName, int lineNumber, Map attrs, boolean strType) {
        this.propName = propName;
        this.lineNumber = lineNumber;
        this.attributes = attrs;
        this.strType = strType;
    }

    private static void addFileAndLine(Map values, String file, int line) {
        if (file.indexOf(92) > -1) {
            values.put("_file", file.replace('\\', '/'));
            values.put("_pathsep", "true");
        } else {
            values.put("_file", file);
        }
        values.put("_line", Integer.toString(line));
    }

    public String getPropName() {
        return this.propName;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public int getXmlLineNumber() {
        return this.lineNumber;
    }

    public String getType() {
        return this.strType ? "String" : "Class";
    }

    public void setXmlLineNumber(int xmlLineNumber) {
        this.lineNumber = xmlLineNumber;
    }

    public static AtEmbed create(ContextStatics perCompileData, Source source, String value, String path, int line, String prefix) {
        AtEmbed result = null;
        try {
            MetaData metaData = MetaDataParser.parse(perCompileData, source, line, value);
            String sourceValue = null;
            HashMap<String, String> values = new HashMap<String, String>();
            if (metaData.count() > 1 && metaData.getKey(0) == null && metaData.getKey(1) == null) {
                sourceValue = metaData.getValue(0);
                String symbolOrMimeType = metaData.getValue(1);
                if (MimeMappings.getExtension(symbolOrMimeType) != null) {
                    values.put("mimeType", symbolOrMimeType);
                } else {
                    values.put("symbol", symbolOrMimeType);
                }
            } else if (metaData.count() > 0 && metaData.getKey(0) == null) {
                sourceValue = metaData.getValue(0);
            } else if (metaData.getValue("skinClass") != null && metaData.getValue("source") != null) {
                AtEmbed.logSkinClassWithSourceNotSupported(value, path, line);
            } else if (metaData.getValue("skinClass") != null) {
                String skinClass = metaData.getValue("skinClass");
            } else {
                sourceValue = metaData.getValue("source");
            }
            if (sourceValue != null && AtEmbed.tokenizeAndResolveSource(sourceValue, values, source, value, path, line) || metaData.getValue("skinClass") != null) {
                Iterator it = metaData.getValueMap().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    String key = (String)e.getKey();
                    if (values.containsKey(key)) continue;
                    String val = ((String)e.getValue()).replace('\\', '/');
                    values.put(key, val);
                }
                String propName = AtEmbed.createMangledName(source, sourceValue, false, values, prefix);
                AtEmbed.addFileAndLine(values, path, line);
                result = new AtEmbed(propName, line, values, false);
            } else {
                AtEmbed.logInvalidEmbed(value, path, line);
            }
        }
        catch (Exception exception) {
            AtEmbed.logInvalidEmbed(value, path, line);
        }
        return result;
    }

    public static AtEmbed create(String baseName, int beginLine, Map attrs, boolean strType) {
        String embedName = AtEmbed.createMangledName(baseName, ((Object)attrs).hashCode());
        return new AtEmbed(embedName, beginLine, attrs, strType);
    }

    public static AtEmbed create(ContextStatics perCompileData, Source sourceFile, int beginLine, String value, boolean strType) {
        MetaData metaData = MetaDataParser.parse(perCompileData, sourceFile, beginLine, value.substring(1));
        if (metaData == null) {
            return null;
        }
        if (metaData.count() == 0) {
            ThreadLocalToolkit.log((CompilerMessage)new NoEmbedParams(), sourceFile.getNameForReporting(), beginLine);
            return null;
        }
        String source = metaData.getValue("source");
        if (source == null && metaData.getKey(0) == null && metaData.count() == 1) {
            source = metaData.getValue(0);
        }
        Map values = AtEmbed.getMetaDataMap(metaData);
        String embedName = AtEmbed.createMangledName(sourceFile, source, strType, values, "_embed_mxml_");
        return new AtEmbed(embedName, beginLine, values, strType);
    }

    private static Map getMetaDataMap(flex2.compiler.abc.MetaData metaData) {
        int len = metaData.count();
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            String key = metaData.getKey(i);
            String value = metaData.getValue(i);
            if (key == null) {
                values.put("source", value);
                continue;
            }
            values.put(key, value);
        }
        return values;
    }

    public static String createMangledName(Source source, String path, boolean strType, Map attrs, String prefix) {
        String symbol;
        StringBuffer buf = new StringBuffer(128);
        if (prefix != null) {
            buf.append(prefix);
        }
        int hash = ((Object)attrs).hashCode();
        String mimeType = (String)attrs.get("mimeType");
        VirtualFile f = null;
        if (path != null) {
            buf.append(path);
            f = source.resolve(path);
            if (f != null) {
                hash ^= ((Object)f).hashCode();
            }
        } else if (mimeType != null) {
            buf.append(mimeType);
        }
        if ((symbol = (String)attrs.get("symbol")) != null) {
            buf.append('_');
            buf.append(symbol);
        }
        if (strType) {
            buf.append("_s");
        }
        return AtEmbed.createMangledName(buf.toString(), hash);
    }

    public static String createMangledName(String name, int hash) {
        return StringUtils.replaceAll((String)(name + '_' + Math.abs(hash)), (String)"[^A-Za-z0-9]", (String)"_");
    }

    private static void logInvalidEmbed(String value, String path, int line) {
        InvalidEmbed invalidEmbed = new InvalidEmbed(value);
        invalidEmbed.path = path;
        invalidEmbed.line = line;
        ThreadLocalToolkit.log(invalidEmbed);
    }

    private static void logSkinClassWithSourceNotSupported(String value, String path, int line) {
        SkinClassWithSourceNotSupported skinClassWithSourceNotSupported = new SkinClassWithSourceNotSupported(value);
        skinClassWithSourceNotSupported.path = path;
        skinClassWithSourceNotSupported.line = line;
        ThreadLocalToolkit.log(skinClassWithSourceNotSupported);
    }

    private static VirtualFile resolveSource(Object owner, Source source, VirtualFile file, String sourcePath) {
        PathResolver context = new PathResolver();
        if (sourcePath != null && sourcePath.charAt(0) == '/') {
            VirtualFile pathRoot = source.getPathRoot();
            if (pathRoot != null) {
                context.addSinglePathResolver(pathRoot);
            }
            if (owner instanceof SinglePathResolver) {
                context.addSinglePathResolver((SinglePathResolver)owner);
            }
        } else if (file != null) {
            context.addSinglePathResolver(file);
        }
        context.addSinglePathResolver(ThreadLocalToolkit.getPathResolver());
        return context.resolve(sourcePath);
    }

    private static boolean tokenizeAndResolveSource(String sourceValue, Map values, Source source, String value, String path, int line) {
        boolean result = true;
        int octothorpe = sourceValue.indexOf(35);
        if (octothorpe != -1) {
            values.put("symbol", sourceValue.substring(octothorpe + 1));
            sourceValue = sourceValue.substring(0, octothorpe);
        }
        VirtualFile file = ThreadLocalToolkit.getPathResolver().resolve(path);
        VirtualFile resolvedFile = AtEmbed.resolveSource(source.getOwner(), source, file, sourceValue);
        if (resolvedFile != null) {
            String resolvedName = resolvedFile.getName().replace('\\', '/');
            values.put("original", sourceValue);
            values.put("_resolvedSource", resolvedName);
            ThreadLocalToolkit.addResolvedPath(resolvedName, resolvedFile);
            values.put("source", resolvedName);
        } else {
            AtEmbed.logInvalidEmbed(value, path, line);
        }
        return result;
    }

    public static class NoEmbedParams
    extends CompilerMessage.CompilerError {
    }

    public static class SkinClassWithSourceNotSupported
    extends CompilerMessage.CompilerError {
        public String source;

        public SkinClassWithSourceNotSupported(String source) {
            this.source = source;
        }
    }

    public static class InvalidEmbed
    extends CompilerMessage.CompilerError {
        public String source;

        public InvalidEmbed(String source) {
            this.source = source;
        }
    }
}

