/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.config.FileConfigurator;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.Mxmlc;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Iterator;

public abstract class ToolsConfiguration
extends Configuration {
    private VirtualFile licenseFile;
    protected String output;
    private boolean warnings = true;
    private String dumpConfigFile = null;

    public VirtualFile getLicenseFile() {
        return this.licenseFile;
    }

    private void processDeprecatedOptions(ConfigurationBuffer configurationBuffer) {
        Iterator<String> i = configurationBuffer.getVarIterator();
        while (i.hasNext()) {
            String var = i.next();
            ConfigurationInfo info = configurationBuffer.getInfo(var);
            if (!info.isDeprecated() || configurationBuffer.getVar(var) == null) continue;
            CompilerMessage.CompilerWarning warning = info.getDeprecatedMessage();
            String replacement = info.getDeprecatedReplacement();
            String since = info.getDeprecatedSince();
            if (warning != null) {
                ThreadLocalToolkit.log(warning);
                continue;
            }
            ThreadLocalToolkit.log(new DeprecatedConfigurationOption(var, replacement, since));
        }
    }

    public String getOutput() {
        return this.output;
    }

    protected abstract String getTargetFile();

    private String createOutputDirectory(ConfigurationBuffer configurationBuffer, String directory) {
        String result = directory;
        String parent = configurationBuffer.getToken("com.adobe.flex.default.output.directory");
        if (parent == null) {
            String output = this.getOutput();
            if (output != null) {
                parent = new File(output).getParent();
            } else {
                String targetFile = this.getTargetFile();
                if (targetFile != null) {
                    parent = new File(targetFile).getParent();
                }
            }
        }
        if (parent != null) {
            result = FileUtils.addPathComponents((String)parent, (String)directory, (char)File.separatorChar);
        }
        return result;
    }

    public void validate(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
        this.processDeprecatedOptions(configurationBuffer);
        try {
            Class<?> oemLicenseServiceClass = Class.forName("flex.license.OEMLicenseService");
            Method method = oemLicenseServiceClass.getMethod("getLicenseFilename", null);
            String licenseFileName = (String)method.invoke(null, (Object[])null);
            this.licenseFile = this.configResolver.resolve(licenseFileName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Trace.license) {
            String file = this.licenseFile != null ? this.licenseFile.getName() : "";
            Trace.trace((String)("ToolsConfiguration.validate: licenseFile = '" + file + "'"));
        }
        boolean strict = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.strict"));
        boolean as3 = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.as3"));
        boolean es = "true".equalsIgnoreCase(configurationBuffer.peekSimpleConfigurationVar("compiler.es"));
        if (as3 && es || !as3 && !es) {
            throw new BadAS3ESCombination(as3, es);
        }
        if (strict && es) {
            ThreadLocalToolkit.log(new BadESStrictCombination(es, strict));
        }
        CompilerConfiguration compilerConfiguration = this.getCompilerConfiguration();
        this.validateKeepGeneratedSignatures(configurationBuffer, compilerConfiguration);
        this.validateKeepGeneratedActionScript(configurationBuffer, compilerConfiguration);
        this.validateDumpConfig(configurationBuffer);
    }

    private void validateDumpConfig(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
        if (this.dumpConfigFile != null) {
            ThreadLocalToolkit.log(new Mxmlc.DumpConfig(this.dumpConfigFile));
            File f = new File(this.dumpConfigFile);
            String text = FileConfigurator.formatBuffer(configurationBuffer, "flex-config", ThreadLocalToolkit.getLocalizationManager(), "flex2.configuration");
            try {
                PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(f)));
                out.write(text);
                out.close();
            }
            catch (Exception e) {
                throw new ConfigurationException.IOError(this.dumpConfigFile);
            }
        }
    }

    private void validateKeepGeneratedSignatures(ConfigurationBuffer configurationBuffer, CompilerConfiguration compilerConfiguration) throws ConfigurationException {
        if (compilerConfiguration.getKeepGeneratedSignatures()) {
            String dir = compilerConfiguration.getSignatureDirectory();
            if (dir == null) {
                dir = this.createOutputDirectory(configurationBuffer, "generated-signatures");
            } else if (!FileUtils.isAbsolute((File)new File(dir))) {
                dir = this.createOutputDirectory(configurationBuffer, dir);
            }
            assert (dir != null);
            if (dir != null) {
                File file = new File(dir);
                file.mkdirs();
                compilerConfiguration.setSignatureDirectory(FileUtils.canonicalPath((File)file));
            }
        }
    }

    private void validateKeepGeneratedActionScript(ConfigurationBuffer configurationBuffer, CompilerConfiguration compilerConfiguration) {
        if (compilerConfiguration.keepGeneratedActionScript()) {
            String dir = compilerConfiguration.getGeneratedDirectory();
            if (dir == null) {
                dir = this.createOutputDirectory(configurationBuffer, "generated");
            } else if (!FileUtils.isAbsolute((File)new File(dir))) {
                dir = this.createOutputDirectory(configurationBuffer, dir);
            }
            assert (dir != null);
            if (dir != null) {
                File file = new File(dir);
                file.mkdirs();
                compilerConfiguration.setGeneratedDirectory(FileUtils.canonicalPath((File)file));
            }
        }
    }

    public boolean getWarnings() {
        return this.warnings;
    }

    public void cfgWarnings(ConfigurationValue cv, boolean b) {
        this.warnings = b;
    }

    public static ConfigurationInfo getWarningsInfo() {
        return new ConfigurationInfo();
    }

    public String getDumpConfig() {
        return this.dumpConfigFile;
    }

    public void cfgDumpConfig(ConfigurationValue cv, String filename) {
        this.dumpConfigFile = Configuration.getOutputPath(cv, filename);
    }

    public static ConfigurationInfo getDumpConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean isAdvanced() {
                return true;
            }

            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public static class BadESStrictCombination
    extends ConfigurationException {
        private static final long serialVersionUID = 384624904213418743L;
        public final boolean es;
        public final boolean strict;

        public BadESStrictCombination(boolean es, boolean strict) {
            super("");
            this.es = es;
            this.strict = strict;
        }

        public String getLevel() {
            return "warning";
        }
    }

    public static class BadAS3ESCombination
    extends ConfigurationException {
        private static final long serialVersionUID = 4418178171352281793L;
        public final boolean as3;
        public final boolean es;

        public BadAS3ESCombination(boolean as3, boolean es) {
            super("");
            this.as3 = as3;
            this.es = es;
        }
    }

    public static class DeprecatedConfigurationOption
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 5523004100027677184L;
        public final String var;
        public final String replacement;
        public final String since;

        public DeprecatedConfigurationOption(String var, String replacement, String since) {
            this.var = var;
            this.replacement = replacement;
            this.since = since;
        }
    }
}

