/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"legalArrangementCode", "legalArrangementEntityCodes"})
public class LegalArrangementRequest {
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE = "legalArrangementCode";
    private String legalArrangementCode;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITY_CODES = "legalArrangementEntityCodes";
    private List<String> legalArrangementEntityCodes = null;

    public LegalArrangementRequest legalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the legal arrangement to be deleted. If you also send `legalArrangementEntityCodes`, only the entities listed will be deleted.")
    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementCode() {
        return this.legalArrangementCode;
    }

    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
    }

    public LegalArrangementRequest legalArrangementEntityCodes(List<String> legalArrangementEntityCodes) {
        this.legalArrangementEntityCodes = legalArrangementEntityCodes;
        return this;
    }

    public LegalArrangementRequest addLegalArrangementEntityCodesItem(String legalArrangementEntityCodesItem) {
        if (this.legalArrangementEntityCodes == null) {
            this.legalArrangementEntityCodes = new ArrayList<String>();
        }
        this.legalArrangementEntityCodes.add(legalArrangementEntityCodesItem);
        return this;
    }

    @ApiModelProperty(value="List of legal arrangement entities to be deleted.")
    @JsonProperty(value="legalArrangementEntityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLegalArrangementEntityCodes() {
        return this.legalArrangementEntityCodes;
    }

    @JsonProperty(value="legalArrangementEntityCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementEntityCodes(List<String> legalArrangementEntityCodes) {
        this.legalArrangementEntityCodes = legalArrangementEntityCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalArrangementRequest legalArrangementRequest = (LegalArrangementRequest)o;
        return Objects.equals(this.legalArrangementCode, legalArrangementRequest.legalArrangementCode) && Objects.equals(this.legalArrangementEntityCodes, legalArrangementRequest.legalArrangementEntityCodes);
    }

    public int hashCode() {
        return Objects.hash(this.legalArrangementCode, this.legalArrangementEntityCodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalArrangementRequest {\n");
        sb.append("    legalArrangementCode: ").append(this.toIndentedString(this.legalArrangementCode)).append("\n");
        sb.append("    legalArrangementEntityCodes: ").append(this.toIndentedString(this.legalArrangementEntityCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static LegalArrangementRequest fromJson(String jsonString) throws JsonProcessingException {
        return (LegalArrangementRequest)JSON.getMapper().readValue(jsonString, LegalArrangementRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

