/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.Transaction;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"originalTransaction", "pspReference", "response"})
public class RefundResult {
    public static final String JSON_PROPERTY_ORIGINAL_TRANSACTION = "originalTransaction";
    private Transaction originalTransaction;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_RESPONSE = "response";
    private String response;

    public RefundResult originalTransaction(Transaction originalTransaction) {
        this.originalTransaction = originalTransaction;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="originalTransaction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Transaction getOriginalTransaction() {
        return this.originalTransaction;
    }

    @JsonProperty(value="originalTransaction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalTransaction(Transaction originalTransaction) {
        this.originalTransaction = originalTransaction;
    }

    public RefundResult pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="The reference of the refund.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public RefundResult response(String response) {
        this.response = response;
        return this;
    }

    @ApiModelProperty(value="The response indicating if the refund has been received for processing.")
    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResponse() {
        return this.response;
    }

    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponse(String response) {
        this.response = response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefundResult refundResult = (RefundResult)o;
        return Objects.equals(this.originalTransaction, refundResult.originalTransaction) && Objects.equals(this.pspReference, refundResult.pspReference) && Objects.equals(this.response, refundResult.response);
    }

    public int hashCode() {
        return Objects.hash(this.originalTransaction, this.pspReference, this.response);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefundResult {\n");
        sb.append("    originalTransaction: ").append(this.toIndentedString(this.originalTransaction)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static RefundResult fromJson(String jsonString) throws JsonProcessingException {
        return (RefundResult)JSON.getMapper().readValue(jsonString, RefundResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

