/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncQuery;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.Statement;

public final class AsyncQueryExecutor
extends AsyncMultiExecutor {
    private final RecordSequenceListener listener;

    public AsyncQueryExecutor(EventLoop eventLoop, RecordSequenceListener listener, Cluster cluster, QueryPolicy policy, Statement statement) throws AerospikeException {
        super(eventLoop, cluster);
        this.listener = listener;
        statement.prepare(true);
        Node[] nodes = cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Query failed because cluster is empty.");
        }
        AsyncMultiCommand[] tasks = new AsyncQuery[nodes.length];
        int count = 0;
        for (Node node : nodes) {
            tasks[count++] = new AsyncQuery(this, node, listener, policy, statement);
        }
        this.execute(tasks, policy.maxConcurrentNodes);
    }

    @Override
    protected void onSuccess() {
        this.listener.onSuccess();
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        this.listener.onFailure(ae);
    }
}

