/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cdt;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.MapBase;
import com.aerospike.client.cdt.MapPolicy;
import com.aerospike.client.cdt.MapReturnType;
import com.aerospike.client.util.Packer;
import java.util.List;
import java.util.Map;

public class MapOperation {
    public static Operation setMapPolicy(MapPolicy policy, String binName) {
        return MapBase.setMapPolicy(binName, policy.attributes);
    }

    public static Operation put(MapPolicy policy, String binName, Value key, Value value) {
        return MapBase.createPut(policy.itemCommand, policy.attributes, binName, key, value);
    }

    public static Operation putItems(MapPolicy policy, String binName, Map<Value, Value> map) {
        Packer packer = new Packer();
        packer.packRawShort(policy.itemsCommand);
        if (policy.itemsCommand == 70) {
            packer.packArrayBegin(1);
            packer.packValueMap(map);
        } else {
            packer.packArrayBegin(2);
            packer.packValueMap(map);
            packer.packInt(policy.attributes);
        }
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation increment(MapPolicy policy, String binName, Value key, Value incr) {
        return MapBase.createOperation(73, policy.attributes, binName, key, incr);
    }

    public static Operation decrement(MapPolicy policy, String binName, Value key, Value decr) {
        return MapBase.createOperation(74, policy.attributes, binName, key, decr);
    }

    public static Operation clear(String binName) {
        return MapBase.createOperation(75, Operation.Type.MAP_MODIFY, binName);
    }

    public static Operation removeByKey(String binName, Value key, MapReturnType returnType) {
        return MapBase.createOperation(76, Operation.Type.MAP_MODIFY, binName, key, returnType);
    }

    public static Operation removeByKeyList(String binName, List<Value> keys, MapReturnType returnType) {
        return MapBase.createOperation(81, Operation.Type.MAP_MODIFY, binName, keys, returnType);
    }

    public static Operation removeByKeyRange(String binName, Value keyBegin, Value keyEnd, MapReturnType returnType) {
        return MapBase.createRangeOperation(84, Operation.Type.MAP_MODIFY, binName, keyBegin, keyEnd, returnType);
    }

    public static Operation removeByValue(String binName, Value value, MapReturnType returnType) {
        return MapBase.createOperation(82, Operation.Type.MAP_MODIFY, binName, value, returnType);
    }

    public static Operation removeByValueList(String binName, List<Value> values, MapReturnType returnType) {
        return MapBase.createOperation(83, Operation.Type.MAP_MODIFY, binName, values, returnType);
    }

    public static Operation removeByValueRange(String binName, Value valueBegin, Value valueEnd, MapReturnType returnType) {
        return MapBase.createRangeOperation(86, Operation.Type.MAP_MODIFY, binName, valueBegin, valueEnd, returnType);
    }

    public static Operation removeByIndex(String binName, int index2, MapReturnType returnType) {
        return MapBase.createOperation(77, Operation.Type.MAP_MODIFY, binName, index2, returnType);
    }

    public static Operation removeByIndexRange(String binName, int index2, MapReturnType returnType) {
        return MapBase.createOperation(85, Operation.Type.MAP_MODIFY, binName, index2, returnType);
    }

    public static Operation removeByIndexRange(String binName, int index2, int count, MapReturnType returnType) {
        return MapBase.createOperation(85, Operation.Type.MAP_MODIFY, binName, index2, count, returnType);
    }

    public static Operation removeByRank(String binName, int rank, MapReturnType returnType) {
        return MapBase.createOperation(79, Operation.Type.MAP_MODIFY, binName, rank, returnType);
    }

    public static Operation removeByRankRange(String binName, int rank, MapReturnType returnType) {
        return MapBase.createOperation(87, Operation.Type.MAP_MODIFY, binName, rank, returnType);
    }

    public static Operation removeByRankRange(String binName, int rank, int count, MapReturnType returnType) {
        return MapBase.createOperation(87, Operation.Type.MAP_MODIFY, binName, rank, count, returnType);
    }

    public static Operation size(String binName) {
        return MapBase.createOperation(96, Operation.Type.MAP_READ, binName);
    }

    public static Operation getByKey(String binName, Value key, MapReturnType returnType) {
        return MapBase.createOperation(97, Operation.Type.MAP_READ, binName, key, returnType);
    }

    public static Operation getByKeyRange(String binName, Value keyBegin, Value keyEnd, MapReturnType returnType) {
        return MapBase.createRangeOperation(103, Operation.Type.MAP_READ, binName, keyBegin, keyEnd, returnType);
    }

    public static Operation getByValue(String binName, Value value, MapReturnType returnType) {
        return MapBase.createOperation(102, Operation.Type.MAP_READ, binName, value, returnType);
    }

    public static Operation getByValueRange(String binName, Value valueBegin, Value valueEnd, MapReturnType returnType) {
        return MapBase.createRangeOperation(105, Operation.Type.MAP_READ, binName, valueBegin, valueEnd, returnType);
    }

    public static Operation getByIndex(String binName, int index2, MapReturnType returnType) {
        return MapBase.createOperation(98, Operation.Type.MAP_READ, binName, index2, returnType);
    }

    public static Operation getByIndexRange(String binName, int index2, MapReturnType returnType) {
        return MapBase.createOperation(104, Operation.Type.MAP_READ, binName, index2, returnType);
    }

    public static Operation getByIndexRange(String binName, int index2, int count, MapReturnType returnType) {
        return MapBase.createOperation(104, Operation.Type.MAP_READ, binName, index2, count, returnType);
    }

    public static Operation getByRank(String binName, int rank, MapReturnType returnType) {
        return MapBase.createOperation(100, Operation.Type.MAP_READ, binName, rank, returnType);
    }

    public static Operation getByRankRange(String binName, int rank, MapReturnType returnType) {
        return MapBase.createOperation(106, Operation.Type.MAP_READ, binName, rank, returnType);
    }

    public static Operation getByRankRange(String binName, int rank, int count, MapReturnType returnType) {
        return MapBase.createOperation(106, Operation.Type.MAP_READ, binName, rank, count, returnType);
    }
}

