/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class NodeValidator {
    String name;
    List<Host> aliases;
    Host primaryHost;
    InetSocketAddress primaryAddress;
    Connection conn;
    int features;

    public void seedNodes(Cluster cluster, Host host, HashMap<String, Node> nodesToAdd) throws Exception {
        this.setAliases(host);
        Exception exception = null;
        boolean found = false;
        for (Host alias : this.aliases) {
            try {
                this.validateAlias(cluster, alias);
                found = true;
                if (!nodesToAdd.containsKey(this.name)) {
                    Node node = cluster.createNode(this);
                    nodesToAdd.put(this.name, node);
                    continue;
                }
                this.conn.close();
            }
            catch (Exception e) {
                if (Log.debugEnabled()) {
                    Log.debug("Alias " + alias + " failed: " + Util.getErrorMessage(e));
                }
                if (exception != null) continue;
                exception = e;
            }
        }
        if (!found) {
            throw exception;
        }
    }

    public void validateNode(Cluster cluster, Host host) throws Exception {
        this.setAliases(host);
        Exception exception = null;
        for (Host alias : this.aliases) {
            try {
                this.validateAlias(cluster, alias);
                return;
            }
            catch (Exception e) {
                if (Log.debugEnabled()) {
                    Log.debug("Alias " + alias + " failed: " + Util.getErrorMessage(e));
                }
                if (exception != null) continue;
                exception = e;
            }
        }
        throw exception;
    }

    private void setAliases(Host host) {
        InetAddress[] addresses;
        try {
            addresses = InetAddress.getAllByName(host.name);
        }
        catch (UnknownHostException uhe) {
            throw new AerospikeException.Connection("Invalid host: " + host);
        }
        if (addresses.length == 0) {
            throw new AerospikeException.Connection("Failed to find addresses for " + host);
        }
        this.aliases = new ArrayList<Host>(addresses.length + 2);
        for (InetAddress address : addresses) {
            this.aliases.add(new Host(address.getHostAddress(), host.tlsName, host.port));
        }
    }

    private void validateAlias(Cluster cluster, Host alias) throws Exception {
        InetSocketAddress address = new InetSocketAddress(alias.name, alias.port);
        Connection conn = new Connection(cluster.tlsPolicy, alias.tlsName, address, cluster.getConnectionTimeout(), cluster.maxSocketIdleNanos, null);
        try {
            String id;
            int gen;
            boolean hasClusterName;
            HashMap<String, String> map;
            String nodeName;
            if (cluster.user != null) {
                AdminCommand command = new AdminCommand(ThreadLocalData.getBuffer());
                command.authenticate(conn, cluster.user, cluster.password);
            }
            if ((nodeName = (map = (hasClusterName = cluster.clusterName != null && cluster.clusterName.length() > 0) ? Info.request(conn, "node", "partition-generation", "features", "cluster-name") : Info.request(conn, "node", "partition-generation", "features")).get("node")) == null) {
                throw new AerospikeException.InvalidNode();
            }
            String genString = map.get("partition-generation");
            try {
                gen = Integer.parseInt(genString);
            }
            catch (Exception ex) {
                throw new AerospikeException.InvalidNode("Invalid partition-generation: " + genString);
            }
            if (gen == -1) {
                throw new AerospikeException.InvalidNode("Node " + nodeName + ' ' + alias + " is not yet fully initialized");
            }
            if (hasClusterName && ((id = map.get("cluster-name")) == null || !cluster.clusterName.equals(id))) {
                throw new AerospikeException.InvalidNode("Node " + nodeName + ' ' + alias + ' ' + " expected cluster name '" + cluster.clusterName + "' received '" + id + "'");
            }
            this.name = nodeName;
            this.primaryHost = alias;
            this.primaryAddress = address;
            this.conn = conn;
            this.setFeatures(map);
        }
        catch (Exception e) {
            conn.close();
            throw e;
        }
    }

    private void setFeatures(HashMap<String, String> map) {
        try {
            String featuresString = map.get("features");
            int begin = 0;
            int end = 0;
            while (end < featuresString.length()) {
                int len;
                end = featuresString.indexOf(59, begin);
                if (end < 0) {
                    end = featuresString.length();
                }
                if (featuresString.regionMatches(begin, "geo", 0, len = end - begin)) {
                    this.features |= 1;
                } else if (featuresString.regionMatches(begin, "float", 0, len)) {
                    this.features |= 2;
                } else if (featuresString.regionMatches(begin, "batch-index", 0, len)) {
                    this.features |= 4;
                } else if (featuresString.regionMatches(begin, "replicas", 0, len)) {
                    this.features |= 0x20;
                } else if (featuresString.regionMatches(begin, "replicas-all", 0, len)) {
                    this.features |= 8;
                } else if (featuresString.regionMatches(begin, "peers", 0, len)) {
                    this.features |= 0x10;
                }
                begin = end + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

