/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.policy.BatchPolicy;
import java.util.ArrayList;
import java.util.List;

public final class BatchNode {
    public final Node node;
    public int[] offsets;
    public int offsetsSize;
    public List<BatchNamespace> batchNamespaces;

    public static List<BatchNode> generateList(Cluster cluster, BatchPolicy policy, Key[] keys) throws AerospikeException {
        Node[] nodes = cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Command failed because cluster is empty.");
        }
        int keysPerNode = keys.length / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        for (int i = 0; i < keys.length; ++i) {
            Partition partition = new Partition(keys[i]);
            Node node = cluster.getMasterNode(partition);
            BatchNode batchNode = BatchNode.findBatchNode(batchNodes, node);
            if (batchNode == null) {
                batchNodes.add(new BatchNode(node, keysPerNode, i));
                continue;
            }
            batchNode.addKey(i);
        }
        return batchNodes;
    }

    public static List<BatchNode> generateList(Cluster cluster, BatchPolicy policy, List<BatchRead> records) throws AerospikeException {
        Node[] nodes = cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Command failed because cluster is empty.");
        }
        int max = records.size();
        int keysPerNode = max / nodes.length;
        if ((keysPerNode += keysPerNode >>> 2) < 10) {
            keysPerNode = 10;
        }
        ArrayList<BatchNode> batchNodes = new ArrayList<BatchNode>(nodes.length);
        for (int i = 0; i < max; ++i) {
            Partition partition = new Partition(records.get((int)i).key);
            Node node = cluster.getMasterNode(partition);
            BatchNode batchNode = BatchNode.findBatchNode(batchNodes, node);
            if (batchNode == null) {
                batchNodes.add(new BatchNode(node, keysPerNode, i));
                continue;
            }
            batchNode.addKey(i);
        }
        return batchNodes;
    }

    private static BatchNode findBatchNode(List<BatchNode> nodes, Node node) {
        for (BatchNode batchNode : nodes) {
            if (batchNode.node != node) continue;
            return batchNode;
        }
        return null;
    }

    public BatchNode(Node node, int capacity, int offset) {
        this.node = node;
        this.offsets = new int[capacity];
        this.offsets[0] = offset;
        this.offsetsSize = 1;
    }

    public void addKey(int offset) {
        if (this.offsetsSize >= this.offsets.length) {
            int[] copy = new int[this.offsetsSize * 2];
            System.arraycopy(this.offsets, 0, copy, 0, this.offsetsSize);
            this.offsets = copy;
        }
        this.offsets[this.offsetsSize++] = offset;
    }

    public void splitByNamespace(Key[] keys) {
        String first = keys[this.offsets[0]].namespace;
        if (this.isSingleNamespace(keys, first)) {
            this.batchNamespaces = new ArrayList<BatchNamespace>(1);
            this.batchNamespaces.add(new BatchNamespace(first, this.offsets, this.offsetsSize));
            return;
        }
        this.batchNamespaces = new ArrayList<BatchNamespace>(4);
        for (int i = 0; i < this.offsetsSize; ++i) {
            int offset = this.offsets[i];
            String ns = keys[offset].namespace;
            BatchNamespace batchNamespace = this.findNamespace(this.batchNamespaces, ns);
            if (batchNamespace == null) {
                this.batchNamespaces.add(new BatchNamespace(ns, this.offsetsSize, offset));
                continue;
            }
            batchNamespace.add(offset);
        }
    }

    private boolean isSingleNamespace(Key[] keys, String first) {
        for (int i = 1; i < this.offsetsSize; ++i) {
            String ns = keys[this.offsets[i]].namespace;
            if (ns == first || ns.equals(first)) continue;
            return false;
        }
        return true;
    }

    private BatchNamespace findNamespace(List<BatchNamespace> batchNamespaces, String ns) {
        for (BatchNamespace batchNamespace : batchNamespaces) {
            if (batchNamespace.namespace != ns && !batchNamespace.namespace.equals(ns)) continue;
            return batchNamespace;
        }
        return null;
    }

    public static final class BatchNamespace {
        public final String namespace;
        public int[] offsets;
        public int offsetsSize;

        public BatchNamespace(String namespace, int capacity, int offset) {
            this.namespace = namespace;
            this.offsets = new int[capacity];
            this.offsets[0] = offset;
            this.offsetsSize = 1;
        }

        public BatchNamespace(String namespace, int[] offsets, int offsetsSize) {
            this.namespace = namespace;
            this.offsets = offsets;
            this.offsetsSize = offsetsSize;
        }

        public void add(int offset) {
            this.offsets[this.offsetsSize++] = offset;
        }
    }
}

