/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaBytes;
import com.aerospike.client.lua.LuaInstance;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public final class LuaBytesLib
extends OneArgFunction {
    private final LuaInstance instance;

    public LuaBytesLib(LuaInstance instance) {
        this.instance = instance;
        instance.load((LibFunction)new MetaLib(instance));
    }

    public LuaValue call(LuaValue env) {
        LuaTable meta = new LuaTable(0, 2);
        meta.set("__call", (LuaValue)new create(this.instance));
        LuaTable table = new LuaTable(0, 50);
        table.setmetatable((LuaValue)meta);
        new bytescode(table, 0, "size");
        new bytescode(table, 2, "get_byte");
        new bytescode(table, 3, "get_type");
        new bytescode(table, 4, "get_string");
        new bytescode(table, 5, "get_bytes");
        new bytescode(table, 6, "get_int16");
        new bytescode(table, 6, "get_int16_be");
        new bytescode(table, 7, "get_int16_le");
        new bytescode(table, 8, "get_int32");
        new bytescode(table, 8, "get_int32_be");
        new bytescode(table, 9, "get_int32_le");
        new bytescode(table, 10, "get_int64");
        new bytescode(table, 10, "get_int64_be");
        new bytescode(table, 11, "get_int64_le");
        new bytescode(table, 12, "get_var_int");
        new bytescode(table, 13, "set_var_int");
        new bytescode(table, 14, "append_var_int");
        new bytesbool(table, 0, "set_byte");
        new bytesbool(table, 1, "set_size");
        new bytesbool(table, 2, "set_type");
        new bytesbool(table, 3, "set_string");
        new bytesbool(table, 4, "set_bytes");
        new bytesbool(table, 5, "set_int16");
        new bytesbool(table, 5, "set_int16_be");
        new bytesbool(table, 6, "set_int16_le");
        new bytesbool(table, 7, "set_int32");
        new bytesbool(table, 7, "set_int32_be");
        new bytesbool(table, 8, "set_int32_le");
        new bytesbool(table, 9, "set_int64");
        new bytesbool(table, 9, "set_int64_be");
        new bytesbool(table, 10, "set_int64_le");
        new bytesbool(table, 11, "append_string");
        new bytesbool(table, 12, "append_bytes");
        new bytesbool(table, 13, "append_byte");
        new bytesbool(table, 14, "append_int16");
        new bytesbool(table, 14, "append_int16_be");
        new bytesbool(table, 15, "append_int16_le");
        new bytesbool(table, 16, "append_int32");
        new bytesbool(table, 16, "append_int32_be");
        new bytesbool(table, 17, "append_int32_le");
        new bytesbool(table, 18, "append_int64");
        new bytesbool(table, 18, "append_int64_be");
        new bytesbool(table, 19, "append_int64_le");
        this.instance.registerPackage("bytes", table);
        return table;
    }

    private static final class bytesbool
    extends VarArgFunction {
        public bytesbool(LuaTable table, int id, String name) {
            this.opcode = id;
            this.name = name;
            table.set(name, (LuaValue)this);
        }

        public Varargs invoke(Varargs args) {
            LuaBytes bytes = (LuaBytes)args.arg(1);
            try {
                switch (this.opcode) {
                    case 0: {
                        bytes.setByte(args.arg(2).toint() - 1, args.arg(3).tobyte());
                        break;
                    }
                    case 1: {
                        bytes.setCapacity(args.arg(2).toint() - 1);
                        break;
                    }
                    case 2: {
                        bytes.setType(args.arg(2).toint());
                        break;
                    }
                    case 3: {
                        bytes.setString(args.arg(2).toint() - 1, args.arg(3).tojstring());
                        break;
                    }
                    case 4: {
                        bytes.setBytes(args.arg(2).toint() - 1, (LuaBytes)args.arg(3), args.arg(4).toint());
                        break;
                    }
                    case 5: {
                        bytes.setBigInt16(args.arg(2).toint() - 1, args.arg(3).toint());
                        break;
                    }
                    case 6: {
                        bytes.setLittleInt16(args.arg(2).toint() - 1, args.arg(3).toint());
                        break;
                    }
                    case 7: {
                        bytes.setBigInt32(args.arg(2).toint() - 1, args.arg(3).toint());
                        break;
                    }
                    case 8: {
                        bytes.setLittleInt32(args.arg(2).toint() - 1, args.arg(3).toint());
                        break;
                    }
                    case 9: {
                        bytes.setBigInt64(args.arg(2).toint() - 1, args.arg(3).tolong());
                        break;
                    }
                    case 10: {
                        bytes.setLittleInt64(args.arg(2).toint() - 1, args.arg(3).tolong());
                        break;
                    }
                    case 11: {
                        bytes.appendString(args.arg(2).tojstring());
                        break;
                    }
                    case 12: {
                        bytes.appendBytes((LuaBytes)args.arg(2), args.arg(3).toint());
                        break;
                    }
                    case 13: {
                        bytes.appendBytes((LuaBytes)args.arg(2), args.arg(3).toint());
                        break;
                    }
                    case 14: {
                        bytes.appendByte(args.arg(2).tobyte());
                        break;
                    }
                    case 15: {
                        bytes.appendLittleInt16(args.arg(2).toint());
                        break;
                    }
                    case 16: {
                        bytes.appendBigInt32(args.arg(2).toint());
                        break;
                    }
                    case 17: {
                        bytes.appendLittleInt32(args.arg(2).toint());
                        break;
                    }
                    case 18: {
                        bytes.appendBigInt64(args.arg(2).tolong());
                        break;
                    }
                    case 19: {
                        bytes.appendLittleInt64(args.arg(2).tolong());
                        break;
                    }
                    default: {
                        return LuaValue.valueOf((boolean)false);
                    }
                }
                return LuaValue.valueOf((boolean)true);
            }
            catch (Exception e) {
                return LuaValue.valueOf((boolean)false);
            }
        }
    }

    private static final class bytescode
    extends VarArgFunction {
        public bytescode(LuaTable table, int id, String name) {
            this.opcode = id;
            this.name = name;
            table.set(name, (LuaValue)this);
        }

        public Varargs invoke(Varargs args) {
            LuaBytes bytes = (LuaBytes)args.arg(1);
            switch (this.opcode) {
                case 0: {
                    return LuaInteger.valueOf((int)bytes.size());
                }
                case 1: {
                    return LuaString.valueOf((String)bytes.toString());
                }
                case 2: {
                    return LuaInteger.valueOf((int)bytes.getByte(args.arg(2).toint() - 1));
                }
                case 3: {
                    return LuaInteger.valueOf((int)bytes.getType());
                }
                case 4: {
                    return LuaString.valueOf((String)bytes.getString(args.arg(2).toint() - 1, args.arg(3).toint()));
                }
                case 5: {
                    return bytes.getBytes(args.arg(2).toint() - 1, args.arg(3).toint());
                }
                case 6: {
                    return LuaInteger.valueOf((int)bytes.getBigInt16(args.arg(2).toint() - 1));
                }
                case 7: {
                    return LuaInteger.valueOf((int)bytes.getLittleInt16(args.arg(2).toint() - 1));
                }
                case 8: {
                    return LuaInteger.valueOf((int)bytes.getBigInt32(args.arg(2).toint() - 1));
                }
                case 9: {
                    return LuaInteger.valueOf((int)bytes.getLittleInt32(args.arg(2).toint() - 1));
                }
                case 10: {
                    return LuaNumber.valueOf((double)bytes.getBigInt64(args.arg(2).toint() - 1));
                }
                case 11: {
                    return LuaNumber.valueOf((double)bytes.getLittleInt64(args.arg(2).toint() - 1));
                }
                case 12: {
                    int[] results = bytes.getVarInt(args.arg(2).toint() - 1);
                    return LuaValue.varargsOf((LuaValue[])new LuaValue[]{LuaInteger.valueOf((int)results[0]), LuaInteger.valueOf((int)results[1])});
                }
                case 13: {
                    return LuaInteger.valueOf((int)bytes.setVarInt(args.arg(2).toint() - 1, args.arg(3).toint()));
                }
                case 14: {
                    return LuaInteger.valueOf((int)bytes.appendVarInt(args.arg(2).toint()));
                }
            }
            return NIL;
        }
    }

    private static final class create
    extends VarArgFunction {
        private final LuaInstance instance;

        public create(LuaInstance instance) {
            this.instance = instance;
        }

        public Varargs invoke(Varargs args) {
            int size = args.toint(2);
            return new LuaBytes(this.instance, size);
        }
    }

    private static final class MetaLib
    extends OneArgFunction {
        private final LuaInstance instance;

        public MetaLib(LuaInstance instance) {
            this.instance = instance;
        }

        public LuaValue call(LuaValue env) {
            LuaTable meta = new LuaTable(0, 5);
            new bytescode(meta, 0, "__len");
            new bytescode(meta, 1, "__tostring");
            new bytescode(meta, 2, "__index");
            new bytesbool(meta, 0, "__newindex");
            this.instance.registerPackage("Bytes", meta);
            return meta;
        }
    }
}

