/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import java.util.Random;

public final class RandomShift {
    private static final ThreadLocal<RandomShift> ThreadLocalInstance = new ThreadLocal<RandomShift>(){

        @Override
        protected RandomShift initialValue() {
            return new RandomShift();
        }
    };
    private long seed0;
    private long seed1;

    public static RandomShift instance() {
        return ThreadLocalInstance.get();
    }

    public RandomShift() {
        Random random = new Random();
        this.seed0 = random.nextLong();
        this.seed1 = random.nextLong();
    }

    public void nextBytes(byte[] bytes) {
        int len = bytes.length;
        int i = 0;
        while (i < len) {
            long r = this.nextLong();
            int n = Math.min(len - i, 8);
            for (int j = 0; j < n; ++j) {
                bytes[i++] = (byte)r;
                r >>= 8;
            }
        }
    }

    public int nextInt(int n) {
        return ((int)this.nextLong() & Integer.MAX_VALUE) % n;
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public long nextLong(long n) {
        return (this.nextLong() & Long.MAX_VALUE) % n;
    }

    public long nextLong() {
        long s0;
        long s1 = this.seed0;
        this.seed0 = s0 = this.seed1;
        s1 ^= s1 << 23;
        this.seed1 = s1 ^ s0 ^ s1 >>> 18 ^ s0 >>> 5;
        return this.seed1 + s0;
    }
}

