/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.Bin;
import com.aerospike.client.Value;

public final class Operation {
    public final Type type;
    public final String binName;
    public final Value value;

    public static Operation get(String binName) {
        return new Operation(Type.READ, binName);
    }

    public static Operation get() {
        return new Operation(Type.READ);
    }

    public static Operation getHeader() {
        return new Operation(Type.READ_HEADER);
    }

    public static Operation put(Bin bin) {
        return new Operation(Type.WRITE, bin.name, bin.value);
    }

    public static Operation append(Bin bin) {
        return new Operation(Type.APPEND, bin.name, bin.value);
    }

    public static Operation prepend(Bin bin) {
        return new Operation(Type.PREPEND, bin.name, bin.value);
    }

    public static Operation add(Bin bin) {
        return new Operation(Type.ADD, bin.name, bin.value);
    }

    public static Operation touch() {
        return new Operation(Type.TOUCH);
    }

    public static Operation delete() {
        return new Operation(Type.DELETE);
    }

    public Operation(Type type, String binName, Value value) {
        this.type = type;
        this.binName = binName;
        this.value = value;
    }

    private Operation(Type type, String binName) {
        this.type = type;
        this.binName = binName;
        this.value = Value.getAsNull();
    }

    private Operation(Type type) {
        this.type = type;
        this.binName = null;
        this.value = Value.getAsNull();
    }

    public static enum Type {
        READ(1),
        READ_HEADER(1),
        WRITE(2),
        CDT_READ(3),
        CDT_MODIFY(4),
        MAP_READ(3),
        MAP_MODIFY(4),
        ADD(5),
        APPEND(9),
        PREPEND(10),
        TOUCH(11),
        BIT_READ(12),
        BIT_MODIFY(13),
        DELETE(14);

        public final int protocolType;

        private Type(int protocolType) {
            this.protocolType = protocolType;
        }
    }
}

