/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.policy.WritePolicy;

public final class AsyncDelete
extends AsyncCommand {
    private final DeleteListener listener;
    private final WritePolicy writePolicy;
    private final Key key;
    private final Partition partition;
    private boolean existed;

    public AsyncDelete(Cluster cluster, DeleteListener listener, WritePolicy writePolicy, Key key) {
        super(writePolicy, false, true);
        this.listener = listener;
        this.writePolicy = writePolicy;
        this.key = key;
        this.partition = Partition.write(cluster, writePolicy, key);
    }

    @Override
    protected Node getNode(Cluster cluster) {
        return this.partition.getNodeWrite(cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setDelete(this.writePolicy, this.key);
    }

    @Override
    protected boolean parseResult() {
        this.validateHeaderSize();
        int resultCode = this.dataBuffer[5] & 0xFF;
        if (resultCode == 0) {
            this.existed = true;
            return true;
        }
        if (resultCode == 2) {
            this.existed = false;
            return true;
        }
        if (resultCode == 27) {
            if (this.policy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            this.existed = true;
            return true;
        }
        throw new AerospikeException(resultCode);
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryWrite(timeout);
        return true;
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.existed);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

