/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.AbstractTransformerMojo;
import java.io.File;
import javax.xml.transform.Transformer;

public abstract class AbstractHtmlMojo
extends AbstractTransformerMojo {
    private boolean chunkedOutput;

    protected String getNonDefaultStylesheetLocation() {
        if (this.chunkedOutput) {
            return "META-INF/docbkx/html/chunk.xsl";
        }
        return null;
    }

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        super.adjustTransformer(transformer, sourceFilename, targetFile);
        if (this.chunkedOutput) {
            this.getLog().debug((CharSequence)"Chunking output.");
            String rootFilename = targetFile.getName();
            rootFilename = rootFilename.substring(0, rootFilename.lastIndexOf(46));
            transformer.setParameter("root.filename", rootFilename);
            transformer.setParameter("base.dir", targetFile.getParent() + File.separator);
        }
    }
}

