/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.cors;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
public class CorsResponseFilter
implements ContainerResponseFilter {
    public static final String ALLOWED_METHODS = "GET, POST, PUT, DELETE, OPTIONS, HEAD";
    public static final int MAX_AGE = 151200;
    public static final String DEFAULT_ALLOWED_HEADERS = "origin,accept,content-type";

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        MultivaluedMap headers = responseContext.getHeaders();
        headers.add((Object)"Access-Control-Allow-Origin", (Object)"*");
        headers.add((Object)"Access-Control-Allow-Headers", (Object)this.getRequestedHeaders(requestContext));
        headers.add((Object)"Access-Control-Allow-Credentials", (Object)"true");
        headers.add((Object)"Access-Control-Allow-Methods", (Object)ALLOWED_METHODS);
        headers.add((Object)"Access-Control-Max-Age", (Object)151200);
        headers.add((Object)"x-responded-by", (Object)"cors-response-filter");
    }

    String getRequestedHeaders(ContainerRequestContext responseContext) {
        List headers = (List)responseContext.getHeaders().get((Object)"Access-Control-Request-Headers");
        return this.createHeaderList(headers);
    }

    String createHeaderList(List<String> headers) {
        if (headers == null || headers.isEmpty()) {
            return DEFAULT_ALLOWED_HEADERS;
        }
        StringBuilder retVal = new StringBuilder();
        for (int i = 0; i < headers.size(); ++i) {
            String header = headers.get(i);
            retVal.append(header);
            retVal.append(',');
        }
        retVal.append(DEFAULT_ALLOWED_HEADERS);
        return retVal.toString();
    }
}

