/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery;

import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class NacosDiscoveryClient
implements DiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryClient.class);
    public static final String DESCRIPTION = "Spring Cloud Nacos Discovery Client";
    private NacosServiceDiscovery serviceDiscovery;

    public NacosDiscoveryClient(NacosServiceDiscovery nacosServiceDiscovery) {
        this.serviceDiscovery = nacosServiceDiscovery;
    }

    public String description() {
        return DESCRIPTION;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        try {
            return this.serviceDiscovery.getInstances(serviceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get hosts from nacos server. serviceId: " + serviceId, e);
        }
    }

    public List<String> getServices() {
        try {
            return this.serviceDiscovery.getServices();
        }
        catch (Exception e) {
            log.error("get service name from nacos server fail,", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

