/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.stat.DruidDataSourceStatManagerMBean;
import com.alibaba.druid.stat.DruidStatService;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.DruidDataSourceUtils;
import com.alibaba.druid.util.JMXUtils;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class DruidDataSourceStatManager
implements DruidDataSourceStatManagerMBean {
    public static final String SYS_PROP_INSTANCES = "druid.dataSources";
    public static final String SYS_PROP_REGISTER_SYS_PROPERTY = "druid.registerToSysProperty";
    private static final Log LOG = LogFactory.getLog(DruidDataSourceStatManager.class);
    private static final DruidDataSourceStatManager instance = new DruidDataSourceStatManager();
    private final AtomicLong resetCount = new AtomicLong();
    private static volatile Map dataSources;
    private static final String MBEAN_NAME = "com.alibaba.druid:type=DruidDataSourceStat";
    private static CompositeType COMPOSITE_TYPE;

    public static DruidDataSourceStatManager getInstance() {
        return instance;
    }

    public static synchronized void clear() {
        Map<Object, ObjectName> dataSources = DruidDataSourceStatManager.getInstances();
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        for (Map.Entry<Object, ObjectName> item : dataSources.entrySet()) {
            Map.Entry<Object, ObjectName> entry = item;
            ObjectName objectName = entry.getValue();
            if (objectName == null) continue;
            try {
                mbeanServer.unregisterMBean(objectName);
            }
            catch (JMException e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<Object, ObjectName> getInstances() {
        Map tmp = dataSources;
        if (tmp != null) return dataSources;
        Class<DruidDataSourceStatManager> clazz = DruidDataSourceStatManager.class;
        synchronized (DruidDataSourceStatManager.class) {
            if (DruidDataSourceStatManager.isRegisterToSystemProperty()) {
                dataSources = DruidDataSourceStatManager.getInstances0();
            } else {
                tmp = dataSources;
                if (null != tmp) return dataSources;
                dataSources = tmp = Collections.synchronizedMap(new IdentityHashMap());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dataSources;
        }
    }

    public static boolean isRegisterToSystemProperty() {
        String value = System.getProperty(SYS_PROP_REGISTER_SYS_PROPERTY);
        return "true".equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<Object, ObjectName> getInstances0() {
        Properties properties = System.getProperties();
        Map instances = (Map)properties.get(SYS_PROP_INSTANCES);
        if (instances == null) {
            Properties properties2 = properties;
            synchronized (properties2) {
                instances = (IdentityHashMap)properties.get(SYS_PROP_INSTANCES);
                if (instances == null) {
                    instances = Collections.synchronizedMap(new IdentityHashMap());
                    properties.put(SYS_PROP_INSTANCES, instances);
                }
            }
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ObjectName addDataSource(Object dataSource, String name) {
        Map<Object, ObjectName> instances = DruidDataSourceStatManager.getInstances();
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Map<Object, ObjectName> map = instances;
        synchronized (map) {
            if (instances.size() == 0) {
                try {
                    ObjectName objectName = new ObjectName(MBEAN_NAME);
                    if (!mbeanServer.isRegistered(objectName)) {
                        mbeanServer.registerMBean(instance, objectName);
                    }
                }
                catch (JMException ex) {
                    LOG.error("register mbean error", ex);
                }
                DruidStatService.registerMBean();
            }
        }
        ObjectName objectName = null;
        if (name != null) {
            try {
                objectName = new ObjectName("com.alibaba.druid:type=DruidDataSource,id=" + name);
                mbeanServer.registerMBean(dataSource, objectName);
            }
            catch (Throwable ex) {
                LOG.error("register mbean error", ex);
                objectName = null;
            }
        }
        if (objectName == null) {
            try {
                int id = System.identityHashCode(dataSource);
                objectName = new ObjectName("com.alibaba.druid:type=DruidDataSource,id=" + id);
                mbeanServer.registerMBean(dataSource, objectName);
            }
            catch (Throwable ex) {
                LOG.error("register mbean error", ex);
                objectName = null;
            }
        }
        instances.put(dataSource, objectName);
        return objectName;
    }

    public static synchronized void removeDataSource(Object dataSource) {
        Map<Object, ObjectName> instances = DruidDataSourceStatManager.getInstances();
        ObjectName objectName = instances.remove(dataSource);
        if (objectName == null) {
            objectName = DruidDataSourceUtils.getObjectName(dataSource);
        }
        if (objectName == null) {
            LOG.error("unregister mbean failed. url " + DruidDataSourceUtils.getUrl(dataSource));
            return;
        }
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mbeanServer.unregisterMBean(objectName);
        }
        catch (Throwable ex) {
            LOG.error("unregister mbean error", ex);
        }
        if (instances.size() == 0) {
            try {
                mbeanServer.unregisterMBean(new ObjectName(MBEAN_NAME));
            }
            catch (Throwable ex) {
                LOG.error("unregister mbean error", ex);
            }
            DruidStatService.unregisterMBean();
        }
    }

    public static Set<DruidDataSource> getDruidDataSourceInstances() {
        DruidDataSourceStatManager.getInstances();
        return dataSources.keySet();
    }

    @Override
    public void reset() {
        Map<Object, ObjectName> dataSources = DruidDataSourceStatManager.getInstances();
        for (Object item : dataSources.keySet()) {
            try {
                Method method = item.getClass().getMethod("resetStat", new Class[0]);
                method.invoke(item, new Object[0]);
            }
            catch (Exception e) {
                LOG.error("resetStat error", e);
            }
        }
        this.resetCount.incrementAndGet();
    }

    public void logAndResetDataSource() {
        Map<Object, ObjectName> dataSources = DruidDataSourceStatManager.getInstances();
        for (Object item : dataSources.keySet()) {
            try {
                Method method = item.getClass().getMethod("logStats", new Class[0]);
                method.invoke(item, new Object[0]);
            }
            catch (Exception e) {
                LOG.error("resetStat error", e);
            }
        }
        this.resetCount.incrementAndGet();
    }

    @Override
    public long getResetCount() {
        return this.resetCount.get();
    }

    @Override
    public TabularData getDataSourceList() throws JMException {
        CompositeType rowType = DruidDataSourceStatManager.getDruidDataSourceCompositeType();
        String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
        TabularType tabularType = new TabularType("DruidDataSourceStat", "DruidDataSourceStat", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        Set<Object> dataSources = DruidDataSourceStatManager.getInstances().keySet();
        for (Object dataSource : dataSources) {
            data.put(this.getCompositeData(dataSource));
        }
        return data;
    }

    public CompositeDataSupport getCompositeData(Object dataSource) throws JMException {
        CompositeType rowType = DruidDataSourceStatManager.getDruidDataSourceCompositeType();
        Map<String, Object> map = DruidDataSourceUtils.getStatDataForMBean(dataSource);
        return new CompositeDataSupport(rowType, map);
    }

    public static CompositeType getDruidDataSourceCompositeType() throws JMException {
        String[] indexNames;
        if (COMPOSITE_TYPE != null) {
            return COMPOSITE_TYPE;
        }
        OpenType[] indexTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, JMXUtils.getThrowableCompositeType(), JMXUtils.getThrowableCompositeType(), SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.DATE, SimpleType.DATE, SimpleType.LONG, SimpleType.LONG};
        String[] indexDescriptions = indexNames = new String[]{"Name", "URL", "CreateCount", "DestroyCount", "ConnectCount", "CloseCount", "ActiveCount", "PoolingCount", "LockQueueLength", "WaitThreadCount", "InitialSize", "MaxActive", "MinIdle", "PoolPreparedStatements", "TestOnBorrow", "TestOnReturn", "MinEvictableIdleTimeMillis", "ConnectErrorCount", "CreateTimespanMillis", "DbType", "ValidationQuery", "ValidationQueryTimeout", "DriverClassName", "Username", "RemoveAbandonedCount", "NotEmptyWaitCount", "NotEmptyWaitNanos", "ErrorCount", "ReusePreparedStatementCount", "StartTransactionCount", "CommitCount", "RollbackCount", "LastError", "LastCreateError", "PreparedStatementCacheDeleteCount", "PreparedStatementCacheAccessCount", "PreparedStatementCacheMissCount", "PreparedStatementCacheHitCount", "PreparedStatementCacheCurrentCount", "Version", "LastErrorTime", "LastCreateErrorTime", "CreateErrorCount", "DiscardCount"};
        COMPOSITE_TYPE = new CompositeType("DataSourceStatistic", "DataSource Statistic", indexNames, indexDescriptions, indexTypes);
        return COMPOSITE_TYPE;
    }

    static {
        COMPOSITE_TYPE = null;
    }
}

