/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

/**
 * An interface for color maps.  These are passed to filters which convert gray values to
 * colors. This is similar to the ColorModel class but works with floating point values.
 */
public interface Colormap {
	/**
	 * Convert a value in the range 0..1 to an RGB color.
	 * @param v a value in the range 0..1
	 * @return an RGB color
	 */
	public int getColor(float v);
}

