/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

import java.awt.*;
import java.awt.image.*;

/**
 * Sets the opacity (alpha) of every pixel in an image to a constant value.
 */
public class OpacityFilter extends RGBImageFilter implements java.io.Serializable {

	static final long serialVersionUID = 5644263685527598345L;
	
	private int opacity;
	private int opacity24;

	/**
	 * Construct an OpacityFilter with 50% opacity.
	 */
	public OpacityFilter() {
		this(0x88);
	}

	/**
	 * Construct an OpacityFilter with the given opacity (alpha).
	 */
	public OpacityFilter(int opacity) {
		setOpacity(opacity);
	}

	/**
	 * Set the opacity.
	 * @param opacity the opacity (alpha) in the range 0..255
	 */
	public void setOpacity(int opacity) {
		this.opacity = opacity;
		opacity24 = opacity << 24;
	}
	
	/**
	 * Get the opacity setting.
	 * @return the opacity
	 */
	public int getOpacity() {
		return opacity;
	}
	
	public int filterRGB(int x, int y, int rgb) {
		if ((rgb & 0xff000000) != 0)
			return (rgb & 0xffffff) | opacity24;
		return rgb;
	}

	public String toString() {
		return "Colors/Transparency...";
	}

}

