/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.jenkins.plugins.workflow.libs;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;

public class CustomHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    private static final int MAX_RETRIES = 2;
    private static final int RETRY_INTERVAL_SECONDS = 3;
    private static final Set<Class<? extends IOException>> NON_RETRIABLE_CLASSES = new HashSet<Class>(Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, NoRouteToHostException.class));
    private final long retryIntervalMills = TimeUnit.SECONDS.toMillis(3L);

    CustomHttpRequestRetryHandler() {
        super(2, false, NON_RETRIABLE_CLASSES);
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        boolean shouldRetry = super.retryRequest(exception, executionCount, context);
        if (shouldRetry) {
            try {
                Thread.sleep(this.retryIntervalMills);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return shouldRetry;
    }
}

