/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.jenkins.plugins.workflow.libs;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

public class CustomServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private static final int MAX_RETRIES = 2;
    private static final int RETRY_INTERVAL_SECONDS = 3;
    private final long retryInterval;
    private Set<Integer> retryOnStatusCodes = new HashSet<Integer>(Arrays.asList(408, 500, 502, 503, 504));

    public CustomServiceUnavailableRetryStrategy() {
        this.retryInterval = TimeUnit.SECONDS.toMillis(3L);
    }

    public CustomServiceUnavailableRetryStrategy(Set<Integer> retryOnStatusCodes) {
        this();
        Args.notNull(retryOnStatusCodes, (String)"retryOnStatusCodes");
        this.retryOnStatusCodes = retryOnStatusCodes;
    }

    public boolean retryRequest(HttpResponse httpResponse, int executionCount, HttpContext httpContext) {
        return executionCount <= 2 && this.retryOnStatusCodes.contains(httpResponse.getStatusLine().getStatusCode());
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }
}

