/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.jenkins.plugins.workflow.libs;

import com.amadeus.jenkins.plugins.workflow.libs.CustomHttpRequestRetryHandler;
import com.amadeus.jenkins.plugins.workflow.libs.CustomServiceUnavailableRetryStrategy;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.security.ACL;
import hudson.slaves.WorkspaceList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.LibraryRetrieverDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@Restricted(value={NoExternalUse.class})
public class HttpRetriever
extends LibraryRetriever {
    private static final String HTTPS_PROTOCOL = "https";
    private final String httpURL;
    private final String credentialsId;
    private final boolean preemptiveAuth;
    private static final Logger LOGGER = Logger.getLogger(HttpRetriever.class.getName());

    @DataBoundConstructor
    public HttpRetriever(@NonNull String httpURL, @NonNull String credentialsId, boolean preemptiveAuth) {
        this.httpURL = httpURL;
        this.credentialsId = credentialsId;
        this.preemptiveAuth = preemptiveAuth;
    }

    Jenkins getJenkins() {
        return Jenkins.get();
    }

    public boolean isPreemptiveAuth() {
        return this.preemptiveAuth;
    }

    public String getHttpURL() {
        return this.httpURL;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void retrieve(@NonNull String name, @NonNull String version, @NonNull FilePath target, @NonNull Run<?, ?> run, @NonNull TaskListener listener) throws Exception {
        this.retrieve(name, version, true, target, run, listener);
    }

    public void retrieve(@NonNull String name, @NonNull String version, @NonNull boolean changelog, @NonNull FilePath target, @NonNull Run<?, ?> run, @NonNull TaskListener listener) throws Exception {
        String httpUrl = this.getHttpURL();
        if (httpUrl == null) {
            return;
        }
        if (httpUrl.isEmpty()) {
            throw new Exception("The URL of the shared library is empty.");
        }
        httpUrl = this.convertURLVersion(httpUrl, name, version);
        this.doRetrieve(httpUrl, name, version, target, listener, run);
    }

    private void doRetrieve(String sourceURL, String name, String version, FilePath target, @NonNull TaskListener listener, Run<?, ?> run) throws InterruptedException, IOException, URISyntaxException {
        UsernamePasswordCredentials passwordCredentials = this.initPasswordCredentials(run);
        String zipFileName = FilenameUtils.getName((String)new URL(sourceURL).getPath());
        FilePath dir = this.getDownloadFolder(name, run);
        Computer computer = this.getSlave();
        try (WorkspaceList.Lease lease = this.getWorkspace(dir, computer);){
            String sharedLibUpperDir;
            FilePath filePath = this.download(sourceURL, passwordCredentials, zipFileName, lease);
            this.unzip(lease, filePath);
            Object versionMessage = "";
            String resolvedVersion = this.readVersion(lease.path);
            if (resolvedVersion != null && !(resolvedVersion = resolvedVersion.trim()).equals(version)) {
                versionMessage = "Resolving version " + resolvedVersion + " of library " + name + "...\n";
            }
            versionMessage = (String)versionMessage + "From HTTP URL: " + sourceURL;
            listener.getLogger().println((String)versionMessage);
            if (lease.path.list().size() == 1 && ((FilePath)lease.path.list().get(0)).isDirectory() && !(sharedLibUpperDir = ((FilePath)lease.path.list().get(0)).getName()).equals("src") && !sharedLibUpperDir.equals("vars") && !sharedLibUpperDir.equals("resources")) {
                ((FilePath)lease.path.list().get(0)).moveAllChildrenTo(lease.path);
            }
            lease.path.copyRecursiveTo(target);
        }
    }

    UsernamePasswordCredentials initPasswordCredentials(Run<?, ?> run) {
        UsernamePasswordCredentials passwordCredentials;
        StandardUsernameCredentials credentials = (StandardUsernameCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, StandardUsernameCredentials.class, run);
        if (credentials instanceof UsernamePasswordCredentials) {
            passwordCredentials = (UsernamePasswordCredentials)credentials;
            CredentialsProvider.track((Node)this.getJenkins(), (com.cloudbees.plugins.credentials.Credentials)passwordCredentials);
        } else {
            passwordCredentials = null;
        }
        return passwordCredentials;
    }

    UsernamePasswordCredentials initPasswordCredentials() {
        if (!this.getJenkins().hasPermission(Jenkins.ADMINISTER)) {
            return null;
        }
        UsernamePasswordCredentials passwordCredentials = this.findCredentials(this.credentialsId);
        if (passwordCredentials != null) {
            CredentialsProvider.track((Node)this.getJenkins(), (com.cloudbees.plugins.credentials.Credentials)passwordCredentials);
            return passwordCredentials;
        }
        return null;
    }

    UsernamePasswordCredentials findCredentials(String credentialsId) {
        List standardUsernameCredentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)this.getJenkins(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        for (StandardUsernameCredentials standardUsernameCredential : standardUsernameCredentials) {
            if (!(standardUsernameCredential instanceof UsernamePasswordCredentials)) continue;
            UsernamePasswordCredentials passwordCredentials = (UsernamePasswordCredentials)standardUsernameCredential;
            if (standardUsernameCredential.getId() == null || !standardUsernameCredential.getId().equals(credentialsId)) continue;
            return passwordCredentials;
        }
        return null;
    }

    private void unzip(WorkspaceList.Lease lease, FilePath filePath) throws IOException, InterruptedException {
        try (ZipFile zipFile = new ZipFile(filePath.getRemote());){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                String fileName = zipEntries.nextElement().getName();
                if (fileName == null || !fileName.contains("..")) continue;
                throw new IOException("Unsupported ZIP format that contains relative paths to parent that could cause a security breach");
            }
        }
        filePath.unzip(lease.path);
        filePath.delete();
    }

    private FilePath download(String sourceURL, UsernamePasswordCredentials passwordCredentials, String zipFileName, WorkspaceList.Lease lease) throws IOException, URISyntaxException {
        URL url = new URL(sourceURL);
        HttpGet get = new HttpGet(url.toURI());
        try (CloseableHttpClient client = HttpRetriever.createCloseableHttpClient();){
            FilePath filePath;
            block13: {
                HttpClientContext context = this.getHttpClientContext(passwordCredentials, url);
                CloseableHttpResponse response = client.execute((HttpUriRequest)get, (HttpContext)context);
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        throw new IOException("Failed to download " + sourceURL + ". Returned code: " + statusCode);
                    }
                    filePath = this.writeResponseToFile(zipFileName, lease, (HttpResponse)response);
                    if (response == null) break block13;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return filePath;
        }
    }

    private FilePath writeResponseToFile(String zipFileName, WorkspaceList.Lease lease, HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        try (InputStream inputStream = entity.getContent();){
            String wholeFilenameWithTargetPath = lease.path.child(zipFileName).getRemote();
            File file = new File(wholeFilenameWithTargetPath);
            if (file.getParentFile().exists() || file.getParentFile().mkdirs()) {
                Files.copy(inputStream, Paths.get(wholeFilenameWithTargetPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                FilePath filePath = new FilePath(file);
                return filePath;
            }
            throw new IOException("Could not create the folders for " + wholeFilenameWithTargetPath);
        }
    }

    private org.apache.http.client.CredentialsProvider getCredentialsProvider(UsernamePasswordCredentials passwordCredentials) {
        if (passwordCredentials != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            String username = passwordCredentials.getUsername();
            String password = passwordCredentials.getPassword().getPlainText();
            org.apache.http.auth.UsernamePasswordCredentials credentials = new org.apache.http.auth.UsernamePasswordCredentials(username, password);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            return provider;
        }
        return null;
    }

    WorkspaceList.Lease getWorkspace(FilePath dir, Computer computer) throws InterruptedException {
        return computer.getWorkspaceList().allocate(dir);
    }

    private FilePath getDownloadFolder(String name, Run<?, ?> run) throws IOException {
        FilePath baseWorkspace;
        if (run.getParent() instanceof TopLevelItem) {
            baseWorkspace = this.getJenkins().getWorkspaceFor((TopLevelItem)run.getParent());
            if (baseWorkspace == null) {
                throw new IOException(this.getJenkins().getDisplayName() + " may be offline");
            }
        } else {
            throw new AbortException("Cannot check out in non-top-level build");
        }
        FilePath dir = baseWorkspace.withSuffix(HttpRetriever.getFilePathSuffix() + "libs").child(name);
        return dir;
    }

    Computer getSlave() throws IOException {
        Computer computer = this.getJenkins().toComputer();
        if (computer == null) {
            throw new IOException(this.getJenkins().getDisplayName() + " may be offline");
        }
        return computer;
    }

    private static String getFilePathSuffix() {
        return System.getProperty(WorkspaceList.class.getName(), "@");
    }

    public FormValidation validateVersion(@NonNull String name, @NonNull String version) {
        String replacedVersionURL = this.convertURLVersion(this.httpURL, name, version);
        try {
            URL newURL = new URL(replacedVersionURL);
            switch (this.checkURL(newURL)) {
                case 200: {
                    return this.validateVersionIfCheckIsOk(newURL, version);
                }
                case 401: {
                    return FormValidation.warning((String)"You are not authorized to access to this URL...");
                }
            }
            return FormValidation.warning((String)"This URL does not exist...");
        }
        catch (IOException | URISyntaxException e) {
            return FormValidation.warning((Throwable)e, (String)"Cannot validate default version.");
        }
    }

    private FormValidation validateVersionIfCheckIsOk(URL url, String version) {
        String valid = "Version " + version + " is valid.";
        if (this.isSecure(url)) {
            return FormValidation.ok((String)valid);
        }
        return FormValidation.warning((String)(valid + " But the protocol is insecure... Consider switching to HTTPS, particularly if you are using Credentials."));
    }

    boolean isSecure(URL url) {
        return HTTPS_PROTOCOL.equals(url.getProtocol());
    }

    private String readVersion(FilePath filePath) throws IOException, InterruptedException {
        String string;
        block8: {
            InputStream inputStream = filePath.child("version.txt").read();
            try {
                string = IOUtils.toString((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException | NoSuchFileException e) {
                    LOGGER.log(Level.FINER, "version.txt not found in the archive.", e);
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    private String convertURLVersion(String url, String name, String version) {
        Pattern p = Pattern.compile("\\$\\{library." + name + ".version\\}");
        Matcher match = p.matcher(url);
        return match.find() ? match.replaceAll(version) : url;
    }

    private int checkURL(URL url) throws IOException, URISyntaxException {
        UsernamePasswordCredentials passwordCredentials = this.initPasswordCredentials();
        HttpHead head = new HttpHead(url.toURI());
        try (CloseableHttpClient client = HttpRetriever.createCloseableHttpClient();){
            int n;
            block12: {
                HttpClientContext context = this.getHttpClientContext(passwordCredentials, url);
                CloseableHttpResponse response = client.execute((HttpUriRequest)head, (HttpContext)context);
                try {
                    n = response.getStatusLine().getStatusCode();
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return n;
        }
    }

    private static CloseableHttpClient createCloseableHttpClient() {
        return HttpClients.custom().setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new CustomServiceUnavailableRetryStrategy()).setRetryHandler((HttpRequestRetryHandler)new CustomHttpRequestRetryHandler()).build();
    }

    private HttpClientContext getHttpClientContext(UsernamePasswordCredentials passwordCredentials, URL url) {
        HttpClientContext context = HttpClientContext.create();
        if (passwordCredentials != null) {
            org.apache.http.client.CredentialsProvider credentialsProvider = this.getCredentialsProvider(passwordCredentials);
            context.setCredentialsProvider(credentialsProvider);
        }
        if (this.isPreemptiveAuth()) {
            this.setPreemptiveAuth(context, url);
        }
        return context;
    }

    private void setPreemptiveAuth(HttpClientContext context, URL url) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        HttpHost target = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        authCache.put(target, (AuthScheme)basicAuth);
        context.setAuthCache((AuthCache)authCache);
    }

    public LibraryRetrieverDescriptor getDescriptor() {
        return super.getDescriptor();
    }

    @Symbol(value={"http"})
    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class DescriptorImpl
    extends LibraryRetrieverDescriptor {
        @NonNull
        public String getDisplayName() {
            return "HTTP";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            result.includeEmptyValue();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            List standardUsernameCredentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList());
            for (StandardUsernameCredentials standardUsernameCredential : standardUsernameCredentials) {
                result.with((IdCredentials)standardUsernameCredential);
            }
            return result;
        }
    }
}

