/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import com.amashchenko.maven.plugin.gitflow.GitFlowVersionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.release.versions.VersionInfo;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

@Mojo(name="hotfix-finish", aggregator=true)
public class GitFlowHotfixFinishMojo
extends AbstractGitFlowMojo {
    @Parameter(property="skipTag", defaultValue="false")
    private boolean skipTag = false;
    @Parameter(property="keepBranch", defaultValue="false")
    private boolean keepBranch = false;
    @Parameter(property="skipTestProject", defaultValue="false")
    private boolean skipTestProject = false;
    @Parameter(property="pushRemote", defaultValue="true")
    private boolean pushRemote;
    @Parameter(property="preHotfixGoals")
    private String preHotfixGoals;
    @Parameter(property="postHotfixGoals")
    private String postHotfixGoals;
    @Parameter(property="hotfixVersion")
    private String hotfixVersion;
    @Parameter(property="gpgSignTag", defaultValue="false")
    private boolean gpgSignTag = false;
    @Parameter(defaultValue="false")
    protected boolean useSnapshotInHotfix;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(this.preHotfixGoals, this.postHotfixGoals);
        try {
            this.checkUncommittedChanges();
            String hotfixBranchName = null;
            if (this.settings.isInteractiveMode()) {
                hotfixBranchName = this.promptBranchName();
            } else if (StringUtils.isNotBlank((String)this.hotfixVersion)) {
                String branch = this.gitFlowConfig.getHotfixBranchPrefix() + this.hotfixVersion;
                if (!this.gitCheckBranchExists(branch)) {
                    throw new MojoFailureException("Hotfix branch with name '" + branch + "' doesn't exist. Cannot finish hotfix.");
                }
                hotfixBranchName = branch;
            }
            if (StringUtils.isBlank((String)hotfixBranchName)) {
                throw new MojoFailureException("Hotfix branch name to finish is blank.");
            }
            String supportBranchName = null;
            boolean supportHotfix = hotfixBranchName.startsWith(this.gitFlowConfig.getHotfixBranchPrefix() + this.gitFlowConfig.getSupportBranchPrefix());
            if (supportHotfix) {
                supportBranchName = hotfixBranchName.substring(this.gitFlowConfig.getHotfixBranchPrefix().length());
                supportBranchName = supportBranchName.substring(0, supportBranchName.lastIndexOf(47));
            }
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCompare(hotfixBranchName);
                if (supportBranchName != null) {
                    this.gitFetchRemoteAndCompare(supportBranchName);
                } else {
                    if (this.notSameProdDevName()) {
                        this.gitFetchRemoteAndCreate(this.gitFlowConfig.getDevelopmentBranch());
                        this.gitFetchRemoteAndCompare(this.gitFlowConfig.getDevelopmentBranch());
                    }
                    this.gitFetchRemoteAndCreate(this.gitFlowConfig.getProductionBranch());
                    this.gitFetchRemoteAndCompare(this.gitFlowConfig.getProductionBranch());
                }
            }
            if (!this.skipTestProject) {
                this.gitCheckout(hotfixBranchName);
                this.mvnCleanTest();
            }
            if (StringUtils.isNotBlank((String)this.preHotfixGoals)) {
                this.gitCheckout(hotfixBranchName);
                this.mvnRun(this.preHotfixGoals);
            }
            String currentHotfixVersion = this.getCurrentProjectVersion();
            if (this.useSnapshotInHotfix && ArtifactUtils.isSnapshot((String)currentHotfixVersion)) {
                String commitVersion = currentHotfixVersion.replace("-SNAPSHOT", "");
                this.mvnSetVersions(commitVersion);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("version", commitVersion);
                this.gitCommit(this.commitMessages.getHotfixStartMessage(), properties);
            }
            if (supportBranchName != null) {
                this.gitCheckout(supportBranchName);
            } else {
                this.gitCheckout(this.gitFlowConfig.getProductionBranch());
            }
            this.gitMergeNoff(hotfixBranchName);
            String currentVersion = this.getCurrentProjectVersion();
            if (!this.skipTag) {
                String tagVersion = currentVersion;
                if ((this.tychoBuild || this.useSnapshotInHotfix) && ArtifactUtils.isSnapshot((String)tagVersion)) {
                    tagVersion = tagVersion.replace("-SNAPSHOT", "");
                }
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("version", tagVersion);
                this.gitTag(this.gitFlowConfig.getVersionTagPrefix() + tagVersion, this.commitMessages.getTagHotfixMessage(), this.gpgSignTag, properties);
            }
            if (StringUtils.isNotBlank((String)this.postHotfixGoals)) {
                this.mvnRun(this.postHotfixGoals);
            }
            String releaseBranch = this.gitFindBranches(this.gitFlowConfig.getReleaseBranchPrefix(), true);
            if (supportBranchName == null) {
                if (StringUtils.isNotBlank((String)releaseBranch)) {
                    this.gitCheckout(releaseBranch);
                    this.gitMergeNoff(hotfixBranchName);
                } else {
                    String nextSnapshotVersion;
                    GitFlowVersionInfo developVersionInfo = new GitFlowVersionInfo(currentVersion);
                    if (this.notSameProdDevName()) {
                        this.gitCheckout(this.gitFlowConfig.getDevelopmentBranch());
                        developVersionInfo = new GitFlowVersionInfo(this.getCurrentProjectVersion());
                        this.mvnSetVersions(currentVersion);
                        this.gitCommit("update to hotfix version");
                        this.gitMergeNoff(hotfixBranchName);
                        GitFlowVersionInfo hotfixVersionInfo = new GitFlowVersionInfo(currentVersion);
                        if (developVersionInfo.compareTo((VersionInfo)hotfixVersionInfo) < 0) {
                            developVersionInfo = hotfixVersionInfo;
                        }
                    }
                    if (StringUtils.isBlank((String)(nextSnapshotVersion = developVersionInfo.getSnapshotVersionString()))) {
                        throw new MojoFailureException("Next snapshot version is blank.");
                    }
                    this.mvnSetVersions(nextSnapshotVersion);
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("version", nextSnapshotVersion);
                    this.gitCommit(this.commitMessages.getHotfixFinishMessage(), properties);
                }
            }
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (this.pushRemote) {
                if (supportBranchName != null) {
                    this.gitPush(supportBranchName, !this.skipTag);
                } else {
                    this.gitPush(this.gitFlowConfig.getProductionBranch(), !this.skipTag);
                    if (StringUtils.isBlank((String)releaseBranch) && this.notSameProdDevName()) {
                        this.gitPush(this.gitFlowConfig.getDevelopmentBranch(), !this.skipTag);
                    }
                }
                if (!this.keepBranch) {
                    this.gitPushDelete(hotfixBranchName);
                }
            }
            if (!this.keepBranch) {
                this.gitBranchDelete(hotfixBranchName);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("hotfix-finish", (Throwable)e);
        }
    }

    private String promptBranchName() throws MojoFailureException, CommandLineException {
        String hotfixBranches = this.gitFindBranches(this.gitFlowConfig.getHotfixBranchPrefix(), false);
        if (!this.gitFlowConfig.getHotfixBranchPrefix().endsWith("/")) {
            String supportHotfixBranches = this.gitFindBranches(this.gitFlowConfig.getHotfixBranchPrefix() + "*/*", false);
            hotfixBranches = hotfixBranches + supportHotfixBranches;
        }
        if (StringUtils.isBlank((String)hotfixBranches)) {
            throw new MojoFailureException("There are no hotfix branches.");
        }
        String[] branches = hotfixBranches.split("\\r?\\n");
        ArrayList<String> numberedList = new ArrayList<String>();
        StringBuilder str = new StringBuilder("Hotfix branches:").append(LS);
        for (int i = 0; i < branches.length; ++i) {
            str.append(i + 1 + ". " + branches[i] + LS);
            numberedList.add(String.valueOf(i + 1));
        }
        str.append("Choose hotfix branch to finish");
        String hotfixNumber = null;
        try {
            while (StringUtils.isBlank(hotfixNumber)) {
                hotfixNumber = this.prompter.prompt(str.toString(), numberedList);
            }
        }
        catch (PrompterException e) {
            throw new MojoFailureException("hotfix-finish", (Throwable)e);
        }
        String hotfixBranchName = null;
        if (hotfixNumber != null) {
            int num = Integer.parseInt(hotfixNumber);
            hotfixBranchName = branches[num - 1];
        }
        return hotfixBranchName;
    }
}

