/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import com.amashchenko.maven.plugin.gitflow.GitFlowVersionInfo;
import java.util.HashMap;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="release-finish", aggregator=true)
public class GitFlowReleaseFinishMojo
extends AbstractGitFlowMojo {
    @Parameter(property="skipTag", defaultValue="false")
    private boolean skipTag = false;
    @Parameter(property="keepBranch", defaultValue="false")
    private boolean keepBranch = false;
    @Parameter(property="skipTestProject", defaultValue="false")
    private boolean skipTestProject = false;
    @Parameter(property="allowSnapshots", defaultValue="false")
    private boolean allowSnapshots = false;
    @Parameter(property="releaseRebase", defaultValue="false")
    private boolean releaseRebase = false;
    @Parameter(property="releaseMergeNoFF", defaultValue="true")
    private boolean releaseMergeNoFF = true;
    @Parameter(property="pushRemote", defaultValue="true")
    private boolean pushRemote;
    @Parameter(property="releaseMergeFFOnly", defaultValue="false")
    private boolean releaseMergeFFOnly = false;
    @Parameter(property="digitsOnlyDevVersion", defaultValue="false")
    private boolean digitsOnlyDevVersion = false;
    @Parameter(property="developmentVersion", defaultValue="")
    private String developmentVersion = "";
    @Parameter(property="versionDigitToIncrement")
    private Integer versionDigitToIncrement;
    @Parameter(property="commitDevelopmentVersionAtStart", defaultValue="false")
    private boolean commitDevelopmentVersionAtStart;
    @Parameter(property="preReleaseGoals")
    private String preReleaseGoals;
    @Parameter(property="postReleaseGoals")
    private String postReleaseGoals;
    @Parameter(property="gpgSignTag", defaultValue="false")
    private boolean gpgSignTag = false;
    @Parameter(defaultValue="false")
    protected boolean useSnapshotInRelease;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(this.preReleaseGoals, this.postReleaseGoals);
        try {
            HashMap<String, String> properties;
            this.checkUncommittedChanges();
            String releaseBranch = this.gitFindBranches(this.gitFlowConfig.getReleaseBranchPrefix(), false).trim();
            if (StringUtils.isBlank((String)releaseBranch)) {
                throw new MojoFailureException("There is no release branch.");
            }
            if (StringUtils.countMatches((String)releaseBranch, (String)this.gitFlowConfig.getReleaseBranchPrefix()) > 1) {
                throw new MojoFailureException("More than one release branch exists. Cannot finish release.");
            }
            if (!this.allowSnapshots) {
                this.gitCheckout(releaseBranch);
                this.checkSnapshotDependencies();
            }
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCompare(releaseBranch);
                this.gitFetchRemoteAndCreate(this.gitFlowConfig.getDevelopmentBranch());
                this.gitFetchRemoteAndCompare(this.gitFlowConfig.getDevelopmentBranch());
                if (this.notSameProdDevName()) {
                    this.gitFetchRemoteAndCreate(this.gitFlowConfig.getProductionBranch());
                    this.gitFetchRemoteAndCompare(this.gitFlowConfig.getProductionBranch());
                }
            }
            if (!this.skipTestProject) {
                this.gitCheckout(releaseBranch);
                this.mvnCleanTest();
            }
            if (StringUtils.isNotBlank((String)this.preReleaseGoals)) {
                this.gitCheckout(releaseBranch);
                this.mvnRun(this.preReleaseGoals);
            }
            String currentReleaseVersion = this.getCurrentProjectVersion();
            if (this.useSnapshotInRelease && ArtifactUtils.isSnapshot((String)currentReleaseVersion)) {
                String commitVersion = currentReleaseVersion.replace("-SNAPSHOT", "");
                this.mvnSetVersions(commitVersion);
                HashMap<String, String> properties2 = new HashMap<String, String>();
                properties2.put("version", commitVersion);
                this.gitCommit(this.commitMessages.getReleaseFinishMessage(), properties2);
            }
            this.gitCheckout(this.gitFlowConfig.getProductionBranch());
            this.gitMerge(releaseBranch, this.releaseRebase, this.releaseMergeNoFF, this.releaseMergeFFOnly);
            String currentVersion = this.getCurrentProjectVersion();
            if (!this.skipTag) {
                String tagVersion = currentVersion;
                if ((this.tychoBuild || this.useSnapshotInRelease) && ArtifactUtils.isSnapshot((String)currentVersion)) {
                    tagVersion = currentVersion.replace("-SNAPSHOT", "");
                }
                properties = new HashMap<String, String>();
                properties.put("version", tagVersion);
                this.gitTag(this.gitFlowConfig.getVersionTagPrefix() + tagVersion, this.commitMessages.getTagReleaseMessage(), this.gpgSignTag, properties);
            }
            if (StringUtils.isNotBlank((String)this.postReleaseGoals)) {
                this.mvnRun(this.postReleaseGoals);
            }
            if (this.notSameProdDevName()) {
                this.gitCheckout(this.gitFlowConfig.getDevelopmentBranch());
                this.gitMerge(releaseBranch, this.releaseRebase, this.releaseMergeNoFF, false);
            }
            if (this.commitDevelopmentVersionAtStart && !this.notSameProdDevName()) {
                this.getLog().warn((CharSequence)"The commitDevelopmentVersionAtStart will not have effect. It can be enabled only when there are separate branches for development and production.");
                this.commitDevelopmentVersionAtStart = false;
            }
            if (!this.commitDevelopmentVersionAtStart) {
                String nextSnapshotVersion;
                if (!this.settings.isInteractiveMode() && StringUtils.isNotBlank((String)this.developmentVersion)) {
                    nextSnapshotVersion = this.developmentVersion;
                } else {
                    GitFlowVersionInfo versionInfo = new GitFlowVersionInfo(currentVersion);
                    if (this.digitsOnlyDevVersion) {
                        versionInfo = versionInfo.digitsVersionInfo();
                    }
                    nextSnapshotVersion = versionInfo.nextSnapshotVersion(this.versionDigitToIncrement);
                }
                if (StringUtils.isBlank((String)nextSnapshotVersion)) {
                    throw new MojoFailureException("Next snapshot version is blank.");
                }
                this.mvnSetVersions(nextSnapshotVersion);
                properties = new HashMap();
                properties.put("version", nextSnapshotVersion);
                this.gitCommit(this.commitMessages.getReleaseFinishMessage(), properties);
            }
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (this.pushRemote) {
                this.gitPush(this.gitFlowConfig.getProductionBranch(), !this.skipTag);
                if (this.notSameProdDevName()) {
                    this.gitPush(this.gitFlowConfig.getDevelopmentBranch(), !this.skipTag);
                }
                if (!this.keepBranch) {
                    this.gitPushDelete(releaseBranch);
                }
            }
            if (!this.keepBranch) {
                this.gitBranchDelete(releaseBranch);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("release-finish", (Throwable)e);
        }
    }
}

