/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import com.amashchenko.maven.plugin.gitflow.GitFlowVersionInfo;
import java.util.HashMap;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

@Mojo(name="release-start", aggregator=true)
public class GitFlowReleaseStartMojo
extends AbstractGitFlowMojo {
    @Parameter(property="sameBranchName", defaultValue="false")
    private boolean sameBranchName = false;
    @Parameter(property="allowSnapshots", defaultValue="false")
    private boolean allowSnapshots = false;
    @Parameter(property="releaseVersion", defaultValue="")
    private String releaseVersion = "";
    @Parameter(property="pushRemote", defaultValue="false")
    private boolean pushRemote;
    @Parameter(property="commitDevelopmentVersionAtStart", defaultValue="false")
    private boolean commitDevelopmentVersionAtStart;
    @Parameter(property="digitsOnlyDevVersion", defaultValue="false")
    private boolean digitsOnlyDevVersion = false;
    @Parameter(property="developmentVersion", defaultValue="")
    private String developmentVersion = "";
    @Parameter(property="versionDigitToIncrement")
    private Integer versionDigitToIncrement;
    @Parameter(property="fromCommit")
    private String fromCommit;
    @Parameter(defaultValue="false")
    protected boolean useSnapshotInRelease;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(new String[0]);
        try {
            this.initGitFlowConfig();
            this.checkUncommittedChanges();
            String releaseBranch = this.gitFindBranches(this.gitFlowConfig.getReleaseBranchPrefix(), true);
            if (StringUtils.isNotBlank((String)releaseBranch)) {
                throw new MojoFailureException("Release branch already exists. Cannot start release.");
            }
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCreate(this.gitFlowConfig.getDevelopmentBranch());
                this.gitFetchRemoteAndCompare(this.gitFlowConfig.getDevelopmentBranch());
            }
            String startPoint = StringUtils.isNotBlank((String)this.fromCommit) && this.notSameProdDevName() ? this.fromCommit : this.gitFlowConfig.getDevelopmentBranch();
            this.gitCheckout(startPoint);
            if (!this.allowSnapshots) {
                this.checkSnapshotDependencies();
            }
            if (this.commitDevelopmentVersionAtStart && !this.notSameProdDevName()) {
                this.getLog().warn((CharSequence)"The commitDevelopmentVersionAtStart will not have effect. It can be enabled only when there are separate branches for development and production.");
                this.commitDevelopmentVersionAtStart = false;
            }
            String releaseVersion = this.getReleaseVersion();
            String branchName = this.gitFlowConfig.getReleaseBranchPrefix();
            if (!this.sameBranchName) {
                branchName = branchName + releaseVersion;
            }
            String projectVersion = releaseVersion;
            if (this.useSnapshotInRelease && !ArtifactUtils.isSnapshot((String)projectVersion)) {
                projectVersion = projectVersion + "-" + "SNAPSHOT";
            }
            if (this.commitDevelopmentVersionAtStart) {
                this.commitProjectVersion(projectVersion, this.commitMessages.getReleaseStartMessage());
                this.gitCreateBranch(branchName, startPoint);
                String nextSnapshotVersion = this.getNextSnapshotVersion(releaseVersion);
                this.commitProjectVersion(nextSnapshotVersion, this.commitMessages.getReleaseFinishMessage());
                this.gitCheckout(branchName);
            } else {
                this.gitCreateAndCheckout(branchName, startPoint);
                this.commitProjectVersion(projectVersion, this.commitMessages.getReleaseStartMessage());
            }
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (this.pushRemote) {
                if (this.commitDevelopmentVersionAtStart) {
                    this.gitPush(this.gitFlowConfig.getDevelopmentBranch(), false);
                }
                this.gitPush(branchName, false);
            }
        }
        catch (CommandLineException e) {
            throw new MojoFailureException("release-start", (Throwable)e);
        }
        catch (VersionParseException e) {
            throw new MojoFailureException("release-start", (Throwable)e);
        }
    }

    private String getNextSnapshotVersion(String currentVersion) throws MojoFailureException, VersionParseException {
        String nextSnapshotVersion;
        if (!this.settings.isInteractiveMode() && StringUtils.isNotBlank((String)this.developmentVersion)) {
            nextSnapshotVersion = this.developmentVersion;
        } else {
            GitFlowVersionInfo versionInfo = new GitFlowVersionInfo(currentVersion);
            if (this.digitsOnlyDevVersion) {
                versionInfo = versionInfo.digitsVersionInfo();
            }
            nextSnapshotVersion = versionInfo.nextSnapshotVersion(this.versionDigitToIncrement);
        }
        if (StringUtils.isBlank((String)nextSnapshotVersion)) {
            throw new MojoFailureException("Next snapshot version is blank.");
        }
        return nextSnapshotVersion;
    }

    private String getReleaseVersion() throws MojoFailureException, VersionParseException, CommandLineException {
        String currentVersion = this.getCurrentProjectVersion();
        String defaultVersion = null;
        defaultVersion = this.tychoBuild ? currentVersion : new GitFlowVersionInfo(currentVersion).getReleaseVersionString();
        if (defaultVersion == null) {
            throw new MojoFailureException("Cannot get default project version.");
        }
        String version = null;
        if (this.settings.isInteractiveMode()) {
            try {
                while (version == null) {
                    version = this.prompter.prompt("What is release version? [" + defaultVersion + "]");
                    if ("".equals(version) || GitFlowVersionInfo.isValidVersion(version) && this.validBranchName(version)) continue;
                    this.getLog().info((CharSequence)"The version is not valid.");
                    version = null;
                }
            }
            catch (PrompterException e) {
                throw new MojoFailureException("release-start", (Throwable)e);
            }
        } else {
            version = this.releaseVersion;
        }
        if (StringUtils.isBlank((String)version)) {
            this.getLog().info((CharSequence)"Version is blank. Using default version.");
            version = defaultVersion;
        }
        return version;
    }

    private void commitProjectVersion(String version, String commitMessage) throws CommandLineException, MojoFailureException {
        String currentVersion = this.getCurrentProjectVersion();
        if (!version.equals(currentVersion)) {
            this.mvnSetVersions(version);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("version", version);
            this.gitCommit(commitMessage, properties);
        }
    }
}

