/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ec2.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="InstanceState", propOrder={"code", "name"})
public class InstanceState {
    @XmlElement(name="Code")
    protected int code;
    @XmlElement(name="Name", required=true)
    protected String name;

    public InstanceState() {
    }

    public InstanceState(int n, String string) {
        this.code = n;
        this.name = string;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n) {
        this.code = n;
    }

    public boolean isSetCode() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public InstanceState withCode(int n) {
        this.setCode(n);
        return this;
    }

    public InstanceState withName(String string) {
        this.setName(string);
        return this;
    }

    protected String toXMLFragment() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSetCode()) {
            stringBuffer.append("<Code>");
            stringBuffer.append(this.getCode() + "");
            stringBuffer.append("</Code>");
        }
        if (this.isSetName()) {
            stringBuffer.append("<Name>");
            stringBuffer.append(this.escapeXML(this.getName()));
            stringBuffer.append("</Name>");
        }
        return stringBuffer.toString();
    }

    private String escapeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&#039;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected String toJSONFragment() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (this.isSetCode()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.quoteJSON("Code"));
            stringBuffer.append(" : ");
            stringBuffer.append(this.quoteJSON(this.getCode() + ""));
            bl = false;
        }
        if (this.isSetName()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.quoteJSON("Name"));
            stringBuffer.append(" : ");
            stringBuffer.append(this.quoteJSON(this.getName()));
            bl = false;
        }
        return stringBuffer.toString();
    }

    private String quoteJSON(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                case '/': {
                    stringBuffer.append("\\/");
                    continue block10;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        stringBuffer.append("\\u" + String.format("%03x", c));
                        continue block10;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }
}

