/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ec2.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.SimpleTimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class S3UploadPolicy {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private String policySignature;
    private String policyString;

    public S3UploadPolicy(String string, String string2, String string3, String string4, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{").append("\"expiration\": \"").append(simpleDateFormat.format(calendar.getTime())).append("\",").append("\"conditions\": [").append("{\"bucket\": \"").append(string3).append("\"},").append("{\"acl\": \"").append("ec2-bundle-read").append("\"},").append("[\"starts-with\", \"$key\", \"").append(string4).append("\"]").append("]}");
        try {
            this.policyString = this.base64Encode(stringBuilder.toString().getBytes("UTF-8"));
            this.policySignature = this.signPolicy(string2, this.policyString);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to generate S3 upload policy", exception);
        }
    }

    public String getPolicyString() {
        return this.policyString;
    }

    public String getPolicySignature() {
        return this.policySignature;
    }

    private String signPolicy(String string, String string2) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(string.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(secretKeySpec);
        return this.base64Encode(mac.doFinal(string2.getBytes()));
    }

    private String base64Encode(byte[] byArray) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64((byte[])byArray), "UTF-8").replaceAll("\\s", "");
    }
}

