/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.keyvaluestore;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.KeyPairGeneratorSpec;
import com.amazonaws.internal.keyvaluestore.KeyProvider;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.util.Base64;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;

public class KeyProvider18
implements KeyProvider {
    private static final Log logger = LogFactory.getLog(KeyProvider18.class);
    static final String KEY_ALGORITHM_AES = "AES";
    static final int CIPHER_AES_GCM_NOPADDING_KEY_LENGTH_IN_BITS = 256;
    static final String ANDROID_KEY_STORE_NAME = "AndroidKeyStore";
    static final String KEY_ALGORITHM_RSA = "RSA";
    static final String CIPHER_RSA_MODE = "RSA/ECB/PKCS1Padding";
    static final String CIPHER_PROVIDER_NAME_FOR_RSA = "AndroidOpenSSL";
    static final int RSA_KEY_SIZE = 2048;
    static final String ENCRYPTED_AES_KEY = "AesGcmNoPadding18-encrypted-encryption-key";
    private static final Object LOCK = new Object();
    private SecureRandom secureRandom;

    @Override
    public Key getKey(SharedPreferences sharedPreferences, String keyAlias, Context context) {
        Object object = LOCK;
        synchronized (object) {
            try {
                KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
                keyStore.load(null);
                this.initializeRSAKeyFromKeyStore(context, keyStore, keyAlias);
                if (sharedPreferences.contains(ENCRYPTED_AES_KEY)) {
                    String encryptedAesEncryptionKey = sharedPreferences.getString(ENCRYPTED_AES_KEY, null);
                    return new SecretKeySpec(this.rsaDecrypt(keyAlias, Base64.decode(encryptedAesEncryptionKey)), KEY_ALGORITHM_AES);
                }
                this.secureRandom = new SecureRandom();
                KeyGenerator generator = KeyGenerator.getInstance(KEY_ALGORITHM_AES);
                generator.init(256, this.secureRandom);
                SecretKey aesEncryptionKey = generator.generateKey();
                sharedPreferences.edit().putString(ENCRYPTED_AES_KEY, Base64.encodeAsString(this.rsaEncrypt(keyAlias, aesEncryptionKey.getEncoded()))).apply();
                return aesEncryptionKey;
            }
            catch (Exception ex) {
                logger.error("Error in getting the key.", ex);
                throw new IllegalStateException(ex);
            }
        }
    }

    private byte[] rsaEncrypt(String keyAlias, byte[] rawData) {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
            keyStore.load(null);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, null);
            Cipher encryptCipher = Cipher.getInstance(CIPHER_RSA_MODE, CIPHER_PROVIDER_NAME_FOR_RSA);
            encryptCipher.init(1, privateKeyEntry.getCertificate().getPublicKey());
            return encryptCipher.doFinal(rawData);
        }
        catch (Exception ex) {
            logger.error("Exception occurred while encrypting data. " + ex.getMessage());
            return null;
        }
    }

    private byte[] rsaDecrypt(String keyAlias, byte[] encryptedData) {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
            keyStore.load(null);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, null);
            Cipher decryptCipher = Cipher.getInstance(CIPHER_RSA_MODE, CIPHER_PROVIDER_NAME_FOR_RSA);
            decryptCipher.init(2, privateKeyEntry.getPrivateKey());
            return decryptCipher.doFinal(encryptedData);
        }
        catch (Exception ex) {
            logger.error("Exception occurred while decrypting data. " + ex.getMessage());
            return null;
        }
    }

    private void initializeRSAKeyFromKeyStore(Context context, KeyStore keyStore, String keyAlias) throws Exception {
        if (!keyStore.containsAlias(keyAlias)) {
            Calendar start = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            end.add(1, 30);
            KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(context).setAlias(keyAlias).setSubject(new X500Principal("CN=" + keyAlias)).setSerialNumber(BigInteger.TEN).setStartDate(start.getTime()).setEndDate(end.getTime()).setKeySize(2048).build();
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA, ANDROID_KEY_STORE_NAME);
            kpg.initialize((AlgorithmParameterSpec)spec);
            kpg.generateKeyPair();
        } else {
            logger.info("Android KeyStore contains the alias: " + keyAlias);
        }
    }
}

