/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.Position;

@SdkInternalApi
public class PositionMarshaller {
    private static final MarshallingInfo<Integer> LINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("line").build();
    private static final MarshallingInfo<Integer> COLUMN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("column").build();
    private static final MarshallingInfo<Integer> OFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("offset").build();
    private static final PositionMarshaller instance = new PositionMarshaller();

    public static PositionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Position position, ProtocolMarshaller protocolMarshaller) {
        if (position == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)position.getLine(), LINE_BINDING);
            protocolMarshaller.marshall((Object)position.getColumn(), COLUMN_BINDING);
            protocolMarshaller.marshall((Object)position.getOffset(), OFFSET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

