/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.alexaforbusiness.model.ProfileData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchProfilesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ProfileData> profiles;
    private String nextToken;
    private Integer totalCount;

    public List<ProfileData> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Collection<ProfileData> profiles) {
        if (profiles == null) {
            this.profiles = null;
            return;
        }
        this.profiles = new ArrayList<ProfileData>(profiles);
    }

    public SearchProfilesResult withProfiles(ProfileData ... profiles) {
        if (this.profiles == null) {
            this.setProfiles(new ArrayList<ProfileData>(profiles.length));
        }
        for (ProfileData ele : profiles) {
            this.profiles.add(ele);
        }
        return this;
    }

    public SearchProfilesResult withProfiles(Collection<ProfileData> profiles) {
        this.setProfiles(profiles);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchProfilesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public SearchProfilesResult withTotalCount(Integer totalCount) {
        this.setTotalCount(totalCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProfiles() != null) {
            sb.append("Profiles: ").append(this.getProfiles()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getTotalCount() != null) {
            sb.append("TotalCount: ").append(this.getTotalCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProfilesResult)) {
            return false;
        }
        SearchProfilesResult other = (SearchProfilesResult)obj;
        if (other.getProfiles() == null ^ this.getProfiles() == null) {
            return false;
        }
        if (other.getProfiles() != null && !other.getProfiles().equals(this.getProfiles())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getTotalCount() == null ^ this.getTotalCount() == null) {
            return false;
        }
        return other.getTotalCount() == null || other.getTotalCount().equals(this.getTotalCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProfiles() == null ? 0 : this.getProfiles().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getTotalCount() == null ? 0 : this.getTotalCount().hashCode());
        return hashCode;
    }

    public SearchProfilesResult clone() {
        try {
            return (SearchProfilesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

