/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appconfig.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetDeployment" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetDeploymentResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the application that was deployed.
     * </p>
     */
    private String applicationId;
    /**
     * <p>
     * The ID of the environment that was deployed.
     * </p>
     */
    private String environmentId;
    /**
     * <p>
     * The ID of the deployment strategy that was deployed.
     * </p>
     */
    private String deploymentStrategyId;
    /**
     * <p>
     * The ID of the configuration profile that was deployed.
     * </p>
     */
    private String configurationProfileId;
    /**
     * <p>
     * The sequence number of the deployment.
     * </p>
     */
    private Integer deploymentNumber;
    /**
     * <p>
     * The name of the configuration.
     * </p>
     */
    private String configurationName;
    /**
     * <p>
     * Information about the source location of the configuration.
     * </p>
     */
    private String configurationLocationUri;
    /**
     * <p>
     * The configuration version that was deployed.
     * </p>
     */
    private String configurationVersion;
    /**
     * <p>
     * The description of the deployment.
     * </p>
     */
    private String description;
    /**
     * <p>
     * Total amount of time the deployment lasted.
     * </p>
     */
    private Integer deploymentDurationInMinutes;
    /**
     * <p>
     * The algorithm used to define how percentage grew over time.
     * </p>
     */
    private String growthType;
    /**
     * <p>
     * The percentage of targets to receive a deployed configuration during each interval.
     * </p>
     */
    private Float growthFactor;
    /**
     * <p>
     * The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no
     * longer eligible for automatic rollback.
     * </p>
     */
    private Integer finalBakeTimeInMinutes;
    /**
     * <p>
     * The state of the deployment.
     * </p>
     */
    private String state;
    /**
     * <p>
     * A list containing all events related to a deployment. The most recent events are displayed first.
     * </p>
     */
    private java.util.List<DeploymentEvent> eventLog;
    /**
     * <p>
     * The percentage of targets for which the deployment is available.
     * </p>
     */
    private Float percentageComplete;
    /**
     * <p>
     * The time the deployment started.
     * </p>
     */
    private java.util.Date startedAt;
    /**
     * <p>
     * The time the deployment completed.
     * </p>
     */
    private java.util.Date completedAt;
    /**
     * <p>
     * A list of extensions that were processed as part of the deployment. The extensions that were previously
     * associated to the configuration profile, environment, or the application when <code>StartDeployment</code> was
     * called.
     * </p>
     */
    private java.util.List<AppliedExtension> appliedExtensions;
    /**
     * <p>
     * The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can encrypt
     * secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted with SSE-KMS, or
     * secure string parameters stored in Amazon Web Services Systems Manager Parameter Store.
     * </p>
     */
    private String kmsKeyArn;
    /**
     * <p>
     * The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was created
     * or updated.
     * </p>
     */
    private String kmsKeyIdentifier;
    /**
     * <p>
     * A user-defined label for an AppConfig hosted configuration version.
     * </p>
     */
    private String versionLabel;

    /**
     * <p>
     * The ID of the application that was deployed.
     * </p>
     * 
     * @param applicationId
     *        The ID of the application that was deployed.
     */

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    /**
     * <p>
     * The ID of the application that was deployed.
     * </p>
     * 
     * @return The ID of the application that was deployed.
     */

    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * <p>
     * The ID of the application that was deployed.
     * </p>
     * 
     * @param applicationId
     *        The ID of the application that was deployed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withApplicationId(String applicationId) {
        setApplicationId(applicationId);
        return this;
    }

    /**
     * <p>
     * The ID of the environment that was deployed.
     * </p>
     * 
     * @param environmentId
     *        The ID of the environment that was deployed.
     */

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    /**
     * <p>
     * The ID of the environment that was deployed.
     * </p>
     * 
     * @return The ID of the environment that was deployed.
     */

    public String getEnvironmentId() {
        return this.environmentId;
    }

    /**
     * <p>
     * The ID of the environment that was deployed.
     * </p>
     * 
     * @param environmentId
     *        The ID of the environment that was deployed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withEnvironmentId(String environmentId) {
        setEnvironmentId(environmentId);
        return this;
    }

    /**
     * <p>
     * The ID of the deployment strategy that was deployed.
     * </p>
     * 
     * @param deploymentStrategyId
     *        The ID of the deployment strategy that was deployed.
     */

    public void setDeploymentStrategyId(String deploymentStrategyId) {
        this.deploymentStrategyId = deploymentStrategyId;
    }

    /**
     * <p>
     * The ID of the deployment strategy that was deployed.
     * </p>
     * 
     * @return The ID of the deployment strategy that was deployed.
     */

    public String getDeploymentStrategyId() {
        return this.deploymentStrategyId;
    }

    /**
     * <p>
     * The ID of the deployment strategy that was deployed.
     * </p>
     * 
     * @param deploymentStrategyId
     *        The ID of the deployment strategy that was deployed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withDeploymentStrategyId(String deploymentStrategyId) {
        setDeploymentStrategyId(deploymentStrategyId);
        return this;
    }

    /**
     * <p>
     * The ID of the configuration profile that was deployed.
     * </p>
     * 
     * @param configurationProfileId
     *        The ID of the configuration profile that was deployed.
     */

    public void setConfigurationProfileId(String configurationProfileId) {
        this.configurationProfileId = configurationProfileId;
    }

    /**
     * <p>
     * The ID of the configuration profile that was deployed.
     * </p>
     * 
     * @return The ID of the configuration profile that was deployed.
     */

    public String getConfigurationProfileId() {
        return this.configurationProfileId;
    }

    /**
     * <p>
     * The ID of the configuration profile that was deployed.
     * </p>
     * 
     * @param configurationProfileId
     *        The ID of the configuration profile that was deployed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withConfigurationProfileId(String configurationProfileId) {
        setConfigurationProfileId(configurationProfileId);
        return this;
    }

    /**
     * <p>
     * The sequence number of the deployment.
     * </p>
     * 
     * @param deploymentNumber
     *        The sequence number of the deployment.
     */

    public void setDeploymentNumber(Integer deploymentNumber) {
        this.deploymentNumber = deploymentNumber;
    }

    /**
     * <p>
     * The sequence number of the deployment.
     * </p>
     * 
     * @return The sequence number of the deployment.
     */

    public Integer getDeploymentNumber() {
        return this.deploymentNumber;
    }

    /**
     * <p>
     * The sequence number of the deployment.
     * </p>
     * 
     * @param deploymentNumber
     *        The sequence number of the deployment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withDeploymentNumber(Integer deploymentNumber) {
        setDeploymentNumber(deploymentNumber);
        return this;
    }

    /**
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @param configurationName
     *        The name of the configuration.
     */

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    /**
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @return The name of the configuration.
     */

    public String getConfigurationName() {
        return this.configurationName;
    }

    /**
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @param configurationName
     *        The name of the configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withConfigurationName(String configurationName) {
        setConfigurationName(configurationName);
        return this;
    }

    /**
     * <p>
     * Information about the source location of the configuration.
     * </p>
     * 
     * @param configurationLocationUri
     *        Information about the source location of the configuration.
     */

    public void setConfigurationLocationUri(String configurationLocationUri) {
        this.configurationLocationUri = configurationLocationUri;
    }

    /**
     * <p>
     * Information about the source location of the configuration.
     * </p>
     * 
     * @return Information about the source location of the configuration.
     */

    public String getConfigurationLocationUri() {
        return this.configurationLocationUri;
    }

    /**
     * <p>
     * Information about the source location of the configuration.
     * </p>
     * 
     * @param configurationLocationUri
     *        Information about the source location of the configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withConfigurationLocationUri(String configurationLocationUri) {
        setConfigurationLocationUri(configurationLocationUri);
        return this;
    }

    /**
     * <p>
     * The configuration version that was deployed.
     * </p>
     * 
     * @param configurationVersion
     *        The configuration version that was deployed.
     */

    public void setConfigurationVersion(String configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    /**
     * <p>
     * The configuration version that was deployed.
     * </p>
     * 
     * @return The configuration version that was deployed.
     */

    public String getConfigurationVersion() {
        return this.configurationVersion;
    }

    /**
     * <p>
     * The configuration version that was deployed.
     * </p>
     * 
     * @param configurationVersion
     *        The configuration version that was deployed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withConfigurationVersion(String configurationVersion) {
        setConfigurationVersion(configurationVersion);
        return this;
    }

    /**
     * <p>
     * The description of the deployment.
     * </p>
     * 
     * @param description
     *        The description of the deployment.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * The description of the deployment.
     * </p>
     * 
     * @return The description of the deployment.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * The description of the deployment.
     * </p>
     * 
     * @param description
     *        The description of the deployment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * Total amount of time the deployment lasted.
     * </p>
     * 
     * @param deploymentDurationInMinutes
     *        Total amount of time the deployment lasted.
     */

    public void setDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
        this.deploymentDurationInMinutes = deploymentDurationInMinutes;
    }

    /**
     * <p>
     * Total amount of time the deployment lasted.
     * </p>
     * 
     * @return Total amount of time the deployment lasted.
     */

    public Integer getDeploymentDurationInMinutes() {
        return this.deploymentDurationInMinutes;
    }

    /**
     * <p>
     * Total amount of time the deployment lasted.
     * </p>
     * 
     * @param deploymentDurationInMinutes
     *        Total amount of time the deployment lasted.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withDeploymentDurationInMinutes(Integer deploymentDurationInMinutes) {
        setDeploymentDurationInMinutes(deploymentDurationInMinutes);
        return this;
    }

    /**
     * <p>
     * The algorithm used to define how percentage grew over time.
     * </p>
     * 
     * @param growthType
     *        The algorithm used to define how percentage grew over time.
     * @see GrowthType
     */

    public void setGrowthType(String growthType) {
        this.growthType = growthType;
    }

    /**
     * <p>
     * The algorithm used to define how percentage grew over time.
     * </p>
     * 
     * @return The algorithm used to define how percentage grew over time.
     * @see GrowthType
     */

    public String getGrowthType() {
        return this.growthType;
    }

    /**
     * <p>
     * The algorithm used to define how percentage grew over time.
     * </p>
     * 
     * @param growthType
     *        The algorithm used to define how percentage grew over time.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GrowthType
     */

    public GetDeploymentResult withGrowthType(String growthType) {
        setGrowthType(growthType);
        return this;
    }

    /**
     * <p>
     * The algorithm used to define how percentage grew over time.
     * </p>
     * 
     * @param growthType
     *        The algorithm used to define how percentage grew over time.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see GrowthType
     */

    public GetDeploymentResult withGrowthType(GrowthType growthType) {
        this.growthType = growthType.toString();
        return this;
    }

    /**
     * <p>
     * The percentage of targets to receive a deployed configuration during each interval.
     * </p>
     * 
     * @param growthFactor
     *        The percentage of targets to receive a deployed configuration during each interval.
     */

    public void setGrowthFactor(Float growthFactor) {
        this.growthFactor = growthFactor;
    }

    /**
     * <p>
     * The percentage of targets to receive a deployed configuration during each interval.
     * </p>
     * 
     * @return The percentage of targets to receive a deployed configuration during each interval.
     */

    public Float getGrowthFactor() {
        return this.growthFactor;
    }

    /**
     * <p>
     * The percentage of targets to receive a deployed configuration during each interval.
     * </p>
     * 
     * @param growthFactor
     *        The percentage of targets to receive a deployed configuration during each interval.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withGrowthFactor(Float growthFactor) {
        setGrowthFactor(growthFactor);
        return this;
    }

    /**
     * <p>
     * The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no
     * longer eligible for automatic rollback.
     * </p>
     * 
     * @param finalBakeTimeInMinutes
     *        The amount of time that AppConfig monitored for alarms before considering the deployment to be complete
     *        and no longer eligible for automatic rollback.
     */

    public void setFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
        this.finalBakeTimeInMinutes = finalBakeTimeInMinutes;
    }

    /**
     * <p>
     * The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no
     * longer eligible for automatic rollback.
     * </p>
     * 
     * @return The amount of time that AppConfig monitored for alarms before considering the deployment to be complete
     *         and no longer eligible for automatic rollback.
     */

    public Integer getFinalBakeTimeInMinutes() {
        return this.finalBakeTimeInMinutes;
    }

    /**
     * <p>
     * The amount of time that AppConfig monitored for alarms before considering the deployment to be complete and no
     * longer eligible for automatic rollback.
     * </p>
     * 
     * @param finalBakeTimeInMinutes
     *        The amount of time that AppConfig monitored for alarms before considering the deployment to be complete
     *        and no longer eligible for automatic rollback.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withFinalBakeTimeInMinutes(Integer finalBakeTimeInMinutes) {
        setFinalBakeTimeInMinutes(finalBakeTimeInMinutes);
        return this;
    }

    /**
     * <p>
     * The state of the deployment.
     * </p>
     * 
     * @param state
     *        The state of the deployment.
     * @see DeploymentState
     */

    public void setState(String state) {
        this.state = state;
    }

    /**
     * <p>
     * The state of the deployment.
     * </p>
     * 
     * @return The state of the deployment.
     * @see DeploymentState
     */

    public String getState() {
        return this.state;
    }

    /**
     * <p>
     * The state of the deployment.
     * </p>
     * 
     * @param state
     *        The state of the deployment.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see DeploymentState
     */

    public GetDeploymentResult withState(String state) {
        setState(state);
        return this;
    }

    /**
     * <p>
     * The state of the deployment.
     * </p>
     * 
     * @param state
     *        The state of the deployment.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see DeploymentState
     */

    public GetDeploymentResult withState(DeploymentState state) {
        this.state = state.toString();
        return this;
    }

    /**
     * <p>
     * A list containing all events related to a deployment. The most recent events are displayed first.
     * </p>
     * 
     * @return A list containing all events related to a deployment. The most recent events are displayed first.
     */

    public java.util.List<DeploymentEvent> getEventLog() {
        return eventLog;
    }

    /**
     * <p>
     * A list containing all events related to a deployment. The most recent events are displayed first.
     * </p>
     * 
     * @param eventLog
     *        A list containing all events related to a deployment. The most recent events are displayed first.
     */

    public void setEventLog(java.util.Collection<DeploymentEvent> eventLog) {
        if (eventLog == null) {
            this.eventLog = null;
            return;
        }

        this.eventLog = new java.util.ArrayList<DeploymentEvent>(eventLog);
    }

    /**
     * <p>
     * A list containing all events related to a deployment. The most recent events are displayed first.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEventLog(java.util.Collection)} or {@link #withEventLog(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param eventLog
     *        A list containing all events related to a deployment. The most recent events are displayed first.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withEventLog(DeploymentEvent... eventLog) {
        if (this.eventLog == null) {
            setEventLog(new java.util.ArrayList<DeploymentEvent>(eventLog.length));
        }
        for (DeploymentEvent ele : eventLog) {
            this.eventLog.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list containing all events related to a deployment. The most recent events are displayed first.
     * </p>
     * 
     * @param eventLog
     *        A list containing all events related to a deployment. The most recent events are displayed first.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withEventLog(java.util.Collection<DeploymentEvent> eventLog) {
        setEventLog(eventLog);
        return this;
    }

    /**
     * <p>
     * The percentage of targets for which the deployment is available.
     * </p>
     * 
     * @param percentageComplete
     *        The percentage of targets for which the deployment is available.
     */

    public void setPercentageComplete(Float percentageComplete) {
        this.percentageComplete = percentageComplete;
    }

    /**
     * <p>
     * The percentage of targets for which the deployment is available.
     * </p>
     * 
     * @return The percentage of targets for which the deployment is available.
     */

    public Float getPercentageComplete() {
        return this.percentageComplete;
    }

    /**
     * <p>
     * The percentage of targets for which the deployment is available.
     * </p>
     * 
     * @param percentageComplete
     *        The percentage of targets for which the deployment is available.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withPercentageComplete(Float percentageComplete) {
        setPercentageComplete(percentageComplete);
        return this;
    }

    /**
     * <p>
     * The time the deployment started.
     * </p>
     * 
     * @param startedAt
     *        The time the deployment started.
     */

    public void setStartedAt(java.util.Date startedAt) {
        this.startedAt = startedAt;
    }

    /**
     * <p>
     * The time the deployment started.
     * </p>
     * 
     * @return The time the deployment started.
     */

    public java.util.Date getStartedAt() {
        return this.startedAt;
    }

    /**
     * <p>
     * The time the deployment started.
     * </p>
     * 
     * @param startedAt
     *        The time the deployment started.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withStartedAt(java.util.Date startedAt) {
        setStartedAt(startedAt);
        return this;
    }

    /**
     * <p>
     * The time the deployment completed.
     * </p>
     * 
     * @param completedAt
     *        The time the deployment completed.
     */

    public void setCompletedAt(java.util.Date completedAt) {
        this.completedAt = completedAt;
    }

    /**
     * <p>
     * The time the deployment completed.
     * </p>
     * 
     * @return The time the deployment completed.
     */

    public java.util.Date getCompletedAt() {
        return this.completedAt;
    }

    /**
     * <p>
     * The time the deployment completed.
     * </p>
     * 
     * @param completedAt
     *        The time the deployment completed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withCompletedAt(java.util.Date completedAt) {
        setCompletedAt(completedAt);
        return this;
    }

    /**
     * <p>
     * A list of extensions that were processed as part of the deployment. The extensions that were previously
     * associated to the configuration profile, environment, or the application when <code>StartDeployment</code> was
     * called.
     * </p>
     * 
     * @return A list of extensions that were processed as part of the deployment. The extensions that were previously
     *         associated to the configuration profile, environment, or the application when
     *         <code>StartDeployment</code> was called.
     */

    public java.util.List<AppliedExtension> getAppliedExtensions() {
        return appliedExtensions;
    }

    /**
     * <p>
     * A list of extensions that were processed as part of the deployment. The extensions that were previously
     * associated to the configuration profile, environment, or the application when <code>StartDeployment</code> was
     * called.
     * </p>
     * 
     * @param appliedExtensions
     *        A list of extensions that were processed as part of the deployment. The extensions that were previously
     *        associated to the configuration profile, environment, or the application when <code>StartDeployment</code>
     *        was called.
     */

    public void setAppliedExtensions(java.util.Collection<AppliedExtension> appliedExtensions) {
        if (appliedExtensions == null) {
            this.appliedExtensions = null;
            return;
        }

        this.appliedExtensions = new java.util.ArrayList<AppliedExtension>(appliedExtensions);
    }

    /**
     * <p>
     * A list of extensions that were processed as part of the deployment. The extensions that were previously
     * associated to the configuration profile, environment, or the application when <code>StartDeployment</code> was
     * called.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAppliedExtensions(java.util.Collection)} or {@link #withAppliedExtensions(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param appliedExtensions
     *        A list of extensions that were processed as part of the deployment. The extensions that were previously
     *        associated to the configuration profile, environment, or the application when <code>StartDeployment</code>
     *        was called.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withAppliedExtensions(AppliedExtension... appliedExtensions) {
        if (this.appliedExtensions == null) {
            setAppliedExtensions(new java.util.ArrayList<AppliedExtension>(appliedExtensions.length));
        }
        for (AppliedExtension ele : appliedExtensions) {
            this.appliedExtensions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of extensions that were processed as part of the deployment. The extensions that were previously
     * associated to the configuration profile, environment, or the application when <code>StartDeployment</code> was
     * called.
     * </p>
     * 
     * @param appliedExtensions
     *        A list of extensions that were processed as part of the deployment. The extensions that were previously
     *        associated to the configuration profile, environment, or the application when <code>StartDeployment</code>
     *        was called.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withAppliedExtensions(java.util.Collection<AppliedExtension> appliedExtensions) {
        setAppliedExtensions(appliedExtensions);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can encrypt
     * secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted with SSE-KMS, or
     * secure string parameters stored in Amazon Web Services Systems Manager Parameter Store.
     * </p>
     * 
     * @param kmsKeyArn
     *        The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can
     *        encrypt secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted
     *        with SSE-KMS, or secure string parameters stored in Amazon Web Services Systems Manager Parameter Store.
     */

    public void setKmsKeyArn(String kmsKeyArn) {
        this.kmsKeyArn = kmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can encrypt
     * secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted with SSE-KMS, or
     * secure string parameters stored in Amazon Web Services Systems Manager Parameter Store.
     * </p>
     * 
     * @return The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can
     *         encrypt secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted
     *         with SSE-KMS, or secure string parameters stored in Amazon Web Services Systems Manager Parameter Store.
     */

    public String getKmsKeyArn() {
        return this.kmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can encrypt
     * secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted with SSE-KMS, or
     * secure string parameters stored in Amazon Web Services Systems Manager Parameter Store.
     * </p>
     * 
     * @param kmsKeyArn
     *        The Amazon Resource Name of the Key Management Service key used to encrypt configuration data. You can
     *        encrypt secrets stored in Secrets Manager, Amazon Simple Storage Service (Amazon S3) objects encrypted
     *        with SSE-KMS, or secure string parameters stored in Amazon Web Services Systems Manager Parameter Store.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withKmsKeyArn(String kmsKeyArn) {
        setKmsKeyArn(kmsKeyArn);
        return this;
    }

    /**
     * <p>
     * The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was created
     * or updated.
     * </p>
     * 
     * @param kmsKeyIdentifier
     *        The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was
     *        created or updated.
     */

    public void setKmsKeyIdentifier(String kmsKeyIdentifier) {
        this.kmsKeyIdentifier = kmsKeyIdentifier;
    }

    /**
     * <p>
     * The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was created
     * or updated.
     * </p>
     * 
     * @return The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was
     *         created or updated.
     */

    public String getKmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    /**
     * <p>
     * The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was created
     * or updated.
     * </p>
     * 
     * @param kmsKeyIdentifier
     *        The Key Management Service key identifier (key ID, key alias, or key ARN) provided when the resource was
     *        created or updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withKmsKeyIdentifier(String kmsKeyIdentifier) {
        setKmsKeyIdentifier(kmsKeyIdentifier);
        return this;
    }

    /**
     * <p>
     * A user-defined label for an AppConfig hosted configuration version.
     * </p>
     * 
     * @param versionLabel
     *        A user-defined label for an AppConfig hosted configuration version.
     */

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    /**
     * <p>
     * A user-defined label for an AppConfig hosted configuration version.
     * </p>
     * 
     * @return A user-defined label for an AppConfig hosted configuration version.
     */

    public String getVersionLabel() {
        return this.versionLabel;
    }

    /**
     * <p>
     * A user-defined label for an AppConfig hosted configuration version.
     * </p>
     * 
     * @param versionLabel
     *        A user-defined label for an AppConfig hosted configuration version.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDeploymentResult withVersionLabel(String versionLabel) {
        setVersionLabel(versionLabel);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getApplicationId() != null)
            sb.append("ApplicationId: ").append(getApplicationId()).append(",");
        if (getEnvironmentId() != null)
            sb.append("EnvironmentId: ").append(getEnvironmentId()).append(",");
        if (getDeploymentStrategyId() != null)
            sb.append("DeploymentStrategyId: ").append(getDeploymentStrategyId()).append(",");
        if (getConfigurationProfileId() != null)
            sb.append("ConfigurationProfileId: ").append(getConfigurationProfileId()).append(",");
        if (getDeploymentNumber() != null)
            sb.append("DeploymentNumber: ").append(getDeploymentNumber()).append(",");
        if (getConfigurationName() != null)
            sb.append("ConfigurationName: ").append(getConfigurationName()).append(",");
        if (getConfigurationLocationUri() != null)
            sb.append("ConfigurationLocationUri: ").append(getConfigurationLocationUri()).append(",");
        if (getConfigurationVersion() != null)
            sb.append("ConfigurationVersion: ").append(getConfigurationVersion()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getDeploymentDurationInMinutes() != null)
            sb.append("DeploymentDurationInMinutes: ").append(getDeploymentDurationInMinutes()).append(",");
        if (getGrowthType() != null)
            sb.append("GrowthType: ").append(getGrowthType()).append(",");
        if (getGrowthFactor() != null)
            sb.append("GrowthFactor: ").append(getGrowthFactor()).append(",");
        if (getFinalBakeTimeInMinutes() != null)
            sb.append("FinalBakeTimeInMinutes: ").append(getFinalBakeTimeInMinutes()).append(",");
        if (getState() != null)
            sb.append("State: ").append(getState()).append(",");
        if (getEventLog() != null)
            sb.append("EventLog: ").append(getEventLog()).append(",");
        if (getPercentageComplete() != null)
            sb.append("PercentageComplete: ").append(getPercentageComplete()).append(",");
        if (getStartedAt() != null)
            sb.append("StartedAt: ").append(getStartedAt()).append(",");
        if (getCompletedAt() != null)
            sb.append("CompletedAt: ").append(getCompletedAt()).append(",");
        if (getAppliedExtensions() != null)
            sb.append("AppliedExtensions: ").append(getAppliedExtensions()).append(",");
        if (getKmsKeyArn() != null)
            sb.append("KmsKeyArn: ").append(getKmsKeyArn()).append(",");
        if (getKmsKeyIdentifier() != null)
            sb.append("KmsKeyIdentifier: ").append(getKmsKeyIdentifier()).append(",");
        if (getVersionLabel() != null)
            sb.append("VersionLabel: ").append(getVersionLabel());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetDeploymentResult == false)
            return false;
        GetDeploymentResult other = (GetDeploymentResult) obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null)
            return false;
        if (other.getApplicationId() != null && other.getApplicationId().equals(this.getApplicationId()) == false)
            return false;
        if (other.getEnvironmentId() == null ^ this.getEnvironmentId() == null)
            return false;
        if (other.getEnvironmentId() != null && other.getEnvironmentId().equals(this.getEnvironmentId()) == false)
            return false;
        if (other.getDeploymentStrategyId() == null ^ this.getDeploymentStrategyId() == null)
            return false;
        if (other.getDeploymentStrategyId() != null && other.getDeploymentStrategyId().equals(this.getDeploymentStrategyId()) == false)
            return false;
        if (other.getConfigurationProfileId() == null ^ this.getConfigurationProfileId() == null)
            return false;
        if (other.getConfigurationProfileId() != null && other.getConfigurationProfileId().equals(this.getConfigurationProfileId()) == false)
            return false;
        if (other.getDeploymentNumber() == null ^ this.getDeploymentNumber() == null)
            return false;
        if (other.getDeploymentNumber() != null && other.getDeploymentNumber().equals(this.getDeploymentNumber()) == false)
            return false;
        if (other.getConfigurationName() == null ^ this.getConfigurationName() == null)
            return false;
        if (other.getConfigurationName() != null && other.getConfigurationName().equals(this.getConfigurationName()) == false)
            return false;
        if (other.getConfigurationLocationUri() == null ^ this.getConfigurationLocationUri() == null)
            return false;
        if (other.getConfigurationLocationUri() != null && other.getConfigurationLocationUri().equals(this.getConfigurationLocationUri()) == false)
            return false;
        if (other.getConfigurationVersion() == null ^ this.getConfigurationVersion() == null)
            return false;
        if (other.getConfigurationVersion() != null && other.getConfigurationVersion().equals(this.getConfigurationVersion()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getDeploymentDurationInMinutes() == null ^ this.getDeploymentDurationInMinutes() == null)
            return false;
        if (other.getDeploymentDurationInMinutes() != null && other.getDeploymentDurationInMinutes().equals(this.getDeploymentDurationInMinutes()) == false)
            return false;
        if (other.getGrowthType() == null ^ this.getGrowthType() == null)
            return false;
        if (other.getGrowthType() != null && other.getGrowthType().equals(this.getGrowthType()) == false)
            return false;
        if (other.getGrowthFactor() == null ^ this.getGrowthFactor() == null)
            return false;
        if (other.getGrowthFactor() != null && other.getGrowthFactor().equals(this.getGrowthFactor()) == false)
            return false;
        if (other.getFinalBakeTimeInMinutes() == null ^ this.getFinalBakeTimeInMinutes() == null)
            return false;
        if (other.getFinalBakeTimeInMinutes() != null && other.getFinalBakeTimeInMinutes().equals(this.getFinalBakeTimeInMinutes()) == false)
            return false;
        if (other.getState() == null ^ this.getState() == null)
            return false;
        if (other.getState() != null && other.getState().equals(this.getState()) == false)
            return false;
        if (other.getEventLog() == null ^ this.getEventLog() == null)
            return false;
        if (other.getEventLog() != null && other.getEventLog().equals(this.getEventLog()) == false)
            return false;
        if (other.getPercentageComplete() == null ^ this.getPercentageComplete() == null)
            return false;
        if (other.getPercentageComplete() != null && other.getPercentageComplete().equals(this.getPercentageComplete()) == false)
            return false;
        if (other.getStartedAt() == null ^ this.getStartedAt() == null)
            return false;
        if (other.getStartedAt() != null && other.getStartedAt().equals(this.getStartedAt()) == false)
            return false;
        if (other.getCompletedAt() == null ^ this.getCompletedAt() == null)
            return false;
        if (other.getCompletedAt() != null && other.getCompletedAt().equals(this.getCompletedAt()) == false)
            return false;
        if (other.getAppliedExtensions() == null ^ this.getAppliedExtensions() == null)
            return false;
        if (other.getAppliedExtensions() != null && other.getAppliedExtensions().equals(this.getAppliedExtensions()) == false)
            return false;
        if (other.getKmsKeyArn() == null ^ this.getKmsKeyArn() == null)
            return false;
        if (other.getKmsKeyArn() != null && other.getKmsKeyArn().equals(this.getKmsKeyArn()) == false)
            return false;
        if (other.getKmsKeyIdentifier() == null ^ this.getKmsKeyIdentifier() == null)
            return false;
        if (other.getKmsKeyIdentifier() != null && other.getKmsKeyIdentifier().equals(this.getKmsKeyIdentifier()) == false)
            return false;
        if (other.getVersionLabel() == null ^ this.getVersionLabel() == null)
            return false;
        if (other.getVersionLabel() != null && other.getVersionLabel().equals(this.getVersionLabel()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getApplicationId() == null) ? 0 : getApplicationId().hashCode());
        hashCode = prime * hashCode + ((getEnvironmentId() == null) ? 0 : getEnvironmentId().hashCode());
        hashCode = prime * hashCode + ((getDeploymentStrategyId() == null) ? 0 : getDeploymentStrategyId().hashCode());
        hashCode = prime * hashCode + ((getConfigurationProfileId() == null) ? 0 : getConfigurationProfileId().hashCode());
        hashCode = prime * hashCode + ((getDeploymentNumber() == null) ? 0 : getDeploymentNumber().hashCode());
        hashCode = prime * hashCode + ((getConfigurationName() == null) ? 0 : getConfigurationName().hashCode());
        hashCode = prime * hashCode + ((getConfigurationLocationUri() == null) ? 0 : getConfigurationLocationUri().hashCode());
        hashCode = prime * hashCode + ((getConfigurationVersion() == null) ? 0 : getConfigurationVersion().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getDeploymentDurationInMinutes() == null) ? 0 : getDeploymentDurationInMinutes().hashCode());
        hashCode = prime * hashCode + ((getGrowthType() == null) ? 0 : getGrowthType().hashCode());
        hashCode = prime * hashCode + ((getGrowthFactor() == null) ? 0 : getGrowthFactor().hashCode());
        hashCode = prime * hashCode + ((getFinalBakeTimeInMinutes() == null) ? 0 : getFinalBakeTimeInMinutes().hashCode());
        hashCode = prime * hashCode + ((getState() == null) ? 0 : getState().hashCode());
        hashCode = prime * hashCode + ((getEventLog() == null) ? 0 : getEventLog().hashCode());
        hashCode = prime * hashCode + ((getPercentageComplete() == null) ? 0 : getPercentageComplete().hashCode());
        hashCode = prime * hashCode + ((getStartedAt() == null) ? 0 : getStartedAt().hashCode());
        hashCode = prime * hashCode + ((getCompletedAt() == null) ? 0 : getCompletedAt().hashCode());
        hashCode = prime * hashCode + ((getAppliedExtensions() == null) ? 0 : getAppliedExtensions().hashCode());
        hashCode = prime * hashCode + ((getKmsKeyArn() == null) ? 0 : getKmsKeyArn().hashCode());
        hashCode = prime * hashCode + ((getKmsKeyIdentifier() == null) ? 0 : getKmsKeyIdentifier().hashCode());
        hashCode = prime * hashCode + ((getVersionLabel() == null) ? 0 : getVersionLabel().hashCode());
        return hashCode;
    }

    @Override
    public GetDeploymentResult clone() {
        try {
            return (GetDeploymentResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
