/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appfabric;

import javax.annotation.Generated;

import com.amazonaws.services.appfabric.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSAppFabric}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAppFabric implements AWSAppFabric {

    protected AbstractAWSAppFabric() {
    }

    @Override
    public BatchGetUserAccessTasksResult batchGetUserAccessTasks(BatchGetUserAccessTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ConnectAppAuthorizationResult connectAppAuthorization(ConnectAppAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppAuthorizationResult createAppAuthorization(CreateAppAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAppBundleResult createAppBundle(CreateAppBundleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIngestionResult createIngestion(CreateIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIngestionDestinationResult createIngestionDestination(CreateIngestionDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppAuthorizationResult deleteAppAuthorization(DeleteAppAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAppBundleResult deleteAppBundle(DeleteAppBundleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIngestionResult deleteIngestion(DeleteIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIngestionDestinationResult deleteIngestionDestination(DeleteIngestionDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAppAuthorizationResult getAppAuthorization(GetAppAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAppBundleResult getAppBundle(GetAppBundleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIngestionResult getIngestion(GetIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIngestionDestinationResult getIngestionDestination(GetIngestionDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppAuthorizationsResult listAppAuthorizations(ListAppAuthorizationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAppBundlesResult listAppBundles(ListAppBundlesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIngestionDestinationsResult listIngestionDestinations(ListIngestionDestinationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIngestionsResult listIngestions(ListIngestionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartIngestionResult startIngestion(StartIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartUserAccessTasksResult startUserAccessTasks(StartUserAccessTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopIngestionResult stopIngestion(StopIngestionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAppAuthorizationResult updateAppAuthorization(UpdateAppAuthorizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIngestionDestinationResult updateIngestionDestination(UpdateIngestionDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
