/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.transform.OAuthPropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OAuthProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String tokenUrl;
    private String authCodeUrl;
    private List<String> oAuthScopes;

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public OAuthProperties withTokenUrl(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        return this;
    }

    public void setAuthCodeUrl(String authCodeUrl) {
        this.authCodeUrl = authCodeUrl;
    }

    public String getAuthCodeUrl() {
        return this.authCodeUrl;
    }

    public OAuthProperties withAuthCodeUrl(String authCodeUrl) {
        this.setAuthCodeUrl(authCodeUrl);
        return this;
    }

    public List<String> getOAuthScopes() {
        return this.oAuthScopes;
    }

    public void setOAuthScopes(Collection<String> oAuthScopes) {
        if (oAuthScopes == null) {
            this.oAuthScopes = null;
            return;
        }
        this.oAuthScopes = new ArrayList<String>(oAuthScopes);
    }

    public OAuthProperties withOAuthScopes(String ... oAuthScopes) {
        if (this.oAuthScopes == null) {
            this.setOAuthScopes(new ArrayList<String>(oAuthScopes.length));
        }
        for (String ele : oAuthScopes) {
            this.oAuthScopes.add(ele);
        }
        return this;
    }

    public OAuthProperties withOAuthScopes(Collection<String> oAuthScopes) {
        this.setOAuthScopes(oAuthScopes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTokenUrl() != null) {
            sb.append("TokenUrl: ").append(this.getTokenUrl()).append(",");
        }
        if (this.getAuthCodeUrl() != null) {
            sb.append("AuthCodeUrl: ").append(this.getAuthCodeUrl()).append(",");
        }
        if (this.getOAuthScopes() != null) {
            sb.append("OAuthScopes: ").append(this.getOAuthScopes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuthProperties)) {
            return false;
        }
        OAuthProperties other = (OAuthProperties)obj;
        if (other.getTokenUrl() == null ^ this.getTokenUrl() == null) {
            return false;
        }
        if (other.getTokenUrl() != null && !other.getTokenUrl().equals(this.getTokenUrl())) {
            return false;
        }
        if (other.getAuthCodeUrl() == null ^ this.getAuthCodeUrl() == null) {
            return false;
        }
        if (other.getAuthCodeUrl() != null && !other.getAuthCodeUrl().equals(this.getAuthCodeUrl())) {
            return false;
        }
        if (other.getOAuthScopes() == null ^ this.getOAuthScopes() == null) {
            return false;
        }
        return other.getOAuthScopes() == null || other.getOAuthScopes().equals(this.getOAuthScopes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTokenUrl() == null ? 0 : this.getTokenUrl().hashCode());
        hashCode = 31 * hashCode + (this.getAuthCodeUrl() == null ? 0 : this.getAuthCodeUrl().hashCode());
        hashCode = 31 * hashCode + (this.getOAuthScopes() == null ? 0 : this.getOAuthScopes().hashCode());
        return hashCode;
    }

    public OAuthProperties clone() {
        try {
            return (OAuthProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OAuthPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

