/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationcostprofiler;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.applicationcostprofiler.AWSApplicationCostProfiler;
import com.amazonaws.services.applicationcostprofiler.AWSApplicationCostProfilerClientBuilder;
import com.amazonaws.services.applicationcostprofiler.model.AWSApplicationCostProfilerException;
import com.amazonaws.services.applicationcostprofiler.model.DeleteReportDefinitionRequest;
import com.amazonaws.services.applicationcostprofiler.model.DeleteReportDefinitionResult;
import com.amazonaws.services.applicationcostprofiler.model.GetReportDefinitionRequest;
import com.amazonaws.services.applicationcostprofiler.model.GetReportDefinitionResult;
import com.amazonaws.services.applicationcostprofiler.model.ImportApplicationUsageRequest;
import com.amazonaws.services.applicationcostprofiler.model.ImportApplicationUsageResult;
import com.amazonaws.services.applicationcostprofiler.model.ListReportDefinitionsRequest;
import com.amazonaws.services.applicationcostprofiler.model.ListReportDefinitionsResult;
import com.amazonaws.services.applicationcostprofiler.model.PutReportDefinitionRequest;
import com.amazonaws.services.applicationcostprofiler.model.PutReportDefinitionResult;
import com.amazonaws.services.applicationcostprofiler.model.UpdateReportDefinitionRequest;
import com.amazonaws.services.applicationcostprofiler.model.UpdateReportDefinitionResult;
import com.amazonaws.services.applicationcostprofiler.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.DeleteReportDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.DeleteReportDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.GetReportDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.GetReportDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.ImportApplicationUsageRequestProtocolMarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.ImportApplicationUsageResultJsonUnmarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.ListReportDefinitionsRequestProtocolMarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.ListReportDefinitionsResultJsonUnmarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.PutReportDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.PutReportDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.UpdateReportDefinitionRequestProtocolMarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.UpdateReportDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.applicationcostprofiler.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSApplicationCostProfilerClient
extends AmazonWebServiceClient
implements AWSApplicationCostProfiler {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSApplicationCostProfiler.class);
    private static final String DEFAULT_SIGNING_NAME = "application-cost-profiler";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSApplicationCostProfilerException.class));

    public static AWSApplicationCostProfilerClientBuilder builder() {
        return AWSApplicationCostProfilerClientBuilder.standard();
    }

    AWSApplicationCostProfilerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSApplicationCostProfilerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("application-cost-profiler.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/applicationcostprofiler/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/applicationcostprofiler/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteReportDefinitionResult deleteReportDefinition(DeleteReportDefinitionRequest request) {
        request = (DeleteReportDefinitionRequest)this.beforeClientExecution(request);
        return this.executeDeleteReportDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteReportDefinitionResult executeDeleteReportDefinition(DeleteReportDefinitionRequest deleteReportDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteReportDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteReportDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteReportDefinitionRequestProtocolMarshaller(protocolFactory).marshall((DeleteReportDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteReportDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ApplicationCostProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteReportDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteReportDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteReportDefinitionResult deleteReportDefinitionResult = (DeleteReportDefinitionResult)response.getAwsResponse();
            return deleteReportDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetReportDefinitionResult getReportDefinition(GetReportDefinitionRequest request) {
        request = (GetReportDefinitionRequest)this.beforeClientExecution(request);
        return this.executeGetReportDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetReportDefinitionResult executeGetReportDefinition(GetReportDefinitionRequest getReportDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getReportDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetReportDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetReportDefinitionRequestProtocolMarshaller(protocolFactory).marshall((GetReportDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getReportDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ApplicationCostProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetReportDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReportDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetReportDefinitionResult getReportDefinitionResult = (GetReportDefinitionResult)response.getAwsResponse();
            return getReportDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ImportApplicationUsageResult importApplicationUsage(ImportApplicationUsageRequest request) {
        request = (ImportApplicationUsageRequest)this.beforeClientExecution(request);
        return this.executeImportApplicationUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ImportApplicationUsageResult executeImportApplicationUsage(ImportApplicationUsageRequest importApplicationUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(importApplicationUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ImportApplicationUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ImportApplicationUsageRequestProtocolMarshaller(protocolFactory).marshall((ImportApplicationUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)importApplicationUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ApplicationCostProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ImportApplicationUsage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ImportApplicationUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ImportApplicationUsageResult importApplicationUsageResult = (ImportApplicationUsageResult)response.getAwsResponse();
            return importApplicationUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListReportDefinitionsResult listReportDefinitions(ListReportDefinitionsRequest request) {
        request = (ListReportDefinitionsRequest)this.beforeClientExecution(request);
        return this.executeListReportDefinitions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListReportDefinitionsResult executeListReportDefinitions(ListReportDefinitionsRequest listReportDefinitionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listReportDefinitionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListReportDefinitionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListReportDefinitionsRequestProtocolMarshaller(protocolFactory).marshall((ListReportDefinitionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listReportDefinitionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ApplicationCostProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListReportDefinitions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListReportDefinitionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListReportDefinitionsResult listReportDefinitionsResult = (ListReportDefinitionsResult)response.getAwsResponse();
            return listReportDefinitionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutReportDefinitionResult putReportDefinition(PutReportDefinitionRequest request) {
        request = (PutReportDefinitionRequest)this.beforeClientExecution(request);
        return this.executePutReportDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutReportDefinitionResult executePutReportDefinition(PutReportDefinitionRequest putReportDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putReportDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutReportDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutReportDefinitionRequestProtocolMarshaller(protocolFactory).marshall((PutReportDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)putReportDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ApplicationCostProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutReportDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutReportDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutReportDefinitionResult putReportDefinitionResult = (PutReportDefinitionResult)response.getAwsResponse();
            return putReportDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateReportDefinitionResult updateReportDefinition(UpdateReportDefinitionRequest request) {
        request = (UpdateReportDefinitionRequest)this.beforeClientExecution(request);
        return this.executeUpdateReportDefinition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateReportDefinitionResult executeUpdateReportDefinition(UpdateReportDefinitionRequest updateReportDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateReportDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateReportDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateReportDefinitionRequestProtocolMarshaller(protocolFactory).marshall((UpdateReportDefinitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateReportDefinitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ApplicationCostProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateReportDefinition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateReportDefinitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateReportDefinitionResult updateReportDefinitionResult = (UpdateReportDefinitionResult)response.getAwsResponse();
            return updateReportDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

