/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SuspendProcessesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String autoScalingGroupName;
    private SdkInternalList<String> scalingProcesses;

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public SuspendProcessesRequest withAutoScalingGroupName(String autoScalingGroupName) {
        this.setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    public List<String> getScalingProcesses() {
        if (this.scalingProcesses == null) {
            this.scalingProcesses = new SdkInternalList();
        }
        return this.scalingProcesses;
    }

    public void setScalingProcesses(Collection<String> scalingProcesses) {
        if (scalingProcesses == null) {
            this.scalingProcesses = null;
            return;
        }
        this.scalingProcesses = new SdkInternalList(scalingProcesses);
    }

    public SuspendProcessesRequest withScalingProcesses(String ... scalingProcesses) {
        if (this.scalingProcesses == null) {
            this.setScalingProcesses((Collection<String>)new SdkInternalList(scalingProcesses.length));
        }
        for (String ele : scalingProcesses) {
            this.scalingProcesses.add((Object)ele);
        }
        return this;
    }

    public SuspendProcessesRequest withScalingProcesses(Collection<String> scalingProcesses) {
        this.setScalingProcesses(scalingProcesses);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.getAutoScalingGroupName()).append(",");
        }
        if (this.getScalingProcesses() != null) {
            sb.append("ScalingProcesses: ").append(this.getScalingProcesses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendProcessesRequest)) {
            return false;
        }
        SuspendProcessesRequest other = (SuspendProcessesRequest)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getScalingProcesses() == null ^ this.getScalingProcesses() == null) {
            return false;
        }
        return other.getScalingProcesses() == null || other.getScalingProcesses().equals(this.getScalingProcesses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getScalingProcesses() == null ? 0 : this.getScalingProcesses().hashCode());
        return hashCode;
    }

    public SuspendProcessesRequest clone() {
        return (SuspendProcessesRequest)super.clone();
    }
}

