/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DesiredConfiguration;
import com.amazonaws.services.autoscaling.model.InstancesDistribution;
import com.amazonaws.services.autoscaling.model.LaunchTemplate;
import com.amazonaws.services.autoscaling.model.LaunchTemplateOverrides;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.autoscaling.model.MixedInstancesPolicy;
import com.amazonaws.services.autoscaling.model.RefreshPreferences;
import com.amazonaws.services.autoscaling.model.StartInstanceRefreshRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class StartInstanceRefreshRequestMarshaller
implements Marshaller<Request<StartInstanceRefreshRequest>, StartInstanceRefreshRequest> {
    public Request<StartInstanceRefreshRequest> marshall(StartInstanceRefreshRequest startInstanceRefreshRequest) {
        RefreshPreferences preferences;
        DesiredConfiguration desiredConfiguration;
        if (startInstanceRefreshRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startInstanceRefreshRequest, "AmazonAutoScaling");
        request.addParameter("Action", "StartInstanceRefresh");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (startInstanceRefreshRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)startInstanceRefreshRequest.getAutoScalingGroupName()));
        }
        if (startInstanceRefreshRequest.getStrategy() != null) {
            request.addParameter("Strategy", StringUtils.fromString((String)startInstanceRefreshRequest.getStrategy()));
        }
        if ((desiredConfiguration = startInstanceRefreshRequest.getDesiredConfiguration()) != null) {
            MixedInstancesPolicy mixedInstancesPolicy;
            LaunchTemplateSpecification launchTemplate = desiredConfiguration.getLaunchTemplate();
            if (launchTemplate != null) {
                if (launchTemplate.getLaunchTemplateId() != null) {
                    request.addParameter("DesiredConfiguration.LaunchTemplate.LaunchTemplateId", StringUtils.fromString((String)launchTemplate.getLaunchTemplateId()));
                }
                if (launchTemplate.getLaunchTemplateName() != null) {
                    request.addParameter("DesiredConfiguration.LaunchTemplate.LaunchTemplateName", StringUtils.fromString((String)launchTemplate.getLaunchTemplateName()));
                }
                if (launchTemplate.getVersion() != null) {
                    request.addParameter("DesiredConfiguration.LaunchTemplate.Version", StringUtils.fromString((String)launchTemplate.getVersion()));
                }
            }
            if ((mixedInstancesPolicy = desiredConfiguration.getMixedInstancesPolicy()) != null) {
                InstancesDistribution instancesDistribution;
                LaunchTemplate launchTemplate2 = mixedInstancesPolicy.getLaunchTemplate();
                if (launchTemplate2 != null) {
                    LaunchTemplateSpecification launchTemplateSpecification = launchTemplate2.getLaunchTemplateSpecification();
                    if (launchTemplateSpecification != null) {
                        if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                            request.addParameter("DesiredConfiguration.MixedInstancesPolicy.LaunchTemplate.LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateId()));
                        }
                        if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                            request.addParameter("DesiredConfiguration.MixedInstancesPolicy.LaunchTemplate.LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateName()));
                        }
                        if (launchTemplateSpecification.getVersion() != null) {
                            request.addParameter("DesiredConfiguration.MixedInstancesPolicy.LaunchTemplate.LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification.getVersion()));
                        }
                    }
                    if (!launchTemplate2.getOverrides().isEmpty() || !((SdkInternalList)launchTemplate2.getOverrides()).isAutoConstruct()) {
                        SdkInternalList overridesList = (SdkInternalList)launchTemplate2.getOverrides();
                        int overridesListIndex = 1;
                        for (LaunchTemplateOverrides overridesListValue : overridesList) {
                            if (overridesListValue != null) {
                                LaunchTemplateSpecification launchTemplateSpecification2;
                                if (overridesListValue.getInstanceType() != null) {
                                    request.addParameter("DesiredConfiguration.MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceType", StringUtils.fromString((String)overridesListValue.getInstanceType()));
                                }
                                if (overridesListValue.getWeightedCapacity() != null) {
                                    request.addParameter("DesiredConfiguration.MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".WeightedCapacity", StringUtils.fromString((String)overridesListValue.getWeightedCapacity()));
                                }
                                if ((launchTemplateSpecification2 = overridesListValue.getLaunchTemplateSpecification()) != null) {
                                    if (launchTemplateSpecification2.getLaunchTemplateId() != null) {
                                        request.addParameter("DesiredConfiguration.MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification2.getLaunchTemplateId()));
                                    }
                                    if (launchTemplateSpecification2.getLaunchTemplateName() != null) {
                                        request.addParameter("DesiredConfiguration.MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification2.getLaunchTemplateName()));
                                    }
                                    if (launchTemplateSpecification2.getVersion() != null) {
                                        request.addParameter("DesiredConfiguration.MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification2.getVersion()));
                                    }
                                }
                            }
                            ++overridesListIndex;
                        }
                    }
                }
                if ((instancesDistribution = mixedInstancesPolicy.getInstancesDistribution()) != null) {
                    if (instancesDistribution.getOnDemandAllocationStrategy() != null) {
                        request.addParameter("DesiredConfiguration.MixedInstancesPolicy.InstancesDistribution.OnDemandAllocationStrategy", StringUtils.fromString((String)instancesDistribution.getOnDemandAllocationStrategy()));
                    }
                    if (instancesDistribution.getOnDemandBaseCapacity() != null) {
                        request.addParameter("DesiredConfiguration.MixedInstancesPolicy.InstancesDistribution.OnDemandBaseCapacity", StringUtils.fromInteger((Integer)instancesDistribution.getOnDemandBaseCapacity()));
                    }
                    if (instancesDistribution.getOnDemandPercentageAboveBaseCapacity() != null) {
                        request.addParameter("DesiredConfiguration.MixedInstancesPolicy.InstancesDistribution.OnDemandPercentageAboveBaseCapacity", StringUtils.fromInteger((Integer)instancesDistribution.getOnDemandPercentageAboveBaseCapacity()));
                    }
                    if (instancesDistribution.getSpotAllocationStrategy() != null) {
                        request.addParameter("DesiredConfiguration.MixedInstancesPolicy.InstancesDistribution.SpotAllocationStrategy", StringUtils.fromString((String)instancesDistribution.getSpotAllocationStrategy()));
                    }
                    if (instancesDistribution.getSpotInstancePools() != null) {
                        request.addParameter("DesiredConfiguration.MixedInstancesPolicy.InstancesDistribution.SpotInstancePools", StringUtils.fromInteger((Integer)instancesDistribution.getSpotInstancePools()));
                    }
                    if (instancesDistribution.getSpotMaxPrice() != null) {
                        request.addParameter("DesiredConfiguration.MixedInstancesPolicy.InstancesDistribution.SpotMaxPrice", StringUtils.fromString((String)instancesDistribution.getSpotMaxPrice()));
                    }
                }
            }
        }
        if ((preferences = startInstanceRefreshRequest.getPreferences()) != null) {
            if (preferences.getMinHealthyPercentage() != null) {
                request.addParameter("Preferences.MinHealthyPercentage", StringUtils.fromInteger((Integer)preferences.getMinHealthyPercentage()));
            }
            if (preferences.getInstanceWarmup() != null) {
                request.addParameter("Preferences.InstanceWarmup", StringUtils.fromInteger((Integer)preferences.getInstanceWarmup()));
            }
            if (!preferences.getCheckpointPercentages().isEmpty() || !((SdkInternalList)preferences.getCheckpointPercentages()).isAutoConstruct()) {
                SdkInternalList checkpointPercentagesList = (SdkInternalList)preferences.getCheckpointPercentages();
                int checkpointPercentagesListIndex = 1;
                for (Integer checkpointPercentagesListValue : checkpointPercentagesList) {
                    if (checkpointPercentagesListValue != null) {
                        request.addParameter("Preferences.CheckpointPercentages.member." + checkpointPercentagesListIndex, StringUtils.fromInteger((Integer)checkpointPercentagesListValue));
                    }
                    ++checkpointPercentagesListIndex;
                }
            }
            if (preferences.getCheckpointDelay() != null) {
                request.addParameter("Preferences.CheckpointDelay", StringUtils.fromInteger((Integer)preferences.getCheckpointDelay()));
            }
            if (preferences.getSkipMatching() != null) {
                request.addParameter("Preferences.SkipMatching", StringUtils.fromBoolean((Boolean)preferences.getSkipMatching()));
            }
        }
        return request;
    }
}

