/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.b2bi;

import javax.annotation.Generated;

import com.amazonaws.services.b2bi.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSB2Bi}. Convenient method forms pass through to the corresponding overload that
 * takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSB2Bi implements AWSB2Bi {

    protected AbstractAWSB2Bi() {
    }

    @Override
    public CreateCapabilityResult createCapability(CreateCapabilityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePartnershipResult createPartnership(CreatePartnershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProfileResult createProfile(CreateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTransformerResult createTransformer(CreateTransformerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCapabilityResult deleteCapability(DeleteCapabilityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePartnershipResult deletePartnership(DeletePartnershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProfileResult deleteProfile(DeleteProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTransformerResult deleteTransformer(DeleteTransformerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCapabilityResult getCapability(GetCapabilityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPartnershipResult getPartnership(GetPartnershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProfileResult getProfile(GetProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTransformerResult getTransformer(GetTransformerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTransformerJobResult getTransformerJob(GetTransformerJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCapabilitiesResult listCapabilities(ListCapabilitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPartnershipsResult listPartnerships(ListPartnershipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProfilesResult listProfiles(ListProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTransformersResult listTransformers(ListTransformersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartTransformerJobResult startTransformerJob(StartTransformerJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TestMappingResult testMapping(TestMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TestParsingResult testParsing(TestParsingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCapabilityResult updateCapability(UpdateCapabilityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePartnershipResult updatePartnership(UpdatePartnershipRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProfileResult updateProfile(UpdateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTransformerResult updateTransformer(UpdateTransformerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
