/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chime.model.Capability;
import com.amazonaws.services.chime.model.GeoMatchLevel;
import com.amazonaws.services.chime.model.GeoMatchParams;
import com.amazonaws.services.chime.model.NumberSelectionBehavior;
import com.amazonaws.services.chime.model.Participant;
import com.amazonaws.services.chime.model.ProxySessionStatus;
import com.amazonaws.services.chime.model.transform.ProxySessionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ProxySession
implements Serializable,
Cloneable,
StructuredPojo {
    private String voiceConnectorId;
    private String proxySessionId;
    private String name;
    private String status;
    private Integer expiryMinutes;
    private List<String> capabilities;
    private Date createdTimestamp;
    private Date updatedTimestamp;
    private Date endedTimestamp;
    private List<Participant> participants;
    private String numberSelectionBehavior;
    private String geoMatchLevel;
    private GeoMatchParams geoMatchParams;

    public void setVoiceConnectorId(String voiceConnectorId) {
        this.voiceConnectorId = voiceConnectorId;
    }

    public String getVoiceConnectorId() {
        return this.voiceConnectorId;
    }

    public ProxySession withVoiceConnectorId(String voiceConnectorId) {
        this.setVoiceConnectorId(voiceConnectorId);
        return this;
    }

    public void setProxySessionId(String proxySessionId) {
        this.proxySessionId = proxySessionId;
    }

    public String getProxySessionId() {
        return this.proxySessionId;
    }

    public ProxySession withProxySessionId(String proxySessionId) {
        this.setProxySessionId(proxySessionId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ProxySession withName(String name) {
        this.setName(name);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ProxySession withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ProxySession withStatus(ProxySessionStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setExpiryMinutes(Integer expiryMinutes) {
        this.expiryMinutes = expiryMinutes;
    }

    public Integer getExpiryMinutes() {
        return this.expiryMinutes;
    }

    public ProxySession withExpiryMinutes(Integer expiryMinutes) {
        this.setExpiryMinutes(expiryMinutes);
        return this;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new ArrayList<String>(capabilities);
    }

    public ProxySession withCapabilities(String ... capabilities) {
        if (this.capabilities == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String ele : capabilities) {
            this.capabilities.add(ele);
        }
        return this;
    }

    public ProxySession withCapabilities(Collection<String> capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public ProxySession withCapabilities(Capability ... capabilities) {
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.length);
        for (Capability value : capabilities) {
            capabilitiesCopy.add(value.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities(capabilitiesCopy);
        } else {
            this.getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    public void setCreatedTimestamp(Date createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public ProxySession withCreatedTimestamp(Date createdTimestamp) {
        this.setCreatedTimestamp(createdTimestamp);
        return this;
    }

    public void setUpdatedTimestamp(Date updatedTimestamp) {
        this.updatedTimestamp = updatedTimestamp;
    }

    public Date getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public ProxySession withUpdatedTimestamp(Date updatedTimestamp) {
        this.setUpdatedTimestamp(updatedTimestamp);
        return this;
    }

    public void setEndedTimestamp(Date endedTimestamp) {
        this.endedTimestamp = endedTimestamp;
    }

    public Date getEndedTimestamp() {
        return this.endedTimestamp;
    }

    public ProxySession withEndedTimestamp(Date endedTimestamp) {
        this.setEndedTimestamp(endedTimestamp);
        return this;
    }

    public List<Participant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(Collection<Participant> participants) {
        if (participants == null) {
            this.participants = null;
            return;
        }
        this.participants = new ArrayList<Participant>(participants);
    }

    public ProxySession withParticipants(Participant ... participants) {
        if (this.participants == null) {
            this.setParticipants(new ArrayList<Participant>(participants.length));
        }
        for (Participant ele : participants) {
            this.participants.add(ele);
        }
        return this;
    }

    public ProxySession withParticipants(Collection<Participant> participants) {
        this.setParticipants(participants);
        return this;
    }

    public void setNumberSelectionBehavior(String numberSelectionBehavior) {
        this.numberSelectionBehavior = numberSelectionBehavior;
    }

    public String getNumberSelectionBehavior() {
        return this.numberSelectionBehavior;
    }

    public ProxySession withNumberSelectionBehavior(String numberSelectionBehavior) {
        this.setNumberSelectionBehavior(numberSelectionBehavior);
        return this;
    }

    public ProxySession withNumberSelectionBehavior(NumberSelectionBehavior numberSelectionBehavior) {
        this.numberSelectionBehavior = numberSelectionBehavior.toString();
        return this;
    }

    public void setGeoMatchLevel(String geoMatchLevel) {
        this.geoMatchLevel = geoMatchLevel;
    }

    public String getGeoMatchLevel() {
        return this.geoMatchLevel;
    }

    public ProxySession withGeoMatchLevel(String geoMatchLevel) {
        this.setGeoMatchLevel(geoMatchLevel);
        return this;
    }

    public ProxySession withGeoMatchLevel(GeoMatchLevel geoMatchLevel) {
        this.geoMatchLevel = geoMatchLevel.toString();
        return this;
    }

    public void setGeoMatchParams(GeoMatchParams geoMatchParams) {
        this.geoMatchParams = geoMatchParams;
    }

    public GeoMatchParams getGeoMatchParams() {
        return this.geoMatchParams;
    }

    public ProxySession withGeoMatchParams(GeoMatchParams geoMatchParams) {
        this.setGeoMatchParams(geoMatchParams);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVoiceConnectorId() != null) {
            sb.append("VoiceConnectorId: ").append(this.getVoiceConnectorId()).append(",");
        }
        if (this.getProxySessionId() != null) {
            sb.append("ProxySessionId: ").append(this.getProxySessionId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getExpiryMinutes() != null) {
            sb.append("ExpiryMinutes: ").append(this.getExpiryMinutes()).append(",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getCreatedTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.getCreatedTimestamp()).append(",");
        }
        if (this.getUpdatedTimestamp() != null) {
            sb.append("UpdatedTimestamp: ").append(this.getUpdatedTimestamp()).append(",");
        }
        if (this.getEndedTimestamp() != null) {
            sb.append("EndedTimestamp: ").append(this.getEndedTimestamp()).append(",");
        }
        if (this.getParticipants() != null) {
            sb.append("Participants: ").append(this.getParticipants()).append(",");
        }
        if (this.getNumberSelectionBehavior() != null) {
            sb.append("NumberSelectionBehavior: ").append(this.getNumberSelectionBehavior()).append(",");
        }
        if (this.getGeoMatchLevel() != null) {
            sb.append("GeoMatchLevel: ").append(this.getGeoMatchLevel()).append(",");
        }
        if (this.getGeoMatchParams() != null) {
            sb.append("GeoMatchParams: ").append(this.getGeoMatchParams());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxySession)) {
            return false;
        }
        ProxySession other = (ProxySession)obj;
        if (other.getVoiceConnectorId() == null ^ this.getVoiceConnectorId() == null) {
            return false;
        }
        if (other.getVoiceConnectorId() != null && !other.getVoiceConnectorId().equals(this.getVoiceConnectorId())) {
            return false;
        }
        if (other.getProxySessionId() == null ^ this.getProxySessionId() == null) {
            return false;
        }
        if (other.getProxySessionId() != null && !other.getProxySessionId().equals(this.getProxySessionId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getExpiryMinutes() == null ^ this.getExpiryMinutes() == null) {
            return false;
        }
        if (other.getExpiryMinutes() != null && !other.getExpiryMinutes().equals(this.getExpiryMinutes())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getCreatedTimestamp() == null ^ this.getCreatedTimestamp() == null) {
            return false;
        }
        if (other.getCreatedTimestamp() != null && !other.getCreatedTimestamp().equals(this.getCreatedTimestamp())) {
            return false;
        }
        if (other.getUpdatedTimestamp() == null ^ this.getUpdatedTimestamp() == null) {
            return false;
        }
        if (other.getUpdatedTimestamp() != null && !other.getUpdatedTimestamp().equals(this.getUpdatedTimestamp())) {
            return false;
        }
        if (other.getEndedTimestamp() == null ^ this.getEndedTimestamp() == null) {
            return false;
        }
        if (other.getEndedTimestamp() != null && !other.getEndedTimestamp().equals(this.getEndedTimestamp())) {
            return false;
        }
        if (other.getParticipants() == null ^ this.getParticipants() == null) {
            return false;
        }
        if (other.getParticipants() != null && !other.getParticipants().equals(this.getParticipants())) {
            return false;
        }
        if (other.getNumberSelectionBehavior() == null ^ this.getNumberSelectionBehavior() == null) {
            return false;
        }
        if (other.getNumberSelectionBehavior() != null && !other.getNumberSelectionBehavior().equals(this.getNumberSelectionBehavior())) {
            return false;
        }
        if (other.getGeoMatchLevel() == null ^ this.getGeoMatchLevel() == null) {
            return false;
        }
        if (other.getGeoMatchLevel() != null && !other.getGeoMatchLevel().equals(this.getGeoMatchLevel())) {
            return false;
        }
        if (other.getGeoMatchParams() == null ^ this.getGeoMatchParams() == null) {
            return false;
        }
        return other.getGeoMatchParams() == null || other.getGeoMatchParams().equals(this.getGeoMatchParams());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVoiceConnectorId() == null ? 0 : this.getVoiceConnectorId().hashCode());
        hashCode = 31 * hashCode + (this.getProxySessionId() == null ? 0 : this.getProxySessionId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getExpiryMinutes() == null ? 0 : this.getExpiryMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTimestamp() == null ? 0 : this.getCreatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedTimestamp() == null ? 0 : this.getUpdatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getEndedTimestamp() == null ? 0 : this.getEndedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getParticipants() == null ? 0 : this.getParticipants().hashCode());
        hashCode = 31 * hashCode + (this.getNumberSelectionBehavior() == null ? 0 : this.getNumberSelectionBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getGeoMatchLevel() == null ? 0 : this.getGeoMatchLevel().hashCode());
        hashCode = 31 * hashCode + (this.getGeoMatchParams() == null ? 0 : this.getGeoMatchParams().hashCode());
        return hashCode;
    }

    public ProxySession clone() {
        try {
            return (ProxySession)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProxySessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

