/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.chime.model.CandidateAddress;

@SdkInternalApi
public class CandidateAddressMarshaller {
    private static final MarshallingInfo<String> STREETINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streetInfo").build();
    private static final MarshallingInfo<String> STREETNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streetNumber").build();
    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("city").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<String> POSTALCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("postalCode").build();
    private static final MarshallingInfo<String> POSTALCODEPLUS4_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("postalCodePlus4").build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("country").build();
    private static final CandidateAddressMarshaller instance = new CandidateAddressMarshaller();

    public static CandidateAddressMarshaller getInstance() {
        return instance;
    }

    public void marshall(CandidateAddress candidateAddress, ProtocolMarshaller protocolMarshaller) {
        if (candidateAddress == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)candidateAddress.getStreetInfo(), STREETINFO_BINDING);
            protocolMarshaller.marshall((Object)candidateAddress.getStreetNumber(), STREETNUMBER_BINDING);
            protocolMarshaller.marshall((Object)candidateAddress.getCity(), CITY_BINDING);
            protocolMarshaller.marshall((Object)candidateAddress.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)candidateAddress.getPostalCode(), POSTALCODE_BINDING);
            protocolMarshaller.marshall((Object)candidateAddress.getPostalCodePlus4(), POSTALCODEPLUS4_BINDING);
            protocolMarshaller.marshall((Object)candidateAddress.getCountry(), COUNTRY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

