/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cleanrooms.model.AnalysisFormat;
import com.amazonaws.services.cleanrooms.model.AnalysisParameter;
import com.amazonaws.services.cleanrooms.model.AnalysisSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateAnalysisTemplateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private String membershipIdentifier;
    private String name;
    private String format;
    private AnalysisSource source;
    private Map<String, String> tags;
    private List<AnalysisParameter> analysisParameters;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateAnalysisTemplateRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setMembershipIdentifier(String membershipIdentifier) {
        this.membershipIdentifier = membershipIdentifier;
    }

    public String getMembershipIdentifier() {
        return this.membershipIdentifier;
    }

    public CreateAnalysisTemplateRequest withMembershipIdentifier(String membershipIdentifier) {
        this.setMembershipIdentifier(membershipIdentifier);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateAnalysisTemplateRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public CreateAnalysisTemplateRequest withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public CreateAnalysisTemplateRequest withFormat(AnalysisFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setSource(AnalysisSource source) {
        this.source = source;
    }

    public AnalysisSource getSource() {
        return this.source;
    }

    public CreateAnalysisTemplateRequest withSource(AnalysisSource source) {
        this.setSource(source);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateAnalysisTemplateRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateAnalysisTemplateRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateAnalysisTemplateRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<AnalysisParameter> getAnalysisParameters() {
        return this.analysisParameters;
    }

    public void setAnalysisParameters(Collection<AnalysisParameter> analysisParameters) {
        if (analysisParameters == null) {
            this.analysisParameters = null;
            return;
        }
        this.analysisParameters = new ArrayList<AnalysisParameter>(analysisParameters);
    }

    public CreateAnalysisTemplateRequest withAnalysisParameters(AnalysisParameter ... analysisParameters) {
        if (this.analysisParameters == null) {
            this.setAnalysisParameters(new ArrayList<AnalysisParameter>(analysisParameters.length));
        }
        for (AnalysisParameter ele : analysisParameters) {
            this.analysisParameters.add(ele);
        }
        return this;
    }

    public CreateAnalysisTemplateRequest withAnalysisParameters(Collection<AnalysisParameter> analysisParameters) {
        this.setAnalysisParameters(analysisParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getMembershipIdentifier() != null) {
            sb.append("MembershipIdentifier: ").append(this.getMembershipIdentifier()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAnalysisParameters() != null) {
            sb.append("AnalysisParameters: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalysisTemplateRequest)) {
            return false;
        }
        CreateAnalysisTemplateRequest other = (CreateAnalysisTemplateRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getMembershipIdentifier() == null ^ this.getMembershipIdentifier() == null) {
            return false;
        }
        if (other.getMembershipIdentifier() != null && !other.getMembershipIdentifier().equals(this.getMembershipIdentifier())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAnalysisParameters() == null ^ this.getAnalysisParameters() == null) {
            return false;
        }
        return other.getAnalysisParameters() == null || other.getAnalysisParameters().equals(this.getAnalysisParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getMembershipIdentifier() == null ? 0 : this.getMembershipIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAnalysisParameters() == null ? 0 : this.getAnalysisParameters().hashCode());
        return hashCode;
    }

    public CreateAnalysisTemplateRequest clone() {
        return (CreateAnalysisTemplateRequest)super.clone();
    }
}

