/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudcontrolapi;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudcontrolapi.AWSCloudControlApiAsync;
import com.amazonaws.services.cloudcontrolapi.AWSCloudControlApiAsyncClientBuilder;
import com.amazonaws.services.cloudcontrolapi.AWSCloudControlApiClient;
import com.amazonaws.services.cloudcontrolapi.model.CancelResourceRequestRequest;
import com.amazonaws.services.cloudcontrolapi.model.CancelResourceRequestResult;
import com.amazonaws.services.cloudcontrolapi.model.CreateResourceRequest;
import com.amazonaws.services.cloudcontrolapi.model.CreateResourceResult;
import com.amazonaws.services.cloudcontrolapi.model.DeleteResourceRequest;
import com.amazonaws.services.cloudcontrolapi.model.DeleteResourceResult;
import com.amazonaws.services.cloudcontrolapi.model.GetResourceRequest;
import com.amazonaws.services.cloudcontrolapi.model.GetResourceRequestStatusRequest;
import com.amazonaws.services.cloudcontrolapi.model.GetResourceRequestStatusResult;
import com.amazonaws.services.cloudcontrolapi.model.GetResourceResult;
import com.amazonaws.services.cloudcontrolapi.model.ListResourceRequestsRequest;
import com.amazonaws.services.cloudcontrolapi.model.ListResourceRequestsResult;
import com.amazonaws.services.cloudcontrolapi.model.ListResourcesRequest;
import com.amazonaws.services.cloudcontrolapi.model.ListResourcesResult;
import com.amazonaws.services.cloudcontrolapi.model.UpdateResourceRequest;
import com.amazonaws.services.cloudcontrolapi.model.UpdateResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCloudControlApiAsyncClient
extends AWSCloudControlApiClient
implements AWSCloudControlApiAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCloudControlApiAsyncClientBuilder asyncBuilder() {
        return AWSCloudControlApiAsyncClientBuilder.standard();
    }

    AWSCloudControlApiAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSCloudControlApiAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelResourceRequestResult> cancelResourceRequestAsync(CancelResourceRequestRequest request) {
        return this.cancelResourceRequestAsync(request, null);
    }

    @Override
    public Future<CancelResourceRequestResult> cancelResourceRequestAsync(CancelResourceRequestRequest request, final AsyncHandler<CancelResourceRequestRequest, CancelResourceRequestResult> asyncHandler) {
        final CancelResourceRequestRequest finalRequest = (CancelResourceRequestRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelResourceRequestResult>(){

            @Override
            public CancelResourceRequestResult call() throws Exception {
                CancelResourceRequestResult result = null;
                try {
                    result = AWSCloudControlApiAsyncClient.this.executeCancelResourceRequest(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateResourceResult> createResourceAsync(CreateResourceRequest request) {
        return this.createResourceAsync(request, null);
    }

    @Override
    public Future<CreateResourceResult> createResourceAsync(CreateResourceRequest request, final AsyncHandler<CreateResourceRequest, CreateResourceResult> asyncHandler) {
        final CreateResourceRequest finalRequest = (CreateResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateResourceResult>(){

            @Override
            public CreateResourceResult call() throws Exception {
                CreateResourceResult result = null;
                try {
                    result = AWSCloudControlApiAsyncClient.this.executeCreateResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteResourceResult> deleteResourceAsync(DeleteResourceRequest request) {
        return this.deleteResourceAsync(request, null);
    }

    @Override
    public Future<DeleteResourceResult> deleteResourceAsync(DeleteResourceRequest request, final AsyncHandler<DeleteResourceRequest, DeleteResourceResult> asyncHandler) {
        final DeleteResourceRequest finalRequest = (DeleteResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteResourceResult>(){

            @Override
            public DeleteResourceResult call() throws Exception {
                DeleteResourceResult result = null;
                try {
                    result = AWSCloudControlApiAsyncClient.this.executeDeleteResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceResult> getResourceAsync(GetResourceRequest request) {
        return this.getResourceAsync(request, null);
    }

    @Override
    public Future<GetResourceResult> getResourceAsync(GetResourceRequest request, final AsyncHandler<GetResourceRequest, GetResourceResult> asyncHandler) {
        final GetResourceRequest finalRequest = (GetResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceResult>(){

            @Override
            public GetResourceResult call() throws Exception {
                GetResourceResult result = null;
                try {
                    result = AWSCloudControlApiAsyncClient.this.executeGetResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceRequestStatusResult> getResourceRequestStatusAsync(GetResourceRequestStatusRequest request) {
        return this.getResourceRequestStatusAsync(request, null);
    }

    @Override
    public Future<GetResourceRequestStatusResult> getResourceRequestStatusAsync(GetResourceRequestStatusRequest request, final AsyncHandler<GetResourceRequestStatusRequest, GetResourceRequestStatusResult> asyncHandler) {
        final GetResourceRequestStatusRequest finalRequest = (GetResourceRequestStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceRequestStatusResult>(){

            @Override
            public GetResourceRequestStatusResult call() throws Exception {
                GetResourceRequestStatusResult result = null;
                try {
                    result = AWSCloudControlApiAsyncClient.this.executeGetResourceRequestStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourceRequestsResult> listResourceRequestsAsync(ListResourceRequestsRequest request) {
        return this.listResourceRequestsAsync(request, null);
    }

    @Override
    public Future<ListResourceRequestsResult> listResourceRequestsAsync(ListResourceRequestsRequest request, final AsyncHandler<ListResourceRequestsRequest, ListResourceRequestsResult> asyncHandler) {
        final ListResourceRequestsRequest finalRequest = (ListResourceRequestsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourceRequestsResult>(){

            @Override
            public ListResourceRequestsResult call() throws Exception {
                ListResourceRequestsResult result = null;
                try {
                    result = AWSCloudControlApiAsyncClient.this.executeListResourceRequests(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request) {
        return this.listResourcesAsync(request, null);
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request, final AsyncHandler<ListResourcesRequest, ListResourcesResult> asyncHandler) {
        final ListResourcesRequest finalRequest = (ListResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourcesResult>(){

            @Override
            public ListResourcesResult call() throws Exception {
                ListResourcesResult result = null;
                try {
                    result = AWSCloudControlApiAsyncClient.this.executeListResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateResourceResult> updateResourceAsync(UpdateResourceRequest request) {
        return this.updateResourceAsync(request, null);
    }

    @Override
    public Future<UpdateResourceResult> updateResourceAsync(UpdateResourceRequest request, final AsyncHandler<UpdateResourceRequest, UpdateResourceResult> asyncHandler) {
        final UpdateResourceRequest finalRequest = (UpdateResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateResourceResult>(){

            @Override
            public UpdateResourceResult call() throws Exception {
                UpdateResourceResult result = null;
                try {
                    result = AWSCloudControlApiAsyncClient.this.executeUpdateResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

