/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.clouddirectory.model.Directory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDirectoriesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Directory> directories;
    private String nextToken;

    public List<Directory> getDirectories() {
        return this.directories;
    }

    public void setDirectories(Collection<Directory> directories) {
        if (directories == null) {
            this.directories = null;
            return;
        }
        this.directories = new ArrayList<Directory>(directories);
    }

    public ListDirectoriesResult withDirectories(Directory ... directories) {
        if (this.directories == null) {
            this.setDirectories(new ArrayList<Directory>(directories.length));
        }
        for (Directory ele : directories) {
            this.directories.add(ele);
        }
        return this;
    }

    public ListDirectoriesResult withDirectories(Collection<Directory> directories) {
        this.setDirectories(directories);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDirectoriesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectories() != null) {
            sb.append("Directories: ").append(this.getDirectories()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDirectoriesResult)) {
            return false;
        }
        ListDirectoriesResult other = (ListDirectoriesResult)obj;
        if (other.getDirectories() == null ^ this.getDirectories() == null) {
            return false;
        }
        if (other.getDirectories() != null && !other.getDirectories().equals(this.getDirectories())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectories() == null ? 0 : this.getDirectories().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDirectoriesResult clone() {
        try {
            return (ListDirectoriesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

